/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *       Copyright (c) 1987-1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Test preclipping in draw_polyline function.  This program generates
 *   a series of lines having more-or-less random endpoints.  The
 *   lines are defined by two moving points that move in straight lines
 *   until they bounce off the sides of the screen.  At regular
 *   intervals, lines are drawn between the two moving points.
 *
 *   Each line is drawn twice.  The first time, the clipping window is
 *   the entire screen, and the lines are drawn in white.  The second
 *   time, the clipping window is a rectangular region in the middle of
 *   the screen, and the lines are drawn in red.  The red lines in the
 *   smaller window should fall precisely on top of the white lines; the
 *   test demonstrates that within the clipping window the red, clipped
 *   lines drawn by the draw_polyline routine duplicate the white,
 *   unclipped lines exactly.
 *----------------------------------------------------------------------
 * Revision History:
 *   03/23/87...Original version written...................J.R. Van Aken
 *   03/27/90...Modified for general portability...........J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>
#include "colors.h"

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	     /* default graphics mode */
#endif

#define NPOINTS     122      /* number of line endpoints */

static	CONFIG cfg;


main()
{
    short xy[2*NPOINTS], *xyptr;
    int hres, vres, i, w, x1, y1, vx1, vy1, x2, y2, vx2, vy2;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */

    /* Define initial positions and velocities of line endpoints. */
    x1 = y1 = x2 = y2 = 0;
    vx1 = hres/20;
    vy1 = vres/36;
    vx2 = hres/80;
    vy2 = vres/17;
    w = vres/120;

    for (;;) {
	/* Set clip window to full screen. */
	set_clip_rect(hres, vres, 0, 0);

	/* Calculate endpoints of new polyline. */
	xyptr = xy;
	for (i = NPOINTS/2; i != 0; i--) {
	    if (cpw(x1 += vx1, 0))
		vx1 = -vx1;
	    if (cpw(0, y1 += vy1))
		vy1 = -vy1;
	    if (cpw(x2 += vx2, 0))
		vx2 = -vx2;
	    if (cpw(0, y2 += vy2))
		vy2 = -vy2;
	    *xyptr++ = x1;
	    *xyptr++ = y1;
	    *xyptr++ = x2;
	    *xyptr++ = y2;
	}

	/* Draw new polyline clipped to full screen. */
	clear_screen(-1);
	set_fcolor(DARK_GRAY);
	frame_rect(hres/2, vres/2, hres/4, vres/4, w, w);
	set_fcolor(WHITE);
	draw_polyline(NPOINTS, xy);

	/* Draw new polyline clipped to window in center of screen. */
	if (cfg.mode.disp_psize >= 4) {    /* Got enough colors? */
	    set_clip_rect(hres/2, vres/2, hres/4, vres/4);
	    set_fcolor(LIGHT_RED);
	    draw_polyline(NPOINTS, xy);
	}

	for (i = 120; i; i--)	    /* 2-second delay */
	    wait_scan(vres);
    }
}

