;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1988-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Extension                                     ;
;-------------------------------------------------------------------------;
;   name            set_patn                                              ;
;                                                                         ;
;   synopsis        void set_patn( addr )                                 ;
;                   unsigned long addr;     address of pattern struct     ;
;                                                                         ;
;   description     The set_patn() function copies the pattern structure  ;
;                   information pointed to by addr into the local GSP     ;
;                   pattern structure.  This pattern information is then  ;
;                   used in subsequent pattern drawing functions.         ;
;-------------------------------------------------------------------------;
        .title    'set pattern information'
        .file     'setpatn.asm'
;
;   Declare globals
;
        .globl    _set_patn
        .globl    _dm_set_patn
;
;   External References
;
        .globl  _patn_line
;
;   Include external defs
;
       .include   gsptypes.inc
       .include   gspglobs.inc          
       .include   gspreg.inc
        .mlib     gspmac.lib   ;macros
;
;   Direct-mode entry point
;
_dm_set_patn:
        Push    A0              ;Save used registers
        Push    A1
        Popc    A8              ;Get pointer to dm data area
        addk    16,A8           ;Skip 1st word (# of bytes)
common_ep:
        movi    _pattern,A0     ;Load address of local pattern struct
        movi    PATTERN_HSRV,A1    ;Sizeof struct in bits
        srl     3,A1            ;Convert to bytes
        setf    8,0,0           ;Copy a byte at a time
copy_it:
        move    *A8+,*A0+,0
        dsjs    A1,copy_it      ;Continue for all bytes in structure
        movi    _patn_line,A8   ;Load address of horz pattern service routine
        move    A8,@(_pattern+PATTERN_HSRV),1
        clr     A8              ;Load address of general fill routine
        move    A8,@(_pattern+PATTERN_SRV),1
        Pop     A1              ;Restore used registers
        Pop     A0
        rets    2               ;Return to calling routine
;
;   C-packet entry point
;
_set_patn:
        Push    A0              ;Save used registers
        Push    A1
        Popc    A8              ;Get pointer to pattern structure
        jruc    common_ep       ;Continue processing   
        .end
