/*-----------------------------------------------------------------------*/
/*                                  TIGA                                 */
/*       Copyright (c) 1989-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TIGA - Graphics Manager Core                                         */
/*-----------------------------------------------------------------------*/
/*  int  get_fontinfo(id, fontinfo)                                      */
/*  short      id;                                                       */
/*  FONTINFO *fontinfo;                                                  */
/*                                                                       */
/*  This function returns the fontinfo structure for the font of the     */
/*  specified ID. The ID must be one of the following:                   */
/*                                                                       */
/*  1. 0, indicating the system font.                                    */
/*  2. 1 thru N, as returned by install_font                             */
/*  3. -1, indicating to use the ID of the font selected for rendering   */
/*                                                                       */
/*  Returns nonzero if successful, zero otherwise                        */
/*-----------------------------------------------------------------------*/
/* 01/20/89   Original Version Written                   J.G.Littleton   */
/* 03/21/90   Default char now returned                  JGL             */
/*-----------------------------------------------------------------------*/

#include <gsptypes.h>
#include <gspglobs.h>

int get_fontinfo( id, pd )
register int id;
register FONTINFO *pd;
{
    register FONT *ps;
    register int  i;

    /*------------------------------------------------------------------*/
    /*  If the requested ID is -1, then return fontinfo for the font    */
    /*  currently selected.                                             */
    /*------------------------------------------------------------------*/
    if (id == -1)
    {
        if (envtext.selected == sysfont)
            id = 0;
        else
        {
            for (i = 0;i < envtext.installed;i++)
                if (envtext.selected == *(envtext.font+i))
                {
                    id = i+1;
                    break;
                }
        }
    }
    
    if (!id)
      ps = sysfont;
    else
      ps = *(envtext.font + id - 1);
                             
    if (id < 0 || id > envtext.installed || (!ps))
        return (0);

    strcpy(pd->facename, ps->facename);
    pd->first     = ps->first;
    pd->last      = ps->last;     
    pd->deflt     = ps->deflt;     
    pd->maxwide   = ps->maxwide;
    pd->avgwide   = ps->avgwide;
    pd->maxkern   = ps->maxkern;
    pd->charwide  = ps->charwide;     
    pd->charhigh  = ps->charhigh;     
    pd->ascent    = ps->ascent;       
    pd->descent   = ps->descent;      
    pd->leading   = ps->leading;
    pd->fontptr   = ps;
    pd->id        = id;
    return (1);
}

