;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1988-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;                                                                         ;
;   void get_colors(*fcol, *bcol)                                         ;
;                                                                         ;
;   Return the index of the color stored in COLOR1/COLOR0, zero extended  ;
;   by the pixel size.                                .                   ;
;                                                                         ;
;   Example: If COLOR1 is 0x55555555 and PSIZE is 4, the fcol returned    ;
;            would be 4.                                                  ;
;                                                                         ;
;   Notes: A8 is destroyed                                                ;
;-------------------------------------------------------------------------;
;   9/17/88  Original version written                      Graham Short   ;
;-------------------------------------------------------------------------;
;
;   Include GSP register definitions
        include  gspreg.inc
;
;   Declare function names
        def     _get_colors
;
_get_colors:
        mmtm    SP,B0,B1,B2,B3
        movk    1,B0
        cvxyl   B0,B0             ;get pixel size
        sub     OFFSET,B0         ;subtract off offset
        exgf    B0,0              ;get pixel size as FS0
        move    COLOR1,B1         ;save colors
        move    COLOR0,B2         ;
        zext    B1,0              ;convert from replicated colors to
        zext    B2,0              ;a color index
        setf    16,0,0            ;
        move    STK,B3            ;
        move    *-B3,B0,1         ;get pointer to foreground color
        move    B1,*B0,1          ;return foreground color index
        move    *-B3,B0,1         ;get pointer to background color
        move    B2,*B0,1          ;return background color index
        move    B3,STK            ;
        mmfm    SP,B0,B1,B2,B3
        rets    2

