

;-------------------------------------------------------------
;
;	SUSPEND.ASM: This file contains routines that handle
;	suspend requests
;
;	Author:	Desmond Yuen
;
;	Date: Oct 12th, 1991
;
;	Revision History:
;
;	Copyright 1992 by McGraw-Hill, Inc. All rights reserved.
;
;------------------------------------------------------------------

Include Superset.inc

code	segment	public	'code'
	assume	cs:code

PUBLIC	suspend, resume, tst_buf

EXTRN   open_360sl:near, read_360sl:near, write_360sl:near, close_360sl:near
EXTRN   open_ibu:near, close_386sl:near, devices_off:near, devices_on:near

; Equates for keyboard interface

KBD_CMD		EQU	60H	; keyboard command port
KBD_STAT	EQU	64H	; keyboard status port


.386p


;-------------------------------------------------------------
;
;       suspend: Suspend the system
;
;       Input:  None
;
;       Output: None
;
;-------------------------------------------------------------

suspend	proc near

; disable BIOS shadowing


        call	open_ibu
        mov     ax, 0AAAAH		; disable BIOS shadowing for 
					; 0F000 segement
        mov     dx, OMSECR
        out     dx, ax
        jmp     $+2                     
        mov     dx, OMSFCR
        out     dx, ax
        jmp     $+2                     
	call    close_386sl

	call	devices_off		; turn off some devices to save power
	
	mov	al, 07fh		; set suspend flag in XCMOS RAM
	out	XCMOS_INDEX, al
	jmp	$+2
	jmp	$+2
	mov	al, 08h
	out	XCMOS_DATA, al
	jmp	$+2
	jmp	$+2

	call    open_360sl              ; enable 360sl space

	mov	bl, SM_REQ_CNTRL	; reset power management hardware
	mov	bh, 00h
	call	write_360sl		; disable all SMIs
	jmp	$+2
	jmp	$+2
	mov	bh, 080h
	call	write_360sl		; disable all SMIs

        mov     bl, SPND_STS		; clear suspend request bit
        xor     bh, bh
        call    write_360sl

        mov     bl, SM_REQ_STS		; clear suspend request bit
        xor     bh, bh
        call    write_360sl

        mov     bl, RESUME_MASK		; disable all resume events
        xor     bh, 07h
        call    write_360sl

        mov     al,SUS_REF		; enable suspend refresh
	out	24h,al
        jmp     $+2                     
        jmp     $+2                     
        jmp     $+2                     
	call    open_ibu
        mov     al, 82h
        out     OMSR, al        	; enable suspend refresh
        jmp     $+2                     
        jmp     $+2                     
        hlt                     	; stop CPU

        ret

suspend	endp                

;-------------------------------------------------------------
;
;       resume: resume the system
;
;       Input:  None
;
;       Output: None
;
;-------------------------------------------------------------

resume	proc near

; re-enable BIOS shadowing

	mov	al, 0eah
	out	80h, al
	
        call	open_ibu
        mov     ax, 05555H		; re-enable BIOS shadowing for 
					; 0F000 segment
        mov     dx, OMSECR
        out     dx, ax
        jmp     $+2                     
        jmp     $+2                     
        mov     dx, OMSFCR
        out     dx, ax
        jmp     $+2                     
        jmp     $+2                     
	call    close_386sl

	mov	al, 07fh		; clear suspend flag
	out	XCMOS_INDEX, al
	jmp	$+2
	jmp	$+2
	mov	al, 00h
	out	XCMOS_DATA, al
	jmp	$+2
	jmp	$+2


	call	devices_on		; re-enable powered off devices

	call	kbd_stst		; reset 8042 keyboard controller
	call	kbd_rst			; re-initialize the keyboard
	
	mov	al, 0edh		; resume completion code
	out	80h, al
        ret

resume	endp           


;-------------------------------------------------------------
;
;       kbd_stst: keyboard controller selftest
;
;       Input:  None
;
;       Output: None
;
;-------------------------------------------------------------


kbd_stst proc near

        cli
        
        mov     bx,3
        xor	cx, cx
dummy:
        loop    $
        dec     bx
        jnz     dummy

stst0:
	in	al, KBD_STAT
	test	al, 03h			; are input & output buffers empty
	jz	stst1
	in	al, KBD_CMD		; flush data
	loop	stst0

        mov     al,0C1h
        out     80h,al          	; Time out in keyboard
        jmp      $

stst1:
	mov	al, 0aah		; selftest command
	out	KBD_STAT, al	

        mov     al,0c2h
        out     80h,al
stst1_1:
        in      al,KBD_STAT
        test    al,02           	; KBC accept?
        jnz     Stst1_1


        mov     al,0c3h
        out     80h,al
	xor	cx, cx	
stst2:
	in	al, KBD_STAT
	test	al, 1			; is ontput buffer full
        jz      stst2           

stst3:
	in	al, KBD_CMD
	cmp	al, 55h
        jne     stst0              
	ret
kbd_stst endp


;-------------------------------------------------------------
;
;       kbd_rst: reset keyboard
;
;       Input:  None
;
;       Output: None
;
;-------------------------------------------------------------


kbd_rst proc near
	cli

rst:
        mov     al,0C4h			; post code 
        out     80h,al
here0:
        in      al,KBD_CMD
        jmp     $+2
        jmp     $+2
        in      al,KBD_STAT
        test    al,3
        jnz     here0

	mov	al, 0ffh                ;reset keyboard
	out	KBD_CMD, al
	jmp	$+2

        mov     al,0c5h
        out     80h,al
here1:                                  ;make sure KBC notified
        mov     al,0c5h
        out     80h,al

	mov	bx, 5h
	xor	cx, cx
delay2:
	loop	$
	dec	bx
	jnz	delay2

        mov     al,0c6h
        out     80h,al

rst1:
	in	al, KBD_STAT            ;check if anything availale
	test	al, 01h                 ; from keyboard?
	jz	rst1

	in	al, KBD_CMD
	out	80h, al
	cmp	al, 0aah
        xor     cx,cx
        loop    $                       ;too see LEDs
        jne     rst                     
full:
        mov     al,0c7h
        out     80h,al

here2:
        in      al, KBD_CMD             ;clear buffer if any
        jmp     $+2
        jmp     $+2
	in	al, KBD_STAT
        test    al, 3
        jnz     here2

        mov     al,0c8h
        out     80h,al

	mov	al, 060h        	; WR CMD byte
	out	KBD_STAT, al
        
here3:
        jmp     $+2
        in      al,KBD_STAT
        test    al,2
        jnz     here3

        mov     al,0c9h
        out     80h,al

	mov	al, 45h		
	out	KBD_CMD, al

here4:
        jmp     $+2
        in      al,KBD_STAT
        test    al,2
        jnz     here4

        mov     al,0Cah
        out     80h,al

	mov	al, 0aeh		; enable keyboard
	out	KBD_STAT, al

here5:
        jmp     $+2
        in      al,KBD_STAT
        test    al,2
        jnz     here5


	ret
kbd_rst endp


;-------------------------------------------------------------
;
;       tst_buf: test keyboard input and output buffers
;
;	input:  ah = 1 output buffer
;		ah = 2 input buffer
;		ah = 3 input and output buffers
;
;       Output: None
;
;-------------------------------------------------------------


tst_buf proc near

	cli
	push	cx
	xor	cx, cx
emp1:
	in	al, KBD_STAT
	test	al, ah		; test buffers
	jz	emp2
	loop	emp1
emp2:
	pop	cx	
	ret
tst_buf endp


code	ends
	end

