;------------------------------------------------------------------
;
;	INIT.ASM: Program to initialize system management hardware
;
;
;	This program loads the system management program into
;	on-board SMRAM and initialize the system management hardware
;
;	Author:	Desmond Yuen
;
;	Date:	Dec 19th, 1992
;
;	Revision History:	
;
;------------------------------------------------------------------



cr	EQU	13
lf	EQU	10
	

code	SEGMENT
	ASSUME	CS:code, DS:code
	ORG	100h


include	superset.inc

EXTRN	open_omcu:near, close_386sl:near, open_360sl:near, write_360sl:near
EXTRN   close_360sl:near, open_ibu:near,close_cpupwrmode:near
EXTRN   read_360sl:near


; Open SM file

entry:

	mov	ah, 3Dh			;open file function
	mov	al, 00h			;read only
	mov	dx, offset SmFile
	Int	21h
	jnc	sm_file_open		;if no error, then we are done here!
	jmp	bad_sm_exit

;Read the SM file, and close it

sm_file_open:
	mov	Handle, ax		;save the handle
	push	ax
	push	bx
	push	cx
	push	dx
	mov	dx, offset version
	mov	ah, 09h
	int	21h

; Mark SmSeg as write-only memory

	cli
	call	open_ibu
	mov	ax, 30Ah
	mov	dx, ax
	mov	ax, 0FFFFh
	out	dx, ax
	call	close_386sl
	sti

; zero fill SM-RAM

	mov	ax, SmSeg
	mov	es, ax
	xor	ax, ax
	xor	di, di
	mov	cx, 4000h
	repz	stosw

; read in system management file

	mov	ax, SmSeg
	mov	ds, ax
	xor	dx, dx			;ds:dx = SM memory buffer
	mov	cx, 8000h		;read half of SM image
	mov	bx, cs:Handle		;file handle
	mov	ah, 3Fh			;read file
	Int	21h
	jc	rd_sm_exit		;error occurred, exit
	sub	ax, 8000h		;test for complete read
	jc	rd_sm_exit		;error occurred, exit


; Mark SmSeg as read-only memory

	cli
	call	open_ibu
	mov	ax, 30Ah
	mov	dx, ax
	mov	ax, 05555h
	out	dx, ax
	call	close_386sl
	sti
	
; verify file read

	xor	dx, dx
	mov	cx, 1			;read one byte to verify full 
					; file read
	mov	ah, 3Fh			;read file
	Int	21h
	cmp	ax, 0			
	jne	bad_sm_exit		 
					
	clc
	jmp	rd_sm_exit
bad_sm_exit:
	stc
	mov	dx, offset filerr
	mov	ah, 09h
	int	21h
rd_sm_exit:
	pushf
	mov	ax, cs
	mov	ds, ax			;restore ds			
	mov	bx, Handle
	mov	ah, 3Eh			;close file function
	Int	21h
	popf
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	cli
	call	open_omcu  		; select SmSeg as the on-board
	mov	ax, MCSMRAM		; memory segment
	mov	dx, ax
	mov	al, 06h
	out	dx, al
	call	close_386sl
	sti


;; Power Management Initialization

	cli
        call    open_360sl		; enable 82360SL I/O space

; -----------------------------------------------------------

; Software SMI initialization

; -----------------------------------------------------------

; setup port address for ASMI

	mov	bl, ASMI_ADDRL		; set port address to 400h
	mov	bh, 00h
	call	write_360sl
	mov	bl, ASMI_ADDRH
	mov	bh, 04h
	call	write_360sl


; -----------------------------------------------------------

; Local standby initialization

; -----------------------------------------------------------


; setup lstdby0 for floppy drive

	mov	bl, LSTDBY_TMR_DEV0	; initialize lstdby timer
	mov	bh, 0fh			; 1 min timeout
	call	write_360sl
	mov	bl,TRP_ADRL_DEV0	; set trap address low byte
	mov	bh, 0f0h
	call	write_360sl
	mov	bl, TRP_ADRH_DEV0	; set trap address high byte
	mov	bh, 03h
	call	write_360sl
	mov	bl, TRP_ADR_MSK_DEV0	; set address range
	mov	bh, 05h
	call	write_360sl

; setup lstdby1 for COMA

	mov	bl, LSTDBY_TMR_DEV1	; initialize lstdby timer
	mov	bh, 0dh			; 1 min timeout
	call	write_360sl
	mov	bl,TRP_ADRL_DEV1	; set trap address low byte
	mov	bh, 0f8h
	call	write_360sl
	mov	bl, TRP_ADRH_DEV1	; set trap address high byte
	mov	bh, 03h
	call	write_360sl
	mov	bl, TRP_ADR_MSK_DEV1	; set address range
	mov	bh, 06h
	call	write_360sl

; setup lstdby2 for COMB


	mov	bl, LSTDBY_TMR_DEV2	; initialize lstdby timer
	mov	bh, 0bh			; 5 mins timeout
	call	write_360sl
	mov	bl,TRP_ADRL_DEV2	; set trap address low byte
	mov	bh, 0f8h
	call	write_360sl
	mov	bl, TRP_ADRH_DEV2	; set trap address high byte
	mov	bh, 02h
	call	write_360sl
	mov	bl, TRP_ADR_MSK_DEV2	; set address range
	mov	bh, 06h
	call	write_360sl

; setup lstdby3 for hard disk


	mov	bl, LSTDBY_TMR_DEV3	; initialize lstdby timer
	mov	bh, 09h			; 1 min timeout
	call	write_360sl
	mov	bl,TRP_ADRL_DEV3	; set trap address low byte
	mov	bh, 0f0h
	call	write_360sl
	mov	bl, TRP_ADRH_DEV3	; set trap address high byte
	mov	bh, 01h
	call	write_360sl
	mov	bl, TRP_ADR_MSK_DEV3	; set address range
	mov	bh, 07h
	call	write_360sl

; setup lstdby4 for parallel port

	mov	bl, LSTDBY_TMR_DEV4	; initialize lstdby timer
	mov	bh, 07h			; 1 min timeout
	call	write_360sl
	mov	bl,TRP_ADRL_DEV4	; set trap address low byte
	mov	bh, 078h
	call	write_360sl
	mov	bl, TRP_ADRH_DEV4	; set trap address high byte
	mov	bh, 03h
	call	write_360sl
	mov	bl, TRP_ADR_MSK_DEV4	; set address range
	mov	bh, 17h
	call	write_360sl

; enable lstdby timers [0-4]

	mov	bl, STDBY_TMR_CNTRL
	mov	bh, 1fh
	call	write_360sl


;---------------------------------------------------------------------
;
;       Global Standby Initialization
;
;---------------------------------------------------------------------


; select and enable system events

        mov     bl, SYS_EVNT_CFG0
        mov     bh, 02h
        call    write_360sl

        mov     bl, SYS_EVNT_CFG1
        mov     bh, 00h
        call    write_360sl

        mov     bl, SYS_EVNT_CFG2	; enable system events and ASMI
        mov     bh, 05h			; was 01h
        call    write_360sl

; select and enable stop break events

        mov     bl, STP_BRK_CFG0
        mov     bh, 02h                 ; was 43h
        call    write_360sl

        mov     bl, STP_BRK_CFG1
        mov     bh, 00h
        call    write_360sl

        mov     bl, STP_BRK_CFG2
        mov     bh, 00h
        call    write_360sl

; initialize global standby timer

        mov     bl, GSTDBY_TMRL
;        mov     bh, 46h
        mov     bh, 010h		; 2 mins timeout
        call    write_360sl

        mov     bl, GSTDBY_TMRH
        mov     bh, 00h
        call    write_360sl


;---------------------------------------------------------------------
;
;       Suspend/Resume Initialization
;
;---------------------------------------------------------------------

        mov     bl, SUS_WRN_TMR_SRBTN
        mov     bh, 01h			; 128 ms
        call    write_360sl


; System management hardware initialization		

        mov     bl, SM_REQ_CNTRL
        mov     bh, 0deh		; was c4h then c6h
        call    write_360sl
        call    close_360sl

	mov	al, 07fh		; clear suspend flag
	out	XCMOS_INDEX, al
	jmp	$+2
	jmp	$+2
	mov	al, 00h
	out	XCMOS_DATA, al
	jmp	$+2
	jmp	$+2
	sti


exit:
	mov	ax, 4C00H		; terminate program
	int	21H


;------------------------------------------------------------------

; OPTIONAL STACK - CAUTION - MUST USE FUNCTION 4CH IF LOCAL STACK
; IS USED
;
Handle	dw      ?
SmFile	db	'kernel.bin',0
filerr	db	'Error: Cannot open file "KERNEL.BIN"',cr,lf,'$'
version	db	cr,lf
	db	'System Management Kernel Version 1.00',cr,lf
	db	'System Management Kernel Installed.',cr,lf
	db	cr,lf,'$'
SmSeg	EQU	0E800h
;
;------------------------------------------------------------------

code	ENDS					; end code segment
	END	entry

