
;------------------------------------------------------------------
;
;	DEVICE.ASM: This file contains routines for managing power 
;	to the peripherals.
;
;	Author:	Desmond Yuen
;
;	Date:	Dec 19, 1992
;
;	Revision History: 
;
;	Copyright 1992 by McGraw-Hill, Inc. All rights reserved.
;
;-----------------------------------------------------------------


Include	superset.inc

HDD_CMD	EQU	01F7H
HDD_SUS	EQU	0F8H	; power save mode for PrairieTek drive
HDD_RES EQU	0FBH	; resume command

code	segment	byte	public 'code'
	assume cs:code
.386

PUBLIC	cache_off, cache_on
PUBLIC	hdd_off, hdd_on, vga_off, vga_on, devices_on, devices_off
EXTRN	open_cpupwrmode:near, close_cpupwrmode:near, open_ibu:near
EXTRN	open_omcu:near, open_ebu:near, open_ccu:near, close_386sl:near
EXTRN	stop_360_clk:near, start_360_clk:near

cache_off	proc	near	; disable cache controller
	call	open_ibu
	mov	dx, OMLCR
	in	al, dx
	and	al, 7fh
	out	dx, al
	call	close_386sl
	ret
cache_off	endp

cache_on	proc	near	; enable cache controller
	call	open_ibu
	mov	dx, OMLCR
	in	al, dx
	or	al, 80h
	out	dx, al
	call	close_386sl
	ret
cache_on	endp


hdd_off proc near
	mov	ax, HDD_CMD
	mov	dx, ax
	mov	al, HDD_SUS
	out	dx, al
	ret
hdd_off endp


hdd_on proc near
	mov	ax, HDD_CMD
	mov	dx, ax
	mov	al, HDD_RES
	out	dx, al
	ret
hdd_on endp


vga_off proc near

; assumes CL-GD610/620 VGA controller with a CRT monitor

	mov	dx, 3dah
	in	al, dx		; initialize for access to index registers
	mov	dx, 3c0h
	xor	al, al		; disable video enable bit
	out	dx, al
        jmp     $+2
        jmp     $+2
	out	dx, al
        jmp     $+2
        jmp     $+2

	ret
vga_off endp


vga_on proc near

; assumes CL-GD610/620 VGA controller with a CRT monitor

	mov	dx, 3dah
	in	al, dx		; initialize for access to index registers
	mov	dx, 3c0h
	xor	al, al
	out	dx, al
	mov	al, 020h	; set video enable bit
	out	dx, al
        jmp     $+2
        jmp     $+2
	out	dx, al
        jmp     $+2
        jmp     $+2

	ret
vga_on endp

devices_on proc near

	call	cache_on
	call	start_360_clk
	call	hdd_on
	call	vga_on
	ret
devices_on endp


devices_off proc near

	call	cache_off
	call	stop_360_clk
	call	hdd_off
	call	vga_off
	ret
devices_off endp


code	ends
	end


