;------------------------------------------------------------------
;
;	CLOCK.ASM: This file contains routines for controlling the
;	clocks in the the SL SUPERSET.
;
;	Author:	Desmond Yuen
;
;	Date:	Dec 19, 1992
;
;	Revision History: 
;
;	Copyright 1992 by McGraw-Hill, Inc. All rights reserved.
;
;-----------------------------------------------------------------


Include	superset.inc

code	segment	byte	public 'code'
	assume cs:code

PUBLIC	cpu_speed, mcp_speed, stop_360_clk, start_360_clk
EXTRN	open_cpupwrmode:near, close_cpupwrmode:near, open_ibu:near
EXTRN	open_omcu:near, open_ebu:near, open_ccu:near, close_386sl:near
EXTRN	open_360sl:near, read_360sl:near, write_360sl:near, close_360sl:near



;-------------------------------------------------------------
;
;       cpu_speed: set clock speed for CPU
;
;       Input:  bl = divisor
;
;       Output: None
;
;-------------------------------------------------------------


cpu_speed       proc near 

	call    open_cpupwrmode
        in      al, 22h         ; get current CPU speed
        and     al, 0CFh
        cmp     bl, '1'         ; divide by 1?
        ja      two
        jmp     set
two:    cmp     bl, '2'         ; divide by 2?
        ja      four
        or      al, 10h
        jmp     set
four:   cmp     al, '4'         ; divide by 4?
        ja      eight    
        or      al, 20h
        jmp     set
eight:  or      al, 30h         ; divide by 8?
set:    out     22h, al
        call	close_cpupwrmode
        ret
cpu_speed	endp


;-------------------------------------------------------------
;
;       kb_speed: Set Keyboard clock speed
;
;       Input: bl = divisor
;
;       Output: None
;
;-------------------------------------------------------------

kb_speed        proc near

	xchg	bh, bl
        call	open_360sl
	mov	bl, KC_CLK_CNTRL
        call	read_360sl
        cmp     bh, 1
        ja      kb_two
        mov     al, 0h
        jmp     kb_set
kb_two:
        cmp     bh, '2'         ; divide by 2?
        ja      kb_four
        mov     al, 01h
        jmp     kb_set
kb_four:
        mov     al, 02h         ; divide by 4?
kb_set:
        call	write_360sl
        call	close_360sl
        ret
kb_speed	endp


;-------------------------------------------------------------
;
;       mcp_speed:      Set MCP speed
;
;       Input:  bl = divisor
;
;       Output: None
;
;-------------------------------------------------------------


mcp_speed       proc near

        call	open_cpupwrmode
        in      al, 23h         ; get current MCP speed
        and     al, 0C7h
        cmp     bl, 1           ; divide by 1?
        ja      mcp_two
        jmp     mcp_set
mcp_two:    
	cmp     bl, 2           ; divide by 2?
        ja      mcp_four
        or      al, 08h
        jmp     mcp_set
mcp_four:   
	cmp     al, 4           ; divide by 4?
        ja      mcp_eight    
        or      al, 10h
        jmp     mcp_set
mcp_eight:  
	cmp     al, 8           ; divide by 8?
        ja      mcp_six
        or      al, 18h
        jmp     mcp_set
mcp_six:    
	or      al, 20h         ; divide by 16?
mcp_set:    
	out     23h, al
        call	close_cpupwrmode
        ret
mcp_speed	endp


;-------------------------------------------------------------
;
;       stop_360_clk:      stop the clocks in the 82360SL
;
;       Input:  None
;
;       Output: None
;
;-------------------------------------------------------------


stop_360_clk	proc	near

	call	open_360sl
	mov	bl, CFGR1	; disable ISA ref & OSC
	call	read_360sl
	and	al, 0f6h
	mov	bh, al
	call	write_360sl
	mov	bl, DMA_STP_CLK	; disable DMA clks
	mov	bh, 03h
	call	write_360sl
	call	close_360sl
	ret

stop_360_clk	endp


;-------------------------------------------------------------
;
;       start_360_clk:      restart the clocks in the 82360SL
;
;       Input:  None
;
;       Output: None
;
;-------------------------------------------------------------


start_360_clk	proc	near

	call	open_360sl
	mov	bl, CFGR1	; enable ISA ref & OSC
	call	read_360sl
	or	al, 09h
	mov	bh, al
	call	write_360sl
	mov	bl, DMA_STP_CLK	; enable DMA clks
	mov	bh, 00h
	call	write_360sl
	call	close_360sl
	ret

start_360_clk	endp


code	ends
	end


