;------------------------------------------------------------------
;
;       KERNEL.ASM: System management kernel for the  SL SUPERSET.
;
;       This file contains the source code for a sample SL
;       SUPERSET system management software.
;
;       This handler demonstrates the usage of the SL SUPERSET
;       system management capabilities for system management. 
;
;       Author: Desmond Yuen
;
;       Date:   Dec 19, 1992
;
;       Revision History: 
;
;       Copyright (C) by Intel Corporation 1992. All rights reserved
;
;
;------------------------------------------------------------------

;------------------------------------------------------------------
;
;               Include files
;
;------------------------------------------------------------------

	INCLUDE SUPERSET.INC


.386

code    segment use16 byte PUBLIC  'code'
	assume  cs:code
	ORG     0
ORIGIN  EQU     $

start:  
	jmp     kernel
	db      "System Management Kernel", 00


;------------------------------------------------------------------
;
;               Equates
;
;------------------------------------------------------------------



IFDEF   DEBUG

cr      EQU     0AH             ; used in debugging messages
lf      EQU     0DH

ENDIF


EXTRN   open_cpupwrmode:near, close_cpupwrmode:near, open_ibu:near
EXTRN   open_omcu:near, open_ebu:near, open_ccu:near, close_386sl:near
EXTRN   open_360sl:near, read_360sl:near, write_360sl:near, close_360sl:near



Stack           dw      800     dup (?)
Topofstack      label   word

scrnbuff        dw      2000   DUP (0)
hello           db      'H',7,'e',7,'l',7,'l',7,'o',7,',',7,'S',7
		db      'M',7,'M',7,'!',7

videobuff       equ     0b000h


;------------------------------------------------------------------
;
;               Main program begins here
;
;------------------------------------------------------------------


;------------------------------------------------------------------
;
;               Request processing jump table
;
;------------------------------------------------------------------

REQTAB  LABEL   WORD
INIT    dw      0                       ; 0 - initialization


;------------------------------------------------------------------
;
;               SM-RAM Entry Point
;
;------------------------------------------------------------------

	


;-----------------------------------------------------------------
;
;       Kernel Routine
;       
;       Algorithm: Determine what caused the SMI by reading
;       the status registers and pass control to the system 
;       management request handler      
;
;-----------------------------------------------------------------

kernel:

; determines what caused an SMI

	mov     ax, cs
	mov     ds, ax
	mov     es, ax
	mov     ss, ax                  ; setup stack in SMRAM
	mov     sp, offset cs:Topofstack
	call    open_360sl
	mov     bl, SM_REQ_STS
	call    read_360sl              ; read SM request reg
	call    close_360sl
	shl     al, 1                   ; is SMI caused by external SMI
	shl     al, 1
	jnc     exit_smi
	call    exec_ext_SMI

exit_smi:

; terminate SMI service routine


	call    open_360sl
	xor     bh, bh
	mov     bl, SMI_CLR
	call    write_360sl             ; re-enable SMI
	mov     bl, SMI_MARK
	call    write_360sl             ; re-enable CPU reset
	call    close_360sl

	db      0Fh, 0AAh               ; execute RSM instr


;------------------------------------------------------------------
;
;               System Management Request Handler
;
;------------------------------------------------------------------

exec_ext_smi    proc    near            ; external smi request

	call    open_360sl
	mov     bl, SM_REQ_STS          ; clear extsmi request bit
	call    read_360sl
	and     al, 0bfh
	mov     bh, al
	call    write_360sl
	call    close_360sl

	call    scrn_mes                ; display the 'Hello, SMM' message

	mov     al, 0eeh                ; post code to diag card
	out     80h, al

	ret
exec_ext_smi    endp


;------------------------------------------------------------------
;
; scrn_mes: This routine saves video buffer in a temporary location
;           and move message into screen
;          
;
;------------------------------------------------------------------

scrn_mes proc near

	pushad
	cld

;save video memory into temporary buffer

	lea     di, scrnbuff
	mov     ax, 3800h
	mov     es, ax
	xor     si, si          
	mov     ax, videobuff
	mov     ds, ax
	mov     cx, 7D0h
	rep     movsw

; clear screen

	mov     ax, videobuff
	mov     es, ax
	xor     di, di
	mov     cx, 7D0h
	xor     ax, ax
cls:
	mov     es:[di], ax
	inc     di
	inc     di
	loop    cls

; move message into screen

	mov     ax, videobuff
	mov     es, ax
	xor     di, di
	mov     ax, 3800h
	mov     ds, ax
	mov     si, offset hello
	mov     cx, 10
	rep     movsw

; 3 seconds delay

	mov     bx, 010h
delay:
	mov     cx, 0ffffh
delay1:
	aad
	loop    delay1
	dec     bx
	jnz     delay

; restore video screen

	mov     ax, 3800h
	mov     ds, ax
	lea     si, scrnbuff
	mov     ax, videobuff
	mov     es, ax
	xor     di, di
	mov     cx, 7D0h
	rep     movsw

	popad
	ret
scrn_mes endp


CODE    ENDS
	END


