PAGE    60, 70

;------------------------------------------------------------------
;
;	SHADOW.ASM: Program used to enable BIOS shadowing.
;
;	Author:	Desmond Yuen
;
;	Date:	Dec 19, 1992
;
;	Revision History: 
;
;       Copyright (C) by McGraw-Hill, Inc 1992. All rights reserved
;
;-----------------------------------------------------------------

	INCLUDE	SUPERSET.INC


CODE 	SEGMENT
	ASSUME  CS:CODE, DS:CODE, SS:CODE, ES:CODE

        ORG     100H

EXTRN	open_ibu:near, open_ebu:near, close_386sl:near
PUBLIC	read_rom_enbl, write_rom_enbl

start:
	call	read_rom_enbl		;set to read ROM / write RAM state
	mov	ax, 0F000h		;shadow the BIOS
	mov	ds, ax			;This is necessary for the 301Z
	mov	es, ax			;because shadow may have not been
	xor	si, si			;enabled, and enabling write ROM
	xor	di, di			;access in the 301Z relies on the
	mov	cx, 0FFFFh		;presence of a shadowed BIOS.
	rep	movsw

	mov	ax, 0E000h		;set up for possible E000h option
	mov	ds, ax			;ROM shadow
	mov	es, ax
	xor	si, si
	xor	di, di
	mov	cx, 0FFFFh		;if present, then shadow it
	rep	movsw
        call    write_rom_enbl

        MOV     AX, 4C00H
        INT     21H



;-------------------------------------------------------------------------
;
;	write_rom_enbl: Enable writes to the ROM area to go through to the
;			Flash parts
;	Input:	Nothing
;
;	Output:	All registers preserved
;
;-------------------------------------------------------------------------

write_rom_enbl	proc	near

	push	ax
	call    open_ibu
        MOV     DX, 308H
        MOV     AX, 05555H
        OUT     DX, AX
        MOV     DX, 30AH
        OUT     DX, AX
        MOV     DX, 30CH
        OUT     DX, AX
        MOV     DX, 30EH
        OUT     DX, AX
        call	open_ebu                ; Enable flash bios write
        MOV     DX, 300h
        IN      AX, DX
        OR      AH, 40H
        OUT     DX, AX
        call	close_386sl
 	pop	ax
	ret

write_rom_enbl	endp

;-------------------------------------------------------------------------
;
;	read_rom_enbl: Enable read to the ROM area to go through to the
;			Flash parts
;
;	Input:	Nothing
;
;	Output:	All registers preserved
;
;
;-------------------------------------------------------------------------

read_rom_enbl	proc	near
	
        push	ax

	call    open_ibu
        MOV     DX, 308H
        MOV     AX, 0AAAAH
        OUT     DX, AX
        MOV     DX, 30AH
        OUT     DX, AX
        MOV     DX, 30CH
        OUT     DX, AX
        MOV     DX, 30EH
        OUT     DX, AX
        call	close_386sl
	
	pop	ax
	ret

read_rom_enbl	endp


CODE    ENDS                            ; END CODE SEGMENT
        END     start
