;-------------------------------------------------------------
;
;       NAME    RESET.ASM
;
;       This file contains code that is used to implement 
;       resume reset on the standard ISA BIOS.
;
;	Author:	Desmond Yuen
;
;	Date:	Dec 19, 1992
;
;	Revision History: 
;
;       Copyright (C) by Intel Corporation 1992. All rights reserved
;
;-------------------------------------------------------------


;--------------------------------------------------------------
;
;	I have a ROM socket on my evaluation board. After the 
;	system is in suspend. I will replace the system BIOS
;	with the ROM created using RESET.ASM to resume the system.
;	Therefore, you can experiment with suspend and resume 
;	without having to creat a new system BIOS.
;
;----------------------------------------------------------------

	INCLUDE	SUPERSET.INC


BIOS_CODE	SEGMENT
		ASSUME	CS:BIOS_CODE

EXTRN	open_cpupwrmode:near, close_cpupwrmode:near, open_ibu:near 
EXTRN	open_omcu:near,open_ebu:near, open_ccu:near, close_386sl:near 
EXTRN	read_360sl:near, write_360sl:near, close_360sl:near,open_360sl:near

start:

	ORG	0h

	mov	al, MASK_NMI		; disable NMI
	out	CMOS_INDEX, al	

is_resume:

	mov	al, 07fh		; Check suspend flag in XCMOS
	out	XCMOS_INDEX, al		; Note: We put a flag in XCMOS
	in	al, XCMOS_DATA		; 	during suspend. And by 
					;	checking this falg, we can
	out	80h, al			;	tell whether it's a reset
					;	or resume.
	xor	cx, cx			; A little delay for chip to come up
	loop	$

	and	al, 08h			; is SUS_STAT bit set
	jnz	resume
	jmp	normal

resume:

	mov	al, 015h		; resume post code
	out	80h, al

	xor	cx, cx
	loop	$


; lock CPUPWRMODE register

	push	ax
        mov     ax, 8000h       	; execute unlocking sequence
        out     23h, al
        xchg    ah, al
        out     22h, al
        out     22h, ax

        in      ax, 22h
        or      ax, 0100h         	; set lock bit
        out     22h, ax
	pop	ax

	in	al, 22h
	out	80h, al

	xor	cx, cx
	loop	$

	
; it is a resume reset

	in	al, CFGSTAT		; is 82360sl space open
	and	al, 80h
	jz	refresh

        mov     dx, 0FC23h		; unlock space
        in      al, dx
        mov     dx, 0F023h
        in      al, dx
        mov     dx, 0C023h
        in      al, dx
        mov     dx, 0023h

	jmp	$+2
	jmp	$+2

	

; disable suspend refresh

refresh:

	push	ax
        mov     ax, 8000h       	; execute unlocking sequence
        out     23h, al
        xchg    ah, al
        out     22h, al
        out     22h, ax
        in      al, 22h
        or      al, 0Ah         	; enable IBU
	and	al, 0FBh	
        out     22h, al
	pop	ax

	mov	al, SUS_REF
	out	CFGINDEX, al
	xor	al, al
	out	25h, al
	jmp	$+2

	mov	dx, OMDCR		; enable SM-RAM
	mov	al, 08h
	out	dx, al


	jmp	$+2
	push	ax
        in      al, 22h
        or      al, 02h         	; enable OMCU
        and     al, 0F3h        
        out     22h, al
	pop	ax
	
sus_ref_on:
	mov	dx, MCMODE
	in	al, dx
	and	al, 10h
	jz	sus_ref_on


	mov	al, IDXLCK		; lock I/O space
        out     CFGINDEX, al
	mov	al, 01h
        out     CFGDATA,  al

        in      al, 22h
        and     al, 0FDH       	 	; disable all configuration
        out     22h, al         	; spaces

        in      ax, 22h
        or      ax, 0100h         	; set lock bit
        out     22h, ax


res_smi:

	mov	al, 18h			; enter SMM post code
	out	80h, al

	xor	cx, cx
	loop	$

; generate an software SMI to resume


	mov	dx, 400h		; use ASMI
	mov	al, 01h
	out	dx, al

	xor	cx, cx			; takes a few SYSCLKs to
	loop	$			; generate an SMI

	mov	al, 0f2h		; failed to resume post code
	out	80h, al


; normal reset starts here

normal:

	mov	al, 025h		; normal reset post code
	out	80h, al

	xor	cx, cx
	loop	$

	push	ax
        mov     ax, 8000h       	; execute unlocking sequence
        out     23h, al
        xchg    ah, al
        out     22h, al
        out     22h, ax
	in	al, 22h			; is it opened?
	and	al, 01
	jnz	open_cpu_exit
	stc

open_cpu_exit:

        in      al, 22h
        or      al, 0Eh         	; enable EBU
        out     22h, al

	pop	ax

        mov     ax, EBC1CR		; EPROM wait state defaults to 15
        mov     dx, ax
        in      ax, dx
	or	ax, 03h			; set to 3 EPROM wait states
        out     dx, ax


        in      al, 22h
        and     al, 0FDH        	; disable all configuration
        out     22h, al         	; spaces
        in      al, 23h
        or      al, 01h         	; set lock bit
        out     23h, al
	in	al, 22h
	and	al, 01			; is it closed
	jz	close_cpu_exit
	stc

close_cpu_exit:

	pop	ax

	mov	al, 03h
	out	80h, al

	xor	cx, cx
	loop	$

; enable PS/x feature

        push    ax
        mov     dx, 0FC23h		; unlock I/O space
        in      al, dx
        mov     dx, 0F023h
        in      al, dx
        mov     dx, 0C023h
        in      al, dx
        mov     dx, 0023h
        in      al, dx

	mov	dx, CFGR2
	in	al, dx
	or	al, 01h
	out	dx, al

	mov	al, IDXLCK		; lock I/O space
        out     CFGINDEX, al
	mov	al, 01h
        out     CFGDATA,  al
        pop     ax

	mov	al, 02h
	out	80h, al
	xor	cx, cx
	loop	$

; memory auto-sizing

.386p
	xor	ax, ax
	mov	es, ax
	mov	eax, 0ffeeddcch
	mov	es:[0], eax
	mov	ebx, es:[0]
	cmp	eax, ebx
	jnz	nomem
	mov	al, 0abh
	out	80h, al
	jmp	auto
nomem:
	mov	al, 0bch
	out	80h, al

auto:
	hlt


	ORG	0FFF0h

RESET_VEC:

	jmp	start

BIOS_CODE	ENDS
		END	


