

;------------------------------------------------------------------
;
;	EXAMPLE.ASM: This file contains routines for cache 
;	auto-sizing on the Intel386SL Microprocessor.
;
;	Author:	Desmond Yuen
;
;	Date:	Dec 19th, 1992
;
;	Revision History: 
;
;       Copyright (C) by Intel Corporation 1992. All rights reserved
;
;-----------------------------------------------------------------

	
FALSE	EQU	0				; FALSE COMPARE
TRUE	EQU	0FFFFH				; TRUE compare & mask

	INCLUDE SUPERSET.INC
;
;-------------- INITIALIZATION ------------------------------------

CODE	SEGMENT

ASSUME  CS:CODE, DS:CODE, ES:CODE, SS:CODE
;
;
	EXTRN   open_omcu:near 
	EXTRN	open_360sl:near
	EXTRN	close_360sl:near
	EXTRN	close_386sl:near

        ORG	100H
start:
        call    open_360sl		;Unlock 82360 IO space
        mov     dx, 23h			;
        in      al, dx
        and     al, 01h
        jz      not_sl			;Not SL, exit
        call    close_360sl
        call    open_omcu
        mov     dx, SIGNATURE
        in      ax, dx
        call    close_386sl
        cmp     ah, 43h			;Is it a H3C?
        je      i386sl
        cmp     ah, 73h
        je      h3C
i386sl:      
        mov     dx, offset is386sl
        mov     ah, 09h
        int     21h
        jmp     exit
h3c:
        mov     dx, offset islv
        mov     ah, 09h
        int     21h
        jmp     exit
not_sl:         
        mov     dx, offset notsl
        mov     ah, 09h
        int     21h

exit:
        mov	ax, 4C00H			; terminate program
	int	21H

;------------------------------------------------------------------
;
;	Data Area
;
;------------------------------------------------------------------

is386sl         DB      'Intel386SL Microprocessor found.', '$'
islv            DB      'Low Voltage Intel386SL Microprocessor found.', '$'
notsl           DB      'SL Microprocessor not found.', '$'


CODE	ENDS					; END CODE SEGMENT
	END	start
