
PAGE	60, 132					; WIDE LISTING

;------------------------------------------------------------------
;
;	FPP.ASM: This file contains routines to demonstrate  
;	the fast parallel port feature.
;
;	Author:	Desmond Yuen
;
;	Date:	Jan 22, 1992
;
;	Revision History: 
;
;       Copyright (C) by Intel Corporation 1991. All rights reserved
;
;-----------------------------------------------------------------

	
FALSE	EQU	0				; FALSE COMPARE
TRUE	EQU	0FFFFH				; TRUE compare & mask

include superset.inc
;
;-------------- INITIALIZATION ------------------------------------

code	SEGMENT

ASSUME  cs:code, ds:code, es:code, ss:code
;
;
        ORG	100H

EXTRN   enable_sfs:near, disable_sfs:near

start:

        call    enable_fpp
        jmp     exit

enable_fpp proc near

;enable enhanced parallel port mode

        push	ax
        
        call    enable_sfs
        mov     al, FPP_CNTL    ; selects FPP_CNTL register
        out     SFS_INDEX, al
        mov     al, 0D0h
        out     SFS_DATA, al    ; selects lpt1, irq7, extended mode

        mov     al, 10h
        mov     dx, 37ah
        out     dx, al

        pop     ax
        ret

enable_fpp  endp


disable_fpp proc near

;enable enhanced parallel port mode

        push	ax

        mov     dx, SFS_INDEX   ; selects FPP_CNTL register
        mov     al, FPP_CNTL
        out     dx, al
        mov     dx, SFS_DATA    ; disable fast parallel port
        mov     al, 00h
        out     dx, al

        pop     ax
        ret

disable_fpp  endp


exit:
        mov	ax, 4C00H			; terminate program
	int	21H

       


;------------------------------------------------------------------
;
;	Data Area
;
;------------------------------------------------------------------

Kbyte64         DB      '64 Kbyte of cache installed', '$'
Kbyte32         DB      '32 Kbyte of cache installed', '$'
Kbyte16         DB      '16 Kbyte of cache installed', '$'
cacheless       DB      'no cache present$'


code	ENDS					; end code segment
	END	start
