
;-------------------------------------------------------------
;
;
;       NAME    REFRESH.ASM. Program to change the refresh
;		rate of the DRAM controller.
;
;       Usage   REFRESH   DIVISOR
;
;	Author:	Desmond Yuen
;
;	Date:	Dec 19, 1992
;
;	Revision History: 
;
;       Copyright (C) by Intel Corporation 1992. All rights reserved
;
;-----------------------------------------------------------------


	INCLUDE	SUPESET.INC


blank   	EQU     20H     ; space
FULL    	EQU     00H     ; full speed
ONEHALF    	EQU     01H     ; divide by 2
FORT  		EQU     02H     ; divide by 4
EGGH  		EQU     03H     ; divide by 8
SIXTH   	EQU     04H     ; divide by 16
THEE    	EQU     05H     ; divide by 32
SIXFOUR 	EQU     06H     ; divide by 64


CODE    SEGMENT
        ASSUME  CS:CODE, DS:CODE


        ORG     5DH
param1  LABEL   BYTE    ; divisor

        ORG     100H

EXTRN	open_omcu:near, close_386sl:near

start:

; get divisor

        MOV     AL, [param1]
        CMP     AL, blank       ; anything?
        JZ      next
        JMP     con
next:   JMP     help
con:    CMP     AL, '0'         ; divide by 1?
        JA      one
        MOV     BITMASK, FULL
        JMP     set
one:    CMP     AL, '1'         ; divide by 2?
        JA      two
        MOV     BITMASK, ONEHALF
        JMP     set
two:    CMP     AL, '2'         ; divide by 4?
        JA      three
        MOV     BITMASK, FORT
        JMP     set
three:  CMP     AL, '3'         ; divide by 8?
        JA      four
        MOV     BITMASK, EGGH
        JMP     set
four:   CMP     AL, '4'         ; divide by 16?
        JA      three
        MOV     BITMASK, SIXTH
        JMP     set
five:   CMP     AL, '5'         ; divide by 32?
        JA      six
        MOV     BITMASK, THEE
        JMP     set
six:    CMP     AL, '6'
        JA      help
        MOV     BITMASK, SIXFOUR
set:    
        CLI
	call    open_omcu
        MOV     DX, MCRF
        MOV     AL, BITMASK
        OUT     DX, AL
        JMP     done       
help:   MOV     AH, 09H
        PUSH    DS
        PUSH    SS
        POP     DS
        MOV     DX, OFFSET HELP_MES
        INT     21H
        POP     DS
done:
        call	close_386sl
        STI
        MOV     AX, 4C00H
        INT     21H             ; terminate program

;-------------------------------------------------------------
;
;                       DATA AREA
;
;-------------------------------------------------------------


HELP_MES        DB      'USAGE: REFRESH - (0,1,2,3,4,5,6)$'
BITMASK         DB      ?                


CODE    ENDS
        END     start        

