
;------------------------------------------------------------------
;
;	EXAMPLE.ASM: This file contains routines for cache 
;	auto-sizing on the Intel386SL Microprocessor.
;
;	Author:	Desmond Yuen
;
;	Date:	Dec 19, 1992
;
;	Revision History: 
;
;       Copyright (C) by Intel Corporation 1992. All rights reserved
;
;-----------------------------------------------------------------

	
		INCLUDE SUPERSET.INC

FALSE	EQU	0			  ; FALSE COMPARE
TRUE	EQU	0FFFFH			  ; TRUE compare & mask

CODE	SEGMENT	PUBLIC	'CODE'
	ASSUME  CS:CODE, DS:CODE, ES:CODE, SS:CODE

        ORG	100H

EXTRN   open_ibu:near, open_ccu:near, close_386sl:near

start:

	cli				; disable hardware interrupts
	mov	ax, 008fh		; turn off NMI, clear shutdown byte
	out	70h, al
        jmp     $+2
        jmp     $+2
	in	al,21h
	or	al,00000011b		; disable timer and keyboard int
	out	21h, al			; 
	jmp     $+2
        jmp     $+2


; except for 512K-576K, mark all other memory areas as non-cacheable


	call	open_ibu
        mov     ax, NCACR       	; 0-640k as non-cacheable
        mov     dx, ax
        mov     ax, 02FFH
        out     dx, ax

; set on-board memory limit to 1024K

        mov     ax, OMLCR
        mov     dx, ax
        mov     al, 41H
        out     dx, al

; mark 576K to 1024K as non-cacheable

        mov     ax, NCBCR       	; A to D segments
        mov     dx, ax
        mov     ax, 0FFF0H
        out     dx, ax

        mov     ax, NCCCR       	; E to F segments
        mov     dx, ax
        mov     al, 0FFH
        out     dx, al
	call	close_386sl

; setup cache controller for 64K and direct mapping


	call	open_ccu
        mov     dx, CCR
        mov     al,0
        out     dx, al
	call	close_386sl


; disable cache controller


        call	open_ibu
        mov     dx, OMLCR
        in      al, dx
        and     al, 07FH
        out     dx, al
	call	close_386sl

; enable cache controller

        call	open_ibu
        mov     dx, OMLCR
        in      al, dx
        or      al, 080H
        out     dx, al
	call	close_386sl

; setup for cache autosizing

        mov     ax, 08000H
        mov     es, ax
.386
        mov     esi, 0010H

        mov     al, 06h
        out     80h, al


; test for 16K of cache

        mov     ax, 05555H              ; dummy cache cycles
        mov     es:[esi], ax
        mov     ax, 0F00FH
        mov     es:[esi+2],ax
        mov     ax, 05555H              ; write to address boundary
        mov     es:[esi], ax
        mov     ax, 0F00FH
        mov     es:[esi+2],ax
        cmp     es:[esi], 05555H
        jne     nocache
chk32k:

        mov     al, 07h
        out     80h, al

; test for 32K of cache

        mov     ax, 0AAAAH
        mov     es:[esi+1000H], ax
        mov     ax, 0F00FH
        mov     es:[esi+1002H], ax
        cmp     es:[esi+1000H], 0AAAAH
        je      is16
is16:   cmp     es:[esi], 0AAAAH
        je      K16

; test for 64K of cache

        mov     ax, 0A5A5H
        mov     es:[esi+2000H], ax
        mov     ax, 0F00FH
        mov     es:[esi+2002H], ax
        cmp     es:[esi+2000H], 0A5A5H
        je      is32
is32:   cmp     es:[esi], 0A5A5H
        je      K32

K64:
        mov     dx, offset kbyte64
        mov     ah, 09h
        int     21h
        jmp     exit

K32:    
        mov     dx, offset kbyte32
        mov     ah, 09h
        int     21h
        jmp     exit

K16:
        mov     dx, offset kbyte16
        mov     ah, 09h
        int     21h
        jmp     exit

nocache:

        mov     dx, offset cacheless
        mov     ah, 09h
        int     21h


exit:


; disable cache controller

        call	open_ibu
        mov     dx, OMLCR
        in      al, dx
        and     al, 07FH
        out     dx, al
	call	close_386sl

; enable cache controller

        call	open_ibu
        mov     dx, OMLCR
        in      al, dx
        or      al, 080H
        out     dx, al
	call	close_386sl

        call    en_int
        mov	ax, 4C00H	     	; terminate program
	int	21H

;----------------------------------------------------------------------
;
; en_int: Routine to enable interrupt.
; 
; input: nothing
;
; output: nothing
;
;--------------------------------------------------------------------
en_int proc near

;re-enable interrupts

        push	ax
	mov	ax, 0fh			; turn on NMI, clear shutdown byte
	out	70h, al			  
        jmp     $+2
        jmp     $+2
	in	al,21h
	jmp	$+2
	jmp	$+2
	mov	al,11111100b		; enable keyboard and timer int
	out	21h, al
	pop	ax
        sti
        ret

en_int  endp
        

;------------------------------------------------------------------
;
;	Data Area
;
;------------------------------------------------------------------

Kbyte64         DB      '64 Kbyte of cache installed', '$'
Kbyte32         DB      '32 Kbyte of cache installed', '$'
Kbyte16         DB      '16 Kbyte of cache installed', '$'
cacheless       DB      'no cache present$'


code	ENDS					; end code segment
	END	start
