TITLE 'APEEL FILE:18CV8 BASIC REGISTERS and LATCHES,
DESIGNER:Robin Jigour
DATE: 8/16/87'

PEEL18CV8

"DESCRIPTION"

"                      PEEL18CV8

"              Basic Registers and Latches
"                     ____  ____
"                    |    \/    |
"               CLK  { 1     20 }  Vcc
"                 D  { 2     19 }- Q_D
"                 T  { 3     18 }- Q_T
"                 J  { 4     17 }- Q_JK
"                 K  { 5     16 }- Q_SR
"                 S  { 6     15 }- Q_SL
"                 R  { 7     14 }- Q_GL
"               LAT  { 8     13 }  A_RES
"               LEN  { 9     12 }  S_SET
"                Gnd {10     11 }  S_RES
"                    |__________|
"                   ( - = output )

" This application examples demonstrates the implementation of
" several basic registers and latches within a PEEL18CV8.  Four
" register types are included, D, T, JK, and SR, all of which are
" clocked by the CLK input.  All registers can be synchronously
" reset, set,and asynchronously reset using the SRES, SSET and ARES
" inputs respectively. Besides the registers, an SR latch and a
" Gated Latch circuit show how independant asynchronous storage
" elements can be implemented.  Only the Q outputs of these
" registers and latches are provided at the output pins.
" The /Q outputs could easily be accessed by inverting the
" macro cell output polarity.  Truth table operation can be
" referenced via the test vectors.


"Inputs"

CLK        pin 1
D          pin 2                       "Register and latch inputs.
T          pin 3
J          pin 4
K          pin 5
R          pin 6
S          pin 7
LAT        pin 8                        "Gated latch.
LEN        pin 9                        "Enable for gated latch.
SRES       pin 11                       "Synchronous reset.
SSET       pin 12                       "Synchronous set.
ARES       pin 13                       "Asynchronous reset.
                                        "Pins 12 and 13 macro configurations are
                                        "defaulted to 'pos com feed_pin'.

"Outputs and Macro Cell definitions

Q_GL     pin 14 = pos com feed_or   "Latch outputs internal feedback.
Q_SL      pin 15 = neg com feed_pin
Q_SR      pin 16 = pos reg feed_reg  "Register outputs.
Q_JK      pin 17 = pos reg feed_reg
Q_T       pin 18 = pos reg feed_reg
Q_D       pin 19 = pos reg feed_reg


"Internal Nodes"

 AC        node 21                    "Asynchronous Clear node.
 SP        node 22                    "Synchronous Preset node.


EQUATIONS

SP = SSET                              "Synchronous Preset.
AC = ARES                              "Asynchronous Clear.

Q_D  := !SRES & D                      "D register.

Q_T  := !SRES &  T & !Q_T #            "T register.
       !SRES & !T &  Q_T
                                       "Please note that the feedback Q_T has
                                       "the same signal level as the previous
                                       "signal level of the output Q_T
                                       "regardless of type of POLARITY or
                                       "FEEDBACK PATH.

Q_JK := !SRES &  J & !K #              "JK register.
       !SRES & !J & !K  &  Q_JK #
       !SRES &  J &  K  & !Q_JK

Q_SR := !SRES &  S & !R #              "SR register (clocked).
       !SRES & !S & !R  &  Q_SR

Q_SL  = !( R # !S & !Q_SL )            "SR latch.

"       ^  =>  As in the V8GATES.APL, this '!' is actually ignored by APEEL.
"              The output's NEG polarity is actually doing the inversion.

Q_GL  =  LEN & LAT #                   "Gated latch.
       !LEN & Q_GL #
        LAT & Q_GL                    "Fix hazard when Q_GL=1.


TEST_VECTORS "D Register"

(  CLK  D  SRES  SSET  ARES   ->   Q_D  )
    0   0    0    0      1    ->     X
    0   0    0    0      1    ->     L
    C   0    0    1      0    ->     H
    C   0    1    0      0    ->     L
    C   0    1    1      0    ->     H
    C   0    0    0      0    ->     L
    C   1    0    0      0    ->     H
    C   0    0    0      0    ->     L
    C   1    0    0      0    ->     H


TEST_VECTORS "T Register"

(  CLK  T  SRES  SSET  ARES   ->   Q_T  )
    0   0    0    0      1    ->     L
    C   0    0    1      0    ->     H
    C   0    1    0      0    ->     L
    C   0    1    1      0    ->     H
    C   0    1    1      0    ->     H
    C   1    0    0      1    ->     L
    C   0    0    0      0    ->     L
    C   1    0    0      0    ->     H


TEST_VECTORS "JK Register"

(  CLK   J  K   SRES  SSET  ARES   ->   Q_JK  )
    0    0  0    0     0     1     ->     L
    C    0  0    0     1     0     ->     H
    C    0  0    1     0     0     ->     L
    C    0  0    1     1     0     ->     H
    C    0  0    0     0     0     ->     H
    C    0  1    0     0     0     ->     L
    C    1  0    0     0     0     ->     H
    C    1  1    0     0     0     ->     L
    C    0  0    0     0     0     ->     L
    C    1  0    0     0     0     ->     H
    C    0  1    0     0     0     ->     L
    C    1  1    0     0     0     ->     H


TEST_VECTORS "SR Regsister  (clocked)"

(  CLK  SRES  S  R  SSET  ARES  ->   Q_SR  )
    C     0   0  0    0     0   ->     X
    C     0   1  0    0     0   ->     H
    C     0   0  0    0     0   ->     H
    C     0   0  1    0     0   ->     L
    C     0   0  0    0     0   ->     L
    C     0   1  1    0     0   ->     L


TEST_VECTORS "SR Latch"

(  S  R   ->   Q_SL  )
   0  0   ->     X
   1  0   ->     H
   0  0   ->     H
   0  1   ->     L
   0  0   ->     L
   1  1   ->     L


TEST_VECTORS "Gated Latch"

(  LAT  LEN   ->    Q_GL  )
     0   0    ->     X
     0   1    ->     L
     0   0    ->     L
     1   0    ->     L
     0   1    ->     L
     1   1    ->     H
     1   0    ->     H
     0   0    ->     H
     0   1    ->     L
     0   0    ->     L