TITLE 'APEEL FILE: PEEL18CV8 BASIC GATES
DESIGNER: Robin Jigour
DATE: 8/16/87'

PEEL18CV8

"DESCRIPTION"

"                      PEEL18CV8

"                  Basic Logic Gates
"                     ____  ____
"                    |    \/    |
"                 A  { 1     20 }  Vcc
"                 B  { 2     19 }- NOT
"                 C  { 3     18 }- AND
"                 D  { 4     17 }- NAND
"                    { 5     16 }- OR          ( - = output )
"                    { 6     15 }- NOR
"                    { 7     14 }- AOI
"                    { 8     13 }- XOR
"               /OE  { 9     12 }- HZ_BUF
"               Gnd  {10     11 }
"                    |__________|


" This PEEL18CV8 application example implements several basic
" logic gates.  The logic gates include an inverter, four
" input AND, OR, NAND, and NOR gates, a four input AND-OR-
" INVERT gate, a two input XOR gate and a high-impedence
" buffer.  Each gate uses one or more of the (A,B,C and D)
" inputs.  Additionally  the high-impedence buffer uses the
" /HZ input for inpedence control.  The truth table for
" these gates can be examined in the test vectors.  Note, the
" remaining unused input pins can be used as additional inputs
" into the gates.


"Inputs"

A           pin 1  "A,B,C, and D are gate inputs.
B           pin 2
C           pin 3
D           pin 4
!OE         pin 9  "The '!' is only used to indicate an active low output
                   "enable for HZ_BUF. This character is NOT part of the pin
                   "name.


"Outputs and Macro Cell definitions

HZ_BUF       pin 12 = pos com feed_pin  "High Impedence Buffer.
XOR          pin 13 = pos com feed_pin  "Exclusive OR.
AOI          pin 14 = neg com feed_pin  "AND-OR-Invert.
NOR          pin 15 = neg com feed_pin
OR           pin 16 = pos com feed_pin
NAND         pin 17 = neg com feed_pin
AND          pin 18 = pos com feed_pin
NOT          pin 19 = pos com feed_pin  "Inverter.


EQUATIONS

NOT    =  !A                 "Note macro cell polarity for each output.

AND    =   A & B & C & D

NAND   = !(A & B & C & D)    "Here, the '!' (which is actually ignored by APEEL)
                             "is to make the equation appears logically correct.
                             "This output's macro cell which is set to NEG
                             "polarity is actually doing the inversion.

OR     =   A # B # C # D

NOR    = !(A # B # C # D)    "Again, the '!' is ignored by APEEL.

AOI    = !(A & B # C & D)    "Same as above.

XOR    =   A & !B # !A & B

HZ_BUF =  A
Enable HZ_BUF = OE           "OE controls output enable.
                             "Outputs without the 'ENABLE' statements are
                             "enabled unconditionally.


TEST_VECTORS

(  D  C  B  A  OE   ->   NOT  AND  NAND  OR  NOR  AOI  XOR HZ_BUF )
   0  0  0  0   1   ->    H    L   H     L   H    H    L     L
   0  0  0  1   1   ->    L    L   H     H   L    H    H     H
   0  0  1  0   0   ->    H    L   H     H   L    H    H     Z
   0  0  1  1   0   ->    L    L   H     H   L    L    L     Z
   0  1  0  0   X   ->    X    L   H     H   L    H    X     X
   0  1  0  1   X   ->    X    L   H     H   L    H    X     X
   0  1  1  0   X   ->    X    L   H     H   L    H    X     X
   0  1  1  1   X   ->    X    L   H     H   L    L    X     X
   1  0  0  0   X   ->    X    L   H     H   L    H    X     X
   1  0  0  1   X   ->    X    L   H     H   L    H    X     X
   1  0  1  0   X   ->    X    L   H     H   L    H    X     X
   1  0  1  1   X   ->    X    L   H     H   L    L    X     X
   1  1  0  0   X   ->    X    L   H     H   L    L    X     X
   1  1  0  1   X   ->    X    L   H     H   L    L    X     X
   1  1  1  0   X   ->    X    L   H     H   L    L    X     X
   1  1  1  1   X   ->    X    H   L     H   L    L    X     X
                                                                                                          