TITLE 'APEEL FILE: PEEL273 8-BIT GREATER-THAN/LESS-THAN MAGNITUDE COMPARATOR
DESIGNER: Robin Jigour, ICT
DATE: 10/11/87'

PEEL273

"DESCRIPTION"

"                       PEEL273

"    8-Bit Greater-Then/Less-Then Magnitude Comparator
"                     ____  ____
"                    |    \/    |
"                A0  { 1     24 }  Vcc
"                A1  { 2     23 }- A_GT_B   ( - = output )
"                A2  { 3     22 }- A_LT_B
"                A3  { 4     21 }- EQ7
"                A4  { 5     20 }- EQ6
"                A5  { 6     19 }- EQ5
"                A6  { 7     18 }- EQ4
"                A7  { 8     17 }  B7
"                B0  { 9     16 }  B6
"                B1  {10     15 }  B5
"                B2  {11     14 }  B4
"               Gnd  {12     13 }  B3
"                    |__________|


" This application uses the PEEL273 to implement a magnitude comparator
" that compares two groups of eight inputs (A0-7 and B0-7) to provide
" both greater-then (AB) and less-then (A) outputs. The comparator can
" be cascaded by connecting the A_GT_B and A_LT_B outputs of up to
" eight PEEL273s to the An and Bn inputs a next level PEEL273.
" Thus nine PEEL273s would allow for a 64-bit magnitude comparator.

" Comparators, especially magnitude comparators use many exclusive-OR
" functions for testing for equality or inequality.  Because of this,
" the sum-of-product equations for just one output of the magnitude
" comparator requires 2 to the n-1 product terms per bit.  With eight
" bits that comes to 255 product terms per sum, more then are available
" with even the PEEL273.  However, by using multi-level logic many of
" the high order exclusive-OR functions (EQ4-EQ7) are first implemented
" and then used in the final magnitude comparator output equations,
" thus, reducing product terms to 39.


"PIN DEFINITIONS"

"Inputs"

A0       pin  1
A1       pin  2
A2       pin  3
A3       pin  4
A4       pin  5
A5       pin  6
A6       pin  7
A7       pin  8
B7       pin  9
B6       pin 10
B5       pin 11
B4       pin 13
B3       pin 14          "Pins 14-17, default polarity = pos.
B2       pin 15
B1       pin 16
B0       pin 17


"Outputs

E4       pin 18 = NEG  "E4-E7 are used to minimize equation product terms.
E5       pin 19 = NEG
E6       pin 20 = NEG
E7       pin 21 = NEG
A_LT_B   pin 22 = POS
A_GT_B   pin 23 = POS


EQUATIONS

Enable A_GT_B = 1      "Enable outputs (unconditionally).
Enable A_LT_B = 1
Enable E7     = 1
Enable E6     = 1
Enable E5     = 1
Enable E4     = 1

E7  = !( A7 & !B7 #     "A7=B7  (XNOR)
        !A7 &  B7)

E6  = !( A6 & !B6 #     "A6=B6  (XNOR)
        !A6 &  B6)

E5  = !( A5 & !B5 #     "A5=B5  (XNOR)
        !A5 &  B5)

E4  = !( A4 & !B4 #     "A4=B4  (XNOR)
        !A4 &  B4)


A_GT_B = A7 & !B7 #
         E7 & A6 & !B6 #
         E7 & E6 & A5 & !B5 #
         E7 & E6 & E5 & A4 & !B4 #
         E7 & E6 & E5 & E4 &  A3 & !B3 #
         E7 & E6 & E5 & E4 & !A3 & !B3 &  A2 & !B2 #
         E7 & E6 & E5 & E4 &  A3 &  B3 &  A2 & !B2 #
         E7 & E6 & E5 & E4 & !A3 & !B3 & !A2 & !B2 &  A1 & !B1 #
         E7 & E6 & E5 & E4 & !A3 & !B3 &  A2 &  B2 &  A1 & !B1 #
         E7 & E6 & E5 & E4 &  A3 &  B3 & !A2 & !B2 &  A1 & !B1 #
         E7 & E6 & E5 & E4 &  A3 &  B3 &  A2 &  B2 &  A1 & !B1 #
         E7 & E6 & E5 & E4 & !A3 & !B3 & !A2 & !B2 & !A1 & !B1 & A0 & !B0 #
         E7 & E6 & E5 & E4 & !A3 & !B3 & !A2 & !B2 &  A1 &  B1 & A0 & !B0 #
         E7 & E6 & E5 & E4 & !A3 & !B3 &  A2 &  B2 & !A1 & !B1 & A0 & !B0 #
         E7 & E6 & E5 & E4 & !A3 & !B3 &  A2 &  B2 &  A1 &  B1 & A0 & !B0 #
         E7 & E6 & E5 & E4 &  A3 &  B3 & !A2 & !B2 & !A1 & !B1 & A0 & !B0 #
         E7 & E6 & E5 & E4 &  A3 &  B3 & !A2 & !B2 &  A1 &  B1 & A0 & !B0 #
         E7 & E6 & E5 & E4 &  A3 &  B3 &  A2 &  B2 & !A1 & !B1 & A0 & !B0 #
         E7 & E6 & E5 & E4 &  A3 &  B3 &  A2 &  B2 &  A1 &  B1 & A0 & !B0

A_LT_B = !A_GT_B & !E7  #
         !A_GT_B & !E6  #
         !A_GT_B & !E5  #
         !A_GT_B & !E4  #
         !A_GT_B &  A3 & !B3  #
         !A_GT_B & !A3 &  B3  #
         !A_GT_B &  A2 & !B2  #
         !A_GT_B & !A2 &  B2  #
         !A_GT_B &  A1 & !B1  #
         !A_GT_B & !A1 &  B1  #
         !A_GT_B &  A0 & !B0  #
         !A_GT_B & !A0 &  B0


TEST_VECTORS

( A7 A6 A5 A4 A3 A2 A1 A0  B7 B6 B5 B4 B3 B2 B1 B0  ->  A_GT_B  A_LT_B )
   0  0  0  0  0  0  0  0   0  0  0  0  0  0  0  0  ->     L      L
   0  0  0  0  0  0  0  1   0  0  0  0  0  0  0  0  ->     H      L
   0  0  0  0  0  0  0  0   0  0  0  0  0  0  0  1  ->     L      H
   1  0  1  0  1  0  1  0   1  0  1  0  1  0  1  0  ->     L      L
   1  0  1  0  1  0  1  0   0  1  0  1  0  1  0  1  ->     H      L
   0  1  0  1  0  1  0  1   1  0  1  0  1  0  1  0  ->     L      H
   1  1  1  1  1  1  1  1   1  1  1  1  1  1  1  1  ->     L      L
   1  1  1  1  1  1  1  1   1  1  1  1  1  1  1  0  ->     H      L
   1  1  1  1  1  1  1  0   1  1  1  1  1  1  1  1  ->     L      H

                                                                                                                       