/*----------------------------------------------------------*/
/*                                                          */
/*        MONITOR.CPP - controls the Monitor Menu           */
/*        Copyright (c) 1992 by Cirrus Logic Inc.           */
/*                                                          */
/*   MV:1/2/92 - file created                               */
/*                                                          */
/*   Modifications:                                         */
/*                                                          */
/*   MOD1:  ALPINE II MODES, FREQ.,.... STEVE C. 8-17-93    */
/*   MOD2:  CENTERING                   STEVE C. 9-03-93    */
/*                                                          */
/*----------------------------------------------------------*/

#define USE_HELP_CONTEXTS
#include <ui_win.hpp>
#include "clview.hpp"
#include "clmode.hpp"
#include "string.h"

byte getDisplayStatus(int);
int getVideoMemory();
void setHorzMontype(byte);
void setVertMontype(byte, byte, byte, byte);
void preview(byte, boolean);
void getmode16List();

extern OPTION_INFO tbl[];
extern boolean isHiFreqProduct;
extern byte NOT_AVAILABLE;

UIW_STRING *hfreqStr, *f640Str, *f800Str, *f1024Str, *f1280Str, *f80072Str; // MOD1
#ifdef DESKTOP                  // advance monitor is not supported in lap top --sean
UIW_BUTTON *advancedButton;
extern int GD5420;   /* SGC, 2-25-93 */
extern int is5420(); /* SGC, 2-25-93 */
extern void ClearAllTables();  // MOD2
extern void TSR_unload();  // MOD2
int TempHMonitor;

extern unsigned int CenteringTable [];  // MOD2

#endif                          // desktop


static char* freqTbl[40] =
{  "Horizontal frequency : 31.5 kHz", "640x480 @ 60 Hz", NULL, NULL, NULL,
	"Horizontal frequency : 35.5 kHz", "640x480 @ 60 Hz", NULL, "1024x768  @ 87i Hz", NULL,
	"Horizontal frequency : 35.1 kHz", "640x480 @ 60 Hz", "800x600 @ 56 Hz", NULL, NULL,
	"Horizontal frequency : 35.5 kHz", "640x480 @ 60 Hz", "800x600 @ 56 Hz", "1024x768  @ 87i Hz", NULL,
	"Horizontal frequency : 37.8 kHz", "640x480 @ 60 Hz", "800x600 @ 60 Hz", "1024x768  @ 87i Hz", NULL,
	"Horizontal frequency : 48.0 kHz", "640x480 @ 60 Hz", "800x600 @ 72 Hz", "1024x768  @ 60 Hz", "1280x1024 @ 87i Hz",
	"Horizontal frequency : 56.0 kHz", "640x480 @ 60 Hz", "800x600 @ 72 Hz", "1024x768  @ 70 Hz", "1280x1024 @ 87i Hz",
#ifdef DESKTOP
	"Horizontal frequency : 58.0 kHz", "640x480 @ 60 Hz", "800x600 @ 72 Hz", "1024x768  @ 72 Hz", "1280x1024 @ 87i Hz",
#else
	"Horizontal frequency : 64.0 kHz", "640x480 @ 60 Hz", "800x600 @ 72 Hz", "1024x768  @ 72 Hz", "1280x1024 @ 87i Hz",
#endif
};

char* f640tbl[2] = {"640x480 @ 60 Hz", "640x480 @ 72 Hz"};
char* f800tbl[3] = {"800x600 @ 56 Hz", "800x600 @ 60 Hz", "800x600 @ 72 Hz" };
char* f1024tbl[5]= {"1024x768  @ 87i Hz", "1024x768  @ 60 Hz", 
	"1024x768  @ 70 Hz", "1024x768  @ 72 Hz", "1024x768  @ 76 Hz" };
char* f1280tbl[4]= { "1280x1024 @ 87i Hz", "1280x1024 @ 60 Hz",
	"1280x1024 @ 70 Hz", "                  "};


EVENT_TYPE Display_Freq(UI_WINDOW_OBJECT*, UI_EVENT &, EVENT_TYPE ccode)
{
	int i = tbl[HMONITOR].value * 5;

	if (tbl[HMONITOR].value == 8) {		// Advanced option
#ifdef DESKTOP                  // advance monitor is not supported in lap top --sean
		advancedButton->woFlags = WOF_BORDER | WOF_JUSTIFY_CENTER;
		advancedButton->Information(SET_TEXT, "Set Advanced");
#endif                          // desktop
		hfreqStr->Information(SET_TEXT, "");
		f640Str->Information(SET_TEXT,  f640tbl[getDisplayStatus(FREQ_640)]);
		f800Str->Information(SET_TEXT,  f800tbl[getDisplayStatus(FREQ_800)]);
#ifdef DESKTOP
		if (isHiFreqProduct) {
		  if (getDisplayStatus(FREQ_800) == 2)
		    f80072Str->Information(SET_TEXT,"800x600, 32-bit @ 60Hz");
		  else
		    f80072Str->Information(SET_TEXT," ");
		}
		else
		  f80072Str->Information(SET_TEXT," ");
#endif
			if (getVideoMemory() >= 512)
#ifdef DESKTOP
			  if (GD5420 == 1){     /* SGC, 2-26-93 */
			    if (getDisplayStatus(FREQ_1024) >= 3)
			      f1024Str->Information(SET_TEXT, f1024tbl[2]);
			    else
			      f1024Str->Information(SET_TEXT,f1024tbl[getDisplayStatus(FREQ_1024)]);
			  }
			else
#endif
			  f1024Str->Information(SET_TEXT, f1024tbl[getDisplayStatus(FREQ_1024)]);

		if (getVideoMemory() >= 1024) {
			if ((isHiFreqProduct == FALSE) && (getDisplayStatus(FREQ_1280) == NOT_AVAILABLE))
				f1280Str->Information(SET_TEXT, "                  ");
			else
#ifdef DESKTOP
			  if (GD5420 == 0)  /* SGC, 2-25-93 */
#endif
				f1280Str->Information(SET_TEXT, f1280tbl[getDisplayStatus(FREQ_1280)]);
		}
	}
	else {
#ifdef DESKTOP                  // advance monitor is not supported in lap top --sean
		advancedButton->woFlags = WOF_NON_SELECTABLE | WOF_JUSTIFY_CENTER;
		advancedButton->Information(SET_TEXT, "");
#endif                          // desktop
		hfreqStr->Information(SET_TEXT, freqTbl[i++]);
		f640Str->Information(SET_TEXT,  freqTbl[i++]);
		f800Str->Information(SET_TEXT,  freqTbl[i++]);
#ifdef DESKTOP
		if (isHiFreqProduct) {
		  if (tbl[HMONITOR].value <= 7 && tbl[HMONITOR].value >= 5)
		    f80072Str->Information(SET_TEXT,"800x600, 32-bit @ 60Hz");
		  else
		    f80072Str->Information(SET_TEXT," ");
		}
		else
		  f80072Str->Information(SET_TEXT," ");
#endif
		if (getVideoMemory() >= 512)
#ifdef DESKTOP
		      if (GD5420 == 1){     /* SGC, 2-26-93 */
			if (tbl[HMONITOR].value == 7)
			  f1024Str->Information(SET_TEXT, freqTbl[i-5]);
			else
			  f1024Str->Information(SET_TEXT, freqTbl[i++]);
		      }
		      else
#endif
			f1024Str->Information(SET_TEXT, freqTbl[i++]);
		if (getVideoMemory() >= 1024)
#ifdef DESKTOP
		    if (GD5420 == 0)  /* SGC, 2-25-93 */
#endif
			f1280Str->Information(SET_TEXT, freqTbl[i]);
	}
	return (ccode);
}

#ifdef DESKTOP                  // advance monitor is not supported in lap top --sean

EVENT_TYPE Exit_Advanced(UI_WINDOW_OBJECT *object, UI_EVENT &, EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return 0;

	// Exit the application by sending a message.
	UIW_BUTTON *button = (UIW_BUTTON *)object;

	switch (button->value) {
		case S_CLOSE:
			tbl[HMONITOR].value = MONTYPE_8;
			setVertMontype(tbl[FREQ_640].value, tbl[FREQ_800].value,
				tbl[FREQ_1024].value,tbl[FREQ_1280].value);

			hfreqStr->Information(SET_TEXT, "");  /* Added in 2.30 beta 2 */
			f640Str->Information(SET_TEXT,  f640tbl[getDisplayStatus(FREQ_640)]);
			f800Str->Information(SET_TEXT,  f800tbl[getDisplayStatus(FREQ_800)]);
#ifdef DESKTOP
			if (isHiFreqProduct) {
			  if (getDisplayStatus(FREQ_800) == 2)
			    f80072Str->Information(SET_TEXT,"800x600, 32-bit @ 60Hz");
			  else
			    f80072Str->Information(SET_TEXT," ");
			}
			else
			  f80072Str->Information(SET_TEXT," ");
#endif
			if (getVideoMemory() >= 512)
			  if (GD5420 == 1){     /* SGC, 2-26-93 */
			    if (getDisplayStatus(FREQ_1024) >= 3)
			      f1024Str->Information(SET_TEXT, f1024tbl[2]);
			    else
			      f1024Str->Information(SET_TEXT,f1024tbl[getDisplayStatus(FREQ_1024)]);
			  }
			else
			  f1024Str->Information(SET_TEXT, f1024tbl[getDisplayStatus(FREQ_1024)]);
			if (getVideoMemory() >= 1024) {
			  if ((isHiFreqProduct == FALSE) && (getDisplayStatus(FREQ_1280) == NOT_AVAILABLE))
			    f1280Str->Information(SET_TEXT, "                  ");
			  else
			   if (GD5420 == 0)  /* SGC, 2-25-93 */
			    f1280Str->Information(SET_TEXT, f1280tbl[getDisplayStatus(FREQ_1280)]);
			}
			button->eventManager->Put(UI_EVENT(S_CLOSE));
#ifdef DESKTOP
			ClearAllTables (); // MOD2, clear centering tables
			TSR_unload ();     // MOD2
#endif
			break;

		case S_CANCEL:
#ifdef DESKTOP
			tbl[HMONITOR].value = TempHMonitor;
#endif
			button->eventManager->Put(UI_EVENT(S_CLOSE));
			break;
	};
	return (ccode);
}

void Window_Advanced()
 {
#ifdef DESKTOP
	TempHMonitor = tbl[HMONITOR].value;
#endif
	for (int i=FREQ_640; i <= FREQ_1280; i++)
		tbl[i].value = getDisplayStatus(i);

	UIW_WINDOW *window = new UIW_WINDOW(20, 6, 44, 10, WOF_NO_FLAGS,
			WOAF_MODAL | WOAF_NO_SIZE );

	UI_WINDOW_OBJECT *object = NULL;

	COMBO_BOX *m640  = new COMBO_BOX (16, 2, 18, 3, FREQ_640, 2);
	*m640
		+ new UIW_SCROLL_BAR(0, 0, 0, 0, SBF_VERTICAL )
		+ new COMBO_BOX_ITEM(16, "60 Hz         ", F640_60, FREQ_640)
		+ new COMBO_BOX_ITEM(16, "72 Hz         ", F640_72, FREQ_640);

	COMBO_BOX *m800  = new COMBO_BOX (16, 3, 18, 4, FREQ_800, 3);
	*m800
		+ new UIW_SCROLL_BAR(0, 0, 0, 0, SBF_VERTICAL )
		+ new COMBO_BOX_ITEM(16, "56 Hz         ", F800_56, FREQ_800)
		+ new COMBO_BOX_ITEM(16, "60 Hz         ", F800_60, FREQ_800)
		+ new COMBO_BOX_ITEM(16, "72 Hz         ", F800_72, FREQ_800);

	COMBO_BOX *m1024 = new COMBO_BOX (16, 4, 18, 4, FREQ_1024, 4); // MOD1
	COMBO_BOX *m1280 = new COMBO_BOX (16, 5, 18, 4, FREQ_1280, 3); // MOD1
	COMBO_BOX *m1024h = new COMBO_BOX (16, 4, 18, 4, FREQ_1024, 4);
	COMBO_BOX *m1024d = new COMBO_BOX (16, 4, 18, 4, FREQ_1024, 3); /* SGC, 2-25-93 */
	COMBO_BOX *m1280h = new COMBO_BOX (16, 5, 18, 3, FREQ_1280, 2);
if (isHiFreqProduct) {
	*m1024
		+ new UIW_SCROLL_BAR(0, 0, 0, 0, SBF_VERTICAL )
		+ new COMBO_BOX_ITEM(16, "87 interlaced ", F1024_87i, FREQ_1024)
		+ new COMBO_BOX_ITEM(16, "60 Hz         ", F1024_60, FREQ_1024)
		+ new COMBO_BOX_ITEM(16, "70 Hz         ", F1024_70, FREQ_1024)
		+ new COMBO_BOX_ITEM(16, "72 Hz         ", F1024_72, FREQ_1024);
//MOD1         //+ new COMBO_BOX_ITEM(16, "76 Hz         ", F1024_76, FREQ_1024);

	*m1280
		+ new COMBO_BOX_ITEM(16, "87 interlaced ", F1280_87i, FREQ_1280)
		+ new COMBO_BOX_ITEM(16, "60 Hz         ", F1280_60, FREQ_1280)
//MOD1         // + new COMBO_BOX_ITEM(16, "70 Hz         ", F1280_70, FREQ_1280)
		+ new COMBO_BOX_ITEM(16, "Not available ", NOT_AVAILABLE, FREQ_1280);
}
else {
      if (GD5420 == 0) {    /* SGC, 2-25-93 */
	*m1024h
		+ new UIW_SCROLL_BAR(0, 0, 0, 0, SBF_VERTICAL )
		+ new COMBO_BOX_ITEM(16, "87 interlaced ", F1024_87i, FREQ_1024)
		+ new COMBO_BOX_ITEM(16, "60 Hz         ", F1024_60, FREQ_1024)
		+ new COMBO_BOX_ITEM(16, "70 Hz         ", F1024_70, FREQ_1024)
		+ new COMBO_BOX_ITEM(16, "72 Hz         ", F1024_72, FREQ_1024);
      }
      else {
	*m1024d
		+ new UIW_SCROLL_BAR(0, 0, 0, 0, SBF_VERTICAL )
		+ new COMBO_BOX_ITEM(16, "87 interlaced ", F1024_87i, FREQ_1024)
		+ new COMBO_BOX_ITEM(16, "60 Hz         ", F1024_60, FREQ_1024)
		+ new COMBO_BOX_ITEM(16, "70 Hz         ", F1024_70, FREQ_1024);
      }
	*m1280h
		+ new COMBO_BOX_ITEM(16, "87 interlaced ", F1280_87i, FREQ_1280)
		+ new COMBO_BOX_ITEM(16, "Not available ", NOT_AVAILABLE, FREQ_1280);
}
	*window
		+ new UIW_BORDER
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE("VERTICAL TIMINGS")
		+ new UIW_TEXT(2, 0, 38, 2,
			"WARNING ! Setting the incorrect values may cause damage to the monitor.",
			100, WNF_NO_FLAGS, WOF_BORDER | WOF_NON_SELECTABLE)
		+ new UIW_STRING(4, 2, 12, " 640x480  ", 20, STF_NO_FLAGS, WOF_NON_SELECTABLE | WOF_JUSTIFY_CENTER)
		+ m640
		+ new UIW_STRING(4, 3, 12, " 800x600  ", 20, STF_NO_FLAGS, WOF_NON_SELECTABLE | WOF_JUSTIFY_CENTER)
		+ m800;
		if (getVideoMemory() >= 512)
			*window
			+ new UIW_STRING(4, 4, 12, "1024x768  ", 20, STF_NO_FLAGS, WOF_NON_SELECTABLE | WOF_JUSTIFY_CENTER);
		if (getVideoMemory() >= 1024) {  /* SGC, 2-25-93 */
		  if (GD5420 == 0)
			*window
				+ new UIW_STRING(4, 5, 12, "1280x1024 ", 20, STF_NO_FLAGS, WOF_NON_SELECTABLE | WOF_JUSTIFY_CENTER);
		}

if (isHiFreqProduct){
	if (getVideoMemory() >= 512)
		*window + m1024;
	if (getVideoMemory() >= 1024)
		*window + m1280;
}
else {
	if (getVideoMemory() >= 512)
	  if (GD5420 == 0)              /* SGC, 2-25-93 */
	     *window + m1024h;
	  else
	     *window + m1024d;
	if (getVideoMemory() >= 1024)   /* SGC, 2-25-93 */
	  if (GD5420 == 0)
	     *window + m1280h;
}
	*window
		+ new UIW_BUTTON(8, 7, 10, "O&K",       BTF_NO_TOGGLE | BTF_AUTO_SIZE,
			WOF_BORDER | WOF_JUSTIFY_CENTER, Exit_Advanced, S_CLOSE)
		+ new UIW_BUTTON(24, 7, 10, "C&ancel", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
			WOF_BORDER | WOF_JUSTIFY_CENTER, Exit_Advanced, S_CANCEL);

	object->windowManager->Add(window);
}
#endif                          // desktop

EVENT_TYPE Exit_Monitor(UI_WINDOW_OBJECT *object, UI_EVENT &, EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return 0;

	// Exit the application by sending a message.
	UIW_BUTTON *button = (UIW_BUTTON *)object;

	switch (button->value) {
#ifdef DESKTOP                  // advance monitor is not supported in lap top --sean
		case S_ADVANCED:
			Window_Advanced();
			break;
#endif                          // desktop
		case S_VERIFY:
			setHorzMontype(tbl[HMONITOR].value);
			getmode16List();
			button->eventManager->DevicePosition(E_MOUSE, 0, 0); /* 2.30 beta 2 */
			preview(0x12, TRUE);
			button->eventManager->DevicePosition(E_MOUSE, 0, 0);
			button->eventManager->Put(UI_EVENT(S_REDISPLAY));
			break;
		case S_OK:
			setHorzMontype(tbl[HMONITOR].value);
			button->eventManager->Put(UI_EVENT(S_CLOSE));
#ifdef DESKTOP
			ClearAllTables (); // MOD2, clear centering tables
			TSR_unload ();
#endif
			break;
		case S_CANCEL:
#ifdef DESKTOP
			tbl[HMONITOR].value = TempHMonitor;
#endif
			button->eventManager->Put(UI_EVENT(S_CLOSE));
			break;
		case L_HELP:
			button->eventManager->Put(UI_EVENT(L_HELP));
			break;
	};
	return (ccode);
}

UI_WINDOW_OBJECT *CONTROL_WINDOW::Window_Monitor(void)
{
unsigned int BPOS,WPOS,SPOS,FPOS;   // MOD1

if (isHiFreqProduct) { // MOD1, change size and location for ALPINE II
	BPOS = 18;
	WPOS = 21;
	SPOS = 0;
	FPOS = 5;
}
else {
	BPOS = 17;
	WPOS = 20;
	SPOS = 1;
	FPOS = 4;
}
#ifdef DESKTOP
	TempHMonitor = tbl[HMONITOR].value;
#endif
	for(int i = FREQ_640; i <= HMONITOR; i++)
		tbl[i].value = getDisplayStatus(i);

#ifdef DESKTOP
      GD5420 = is5420 (); /* SGC, 2-25-93, check for 5420, 1 = is there */
#endif
	// Set up the radio controls.
	UIW_GROUP *monlist = new UIW_GROUP(2, 0, 39, 10, " MONITOR SELECTION ");
	*monlist
		+ new RADIO_BUTTON(2, 1, 36, " 0 VGA                            ", MONTYPE_0, HMONITOR, Display_Freq )
		+ new RADIO_BUTTON(2, 2, 36, " 1 8514 compatible                ", MONTYPE_1, HMONITOR, Display_Freq )
		+ new RADIO_BUTTON(2, 3, 36, " 2 Super VGA                      ", MONTYPE_2, HMONITOR, Display_Freq )
		+ new RADIO_BUTTON(2, 4, 36, " 3 Extended Super VGA             ", MONTYPE_3, HMONITOR, Display_Freq )
		+ new RADIO_BUTTON(2, 5, 36, " 4 Multifrequency                 ", MONTYPE_4, HMONITOR, Display_Freq )
		+ new RADIO_BUTTON(2, 6, 36, " 5 Extended Multifrequency        ", MONTYPE_5, HMONITOR, Display_Freq )
		+ new RADIO_BUTTON(2, 7, 36, " 6 Super Multifrequency           ", MONTYPE_6, HMONITOR, Display_Freq )
		+ new RADIO_BUTTON(2, 8, 36, " 7 Extended Super Multifrequency  ", MONTYPE_7, HMONITOR, Display_Freq )
#ifdef DESKTOP                  // advance monitor is not supported in lap top --sean
		+ new RADIO_BUTTON(2, 9, 36, "   Advanced                       ", MONTYPE_8, HMONITOR, Display_Freq );
#else                           // desktop
		;
#endif                          // desktop

#ifdef DESKTOP                  // advance monitor is not supported in lap top --sean
	UIW_GROUP *freqlist = new UIW_GROUP(2, 12, 45, FPOS, "");
#else                           // desktop
	UIW_GROUP *freqlist = new UIW_GROUP(2, 11, 45, 4, "");
#endif                          // desktop
	*freqlist
		+ (hfreqStr = new UIW_STRING(1, 1, 30,  "", 31, STF_NO_FLAGS, WOF_NON_SELECTABLE | WOF_JUSTIFY_CENTER))
		+ (f640Str = new UIW_STRING(1, 2, 18,  "", 19, STF_NO_FLAGS, WOF_NON_SELECTABLE | WOF_JUSTIFY_CENTER))
		+ (f800Str = new UIW_STRING(1, 3, 18,  "", 19, STF_NO_FLAGS, WOF_NON_SELECTABLE | WOF_JUSTIFY_CENTER))
		+ (f1024Str = new UIW_STRING(23, 2, 21, "", 22, STF_NO_FLAGS, WOF_NON_SELECTABLE | WOF_JUSTIFY_CENTER))
		+ (f1280Str = new UIW_STRING(23, 3, 21, "", 22, STF_NO_FLAGS, WOF_NON_SELECTABLE | WOF_JUSTIFY_CENTER))
		+ (f80072Str = new UIW_STRING(1, 4, 42, "", 43, STF_NO_FLAGS, WOF_NON_SELECTABLE | WOF_JUSTIFY_CENTER));  //MOD2

	// Create the monitor window.
	UIW_WINDOW *window = new UIW_WINDOW(15, SPOS, 52, WPOS, WOF_NO_FLAGS,
				WOAF_MODAL | WOAF_NO_SIZE, HELP_MONITOR );

	*window
		+ new UIW_BORDER
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE("Monitor Type Setup")
		+ monlist;

	*window
#ifdef DESKTOP                  // advance monitor is not supported in lap top --sean
		+ (advancedButton = new CL_BUTTON(4, 11, 15, "", Exit_Monitor, S_ADVANCED)) /* SGC, 2-25-93 */
#endif                          // desktop
		+ new CL_BUTTON(2, BPOS, 9, "&Verify", Exit_Monitor, S_VERIFY)   /* SGC, 2-24-93 */
		+ new CL_BUTTON(14, BPOS, 9, "O&K", Exit_Monitor, S_OK)
		+ new CL_BUTTON(26, BPOS, 9, "C&ancel", Exit_Monitor, S_CANCEL)
		+ new CL_BUTTON(38, BPOS, 9, "&Help", Exit_Monitor, L_HELP)
		+ freqlist
		+ new UIW_BUTTON(38, BPOS, 9, "&Help",  BTF_NO_TOGGLE | BTF_AUTO_SIZE,
			WOF_BORDER | WOF_JUSTIFY_CENTER, Exit_Monitor, L_HELP);

	//   Return the window pointer.
		return(window);
}

