

/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	slip_io.c
*
*	$Log:   /b/gregs/i960/uart/slip_io.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:37:50   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:26:44   franks
 * No change.
 * 
 *    Rev 1.0   08 Sep 1993 11:36:44   gregs
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 16:47:16   nim960
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/******************************************************************/
/* 		Copyright (c) 1990, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/

#include <defines.h>
#include <memory.h>
#include <uart.h>


#define LINESIZE	80

extern word ram_control_table[];
extern word ram_int_table[];

extern SlipInt();

unsigned char input_buffer[LINESIZE];
unsigned char output_buffer[LINESIZE];
static int in_in = 0;	/* Offset in buffer at which next input char goes */
static int in_out = 0;	/* Offset in buffer from which next output char taken */
static int out_in = 0;	/* Offset in buffer at which next input char goes */
static int out_out = 0;	/* Offset in buffer from which next output char taken */
static int out_len = 0;	/* Offset in buffer from which next output char taken */

init_slipio_buf()
{
	in_in = in_out = 0;
	out_in = out_out = out_len = 0;
}

SlipPutChar(c)
unsigned char c;
{
	int i;
	int ret_value = 1;

	if (out_len != LINESIZE)
	{
		out_len++;
		output_buffer[out_in] = c;
		if ( ++out_in >= LINESIZE )
			out_in = 0;
	}
	else
		ret_value = -1;
	
	Di();
	uart_control_out(SLIP_PORT, 0);
	i = uart_control_in(SLIP_PORT);

	if (i & 0x04)
	{
		uart_data_out(SLIP_PORT, output_buffer[out_out]);
		if ( ++out_out >= LINESIZE )
			out_out = 0;
		out_len--;
	}
	Ei();

	return ret_value;
}

SlipInt_c()
{

	int i;

	uart_control_out(SLIP_PORT, 0);
	i = uart_control_in(SLIP_PORT);
	/* check for receive characters */
	if (i & 0x01)
	{
		input_buffer[in_in] = uart_data_in(SLIP_PORT);
		if ( ++in_in >= LINESIZE )
			in_in = 0;
		uart_control_out(SLIP_PORT, 0x20);
	}
	/* check for transmit buffer empty */
	if (i & 0x04)
	{
		if ( out_out != out_in )
		{
			/* Input buffer not empty: get character from there. */
			uart_data_out(SLIP_PORT, output_buffer[out_out]);
			if ( ++out_out >= LINESIZE )
				out_out = 0;
			out_len--;
		}
		else
			uart_control_out(SLIP_PORT, 0x28);
	}
	uart_control_out(SLIP_PORT, 0x38);
}

SlipGetChar()
{
	unsigned char c;

	if ( in_out != in_in )
	{
		/* Input buffer not empty: get character from there. */
		c = input_buffer[in_out];
		if ( ++in_out >= LINESIZE )
			in_out = 0;
		return c;
	}
	else
		return -1;
}


/****************************************/
/* init_console:			*/
/*					*/
/* this routine initializes the console	*/
/* port for operation in the polled	*/
/* mode, interrupts disabled.		*/
/****************************************/
InitSlipPort(baud)
int baud;
{
	SCCinit_slip(SLIP_PORT, baud);

	/* (re)initialize the character buffer pointer */
	init_slipio_buf(); 
}


/****************************************/
/* SCCinit_slip:			*/
/*					*/
/*  Initailizes port to known state.	*/
/****************************************/
SCCinit_slip(port,baud)
    volatile struct SCCport *port;
    int baud;
{
	static unsigned char cmds[] = {
	    /*	wreg#	value					*/
	    /*	-----	-----					*/
		0x01,	0x12,	/* Int on All Rx, Tx Int Ena	*/
		0x03,	0xc0,	/* Read 8 bit data, auto enabled*/
		0x04,	0x44,	/* 16x clock, 1 stop bits	*/
		0x05,	0xe2,	/* Write 8 bit data use DTR	*/
		0x09,	0x0a,	/* No Reset, MIE		*/
		0x0b,	0xd2,	/* TxClk = RxClk = Baud Rate Gen*/
		0x0c,	0x12,
		0x0d,	0x00,
		0x0e,	0x01,	/* Start Baud Rate Generator	*/
		0x03,	0xc1,	/* Enable Receiver		*/
		0x05,	0xea,	/* Enable Transmitter		*/
	};
	int i;
	int tc; 
	register int *int_loc;


	tc = (PCLK / (baud * 2 *16)) - 2;

	cmds[13] = (unsigned char)tc;

	cmds[15] = (unsigned char)(tc >> 8);


	ram_control_table[4] |= 0x0300; /* setup timers 1 & 2 vector */
	send_sysctl(0x401, 0, 0); /* load group 1 control registers */
	Ei();

	/* enable mask bits for int 1, 2 and 3 */
	asm("mov 7, sf1");

	/* Setup Interrupt table */
	int_loc = (int *)0x0000000c;
	*int_loc = ram_int_table[50 + 1] = (word)SlipInt;

	/* Program Timer */
	SCCreset(port);

	eat_time(10);

	for ( i = 0; i < sizeof(cmds); i++ ){
		port->control = cmds[i];
		wait_15(); /* wait for 15 cycles before start next cmd */
	}

	eat_time(10);
}


SlipPortTest()
{
	return TRUE;
}


SlipFlush()
{
	while ( out_out != out_in )
	{
		/* Input buffer not empty: get character from there. */
		SCCput(SLIP_PORT, output_buffer[out_out]);
		if ( ++out_out >= LINESIZE )
			out_out = 0;
		out_len--;
	}
}

