/**			       
*
*	Program Name:	tcpip library module
*
*	Filename:	inet_addr.c
*
*	$Log:   /b/gregs/i960/tcpip/util/inet_addr.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:46:38   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:39:24   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:20:46   gregs
 * Initial revision.
 * 
 *    Rev 1.1   13 May 1992 11:12:14   pvcs
 * 
 *    Rev 1.0   30 Mar 1992 17:27:14   pvcs
 * Initial revision.
*
*	Creation Date:	7.15.91
*
*	Date:
*
*	Version:	1.0
*
*	Programmers:
*
*	Modifications:
*
*	Comments:	This file contains inet address manipulation
*			functions.
*
*			-	inet_ntoa
*			-	inet_addr
*			
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <types.h>

/*
 *	interpret character strings representing numbers expressed in
 *	the Internet standard '.' notation, returning numbers sutiable for
 *	use as Internet addresses.
 *	i.e. translate "1.2.3.4" into 0x01020304.
 */
in_name inet_addr(char *IpString)

	{
	uint	ip0;	/*	First byte of ip	*/
	uint	ip1;	/* 	Second byte of ip	*/
	uint	ip2;	/*	Third byte of ip	*/
	uint	ip3;	/*	Forth byte of ip	*/
	uint	tmp;	/* 	for checking ip		*/
	int	argc;	/* 	for checking ip		*/
	in_name	ip;	/*	address to be returned	*/
	byte	*p = (byte *)&ip;

	if ((argc = sscanf(IpString, "%d.%d.%d.%d%c", 
		&ip0, &ip1, &ip2, &ip3, &tmp)) == 4 &&
		ip0 < 256 && ip1 < 256 && ip2 < 256 && ip3 < 256)
		{
		*p++ = (byte)ip0;
		*p++ = (byte)ip1;
		*p++ = (byte)ip2;
		*p++ = (byte)ip3;
		return ip;
		}
	return -1;
	}
/*
 *	translate an ip address into a string.
 *	i.e. translates 0x01020304 into "1.2.3.4".
 */
char *inet_ntoa(in_name ip)

	{
	static	char	IpString[20];	/* to return the string		*/
	byte	*ptr = (byte *)&ip;	/* points the ip address	*/

	sprintf(IpString, "%d.%d.%d.%d", (int)*ptr, (int)*(ptr + 1),
		(int)*(ptr + 2), (int)*(ptr + 3));
	return IpString;
	}
