/**			       
*
*	Program Name:	UDP Module	
*
*	Filename:	udp_open.c
*
*	$Log:   /b/gregs/i960/tcpip/udp/udp_open.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:45:56   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:39:08   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:19:32   gregs
 * Initial revision.
 * 
 *    Rev 1.3   17 Jun 1992 13:13:34   vinay
 * Removed stuff concerned with Errorlog
 * 
 *    Rev 1.2   16 Jun 1992 16:04:02   vinay
 * Changed printf to include Errorlog function
 * 
 *    Rev 1.1   13 May 1992 11:02:42   pvcs
 * 
 *    Rev 1.0   16 Apr 1992 18:29:06   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		2.6.91
*
*	Version:	1.0
*
*	Programmers:
*
*	Modifications:
*
*	Comments:	Port to i960 platform.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/* Copyright 1986 FTP Software Inc. */

/*  Copyright 1984,1985 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
/* #include	<notice.h>	*/

#include <krnl.h>
#include <types.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <udp.h>
#include "internal.h"


/* Create a UDP connection and enter it in the demux table. */

/*	EDIT HISTORY:
	6/23/86	Romkey	rewrote udp_ckcon()
*/

UDPCONN firstudp = NULL;

UDPCONN udp_open(lsock, handler, data)
uint	lsock;			/* local socket */
int	(*handler)();		/* upcalled on receipt of a packet */
uint	data; 			/* random data */

	{		
	register UDPCONN	con;
	UDPCONN		LastConnection;	/* points to the last UDPCONN	*/

	/*
	 *	Look it up in the link list to see
	 *	if the socket is already been registered.
	 */
	for (con = firstudp; con != NULL; con = con->u_next) 
		{
		if (con->u_lport == lsock)
			/*
			 *	Socket has been used, returns
			 *	error.
			 */
		{
			printf("Socket is already used\n");
			return NULL;
		}
		LastConnection = con;
		}
	if ((con = (UDPCONN)malloc(sizeof(struct udp_conn))) == NULL)
		{
		printf("udp_open: malloc failed\n");
		return NULL;
		}
	con->u_next = NULL;

	/*
	 *	If the list is not empty, add the new connection
	 *	to the linked list.
	 *	Otherwise, this is the first connection.
	 */
	if (firstudp != NULL)
		LastConnection->u_next = con;
	else
		firstudp = con;

	con->u_lport = lsock;		/* fill in connection info */
	con->u_rcv   = handler;
	con->u_data  = data;
	return con;
	}




/* close a udp connection - remove the connection from udp's list of
	connections and deallocate it.
   But only if the connection is not null.  1/16/84 <J. H. Saltzer>
*/

udp_close(con)
register UDPCONN con; 
	{
	register UDPCONN	pcon;

	if (firstudp != NULL && firstudp == con)
		{
		firstudp = con->u_next;
		free(con);
		return TRUE;
		}
	else 
		{
		for (pcon = firstudp; pcon; pcon = pcon->u_next)
			if (pcon->u_next == con) 
				{
				pcon->u_next = con->u_next;
				free(con);
				return TRUE;
				}
		}
	return FALSE;
	}
