/**			       
*
*	Program Name:	Loading Module
*
*	Filename:	tftpload.c
*
*	$Log:   /b/gregs/i960/tcpip/tftp/tftpload.c_v  $
 * 
 *    Rev 1.4   21 Oct 1993 10:40:38   franks
 * The OneSecondTimer is now created before being used.
 * 
 *    Rev 1.3   12 Oct 1993 10:45:12   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:38:14   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:56:08   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:18:48   gregs
 * Initial revision.
 * 
 *    Rev 1.3   16 Jun 1992 17:41:58   vinay
 * changed back to rev 1.1
 * 
 *    Rev 1.2   16 Jun 1992 15:45:44   vinay
 * Changed printf to include Errorlog function
 * 
 *    Rev 1.1   13 May 1992 10:58:10   pvcs
 * 
 *    Rev 1.0   30 Mar 1992 17:25:14   pvcs
 * Initial revision.
*
*	Creation Date:	1.30.91
*
*	Date:
*
*	Version:	1.0
*
*	Programmers:
*
*	Modifications:
*
*	Comments:	This file contains functions to load an image
*			file from a server by means of tftp.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/


#include <krnl.h>
#include <task.h>
#include <types.h>
#include <netbuf.h>
#include <udp.h>
#include <tftpboot.h>
#include <tftp.h> 


extern void	PrintBuffer(char *buffer, int size);

extern ulong	TftpLoadFile(long ip, char FileName[], 
			char *mode, int (*RcvHandler)());
extern void	TftpTimerExpires(void);
extern int	StartTftpTimer(void);
extern int	TRxPacket(unsigned int BlockNumber, char * Packet, 
			int PacketLength);
extern	void	PutTftpError(int state, in_name server);

static void AliveTimerCall(TIMER *timer);


int 	(*TftpRcvPacket)();	/* handler to receive tftp packet	*/
 
/* 
 *	The default tftp time out
 */
#define	TFTP_TIMEOUT	100	/* 1 second	*/
#define	TFTP_MAX_TIMEOUT	500	/* 5 seconds	*/


static TIMER	TftpTimer;
static int	TftpTimeTick;
static byte 	*LoadBuffer;		/* load file in here	*/
static byte	*NextLoadBuffer;/* this address will be updated 
				 * when a tftp packet has received
				 * and loaded.
				 */
/*
 * name		TftpLoadFile 	load an image file from a server
 *
 * synopsis	ulong TftpLoadFile(ip, FileName, mode, RcvHandler)
 *		long	ip; <<	ip address of the server
 *		char	FileName[]; <<	file to be downloaded
 *		char	*mode;		<< file read mode.
 *		int	(*RcvHandler)()	<< Packet handler function.
 *
 * description	It loads the file "FileName" from the server with
 *		ip address "ip".  The loading address will be decided
 *		when the first packet has arrived.  We can look at 
 *		the header of the file to decide where to load the file.
 *		This is the main polling task.  There is another task
 *		to handle incoming packet and set the timeout flag.
 *
 * returns	file length	
 */

ulong TftpLoadFile(long ip, char FileName[], char *mode, int (*RcvHandler)())

	{
	int	rrq_retry = 0;
	TIMER	OneSecondTimer;	/* expires every second	*/

	if ( RcvHandler == NULL || FileName[0] == '\0')
		return 0;

	CreatTimer(&TftpTimer);
	CreatTimer(&OneSecondTimer);
	TftpTimeTick = TFTP_TIMEOUT;
	tftp.state = NOCON;	/* no connection yet	*/
	tftp.con = NULL;
	tftp.done = FALSE;
	tftp.timeout = 0;
	tftp.retry = 0;
	tftp.abort = 0;
	TftpRcvPacket = RcvHandler;	/* set the Receive packet */
	/*
	 *	Get a random source port number. 
	 */
	tftp.sport = udp_socket();
	TftpTimeTick = TFTP_TIMEOUT;
	if ((tftp.con = udp_open(tftp.sport, tftprcv, NULL)) == NULL)
		{
		printf("TFTP Error: Unable to open UDP socket\n");
		return 0;
		}
	/*
	 *	print a '.' every second to
	 *	show that we are alive
	 */
	StartTimerCall(&OneSecondTimer, 100, AliveTimerCall, (int)&OneSecondTimer);
	if (tftp_rrq(ip, FileName, mode) != 0)
		{
		StopTimer(&OneSecondTimer);
		udp_close(tftp.con);
		PutTftpError(tftp.state, ip);
		return 0;
		}
	StartTftpTimer();
	while (!tftp.done)
		{
		if (tftp.abort)
			{
			StopTimer(&OneSecondTimer);
			StopTftpTimer();
			udp_close(tftp.con);
			return 0;
			}
		if (tftp.timeout)
			{
			if ((tftp.state == REQ && tftp.retry >= MAXRTXCNT - 1) ||
				(tftp.state == CON && tftp.retry >= MAXDTXCNT - 1) ||
				(tftp.state == NOCON && tftp.retry >= MAXDTXCNT - 1))
				{
				/*
				 *	Print error message
				 */
				PutTftpError(tftp.state, ip);
				StopTimer(&OneSecondTimer);
				udp_close(tftp.con);
				return 0;
				}
		  	/* if state=REQ then send tftprrq with backoff timer */
			if(tftp.state == REQ)
				{
				if (tftp_rrq(ip, FileName, mode) != 0)
					{
					/*
					 *	Print error message
					 */
					PutTftpError(tftp.state, ip);
					StopTimer(&OneSecondTimer);
					udp_close(tftp.con);
					return 0;
					}
				TftpTimeTick <<= 1;/* double the timeout */
				if (TftpTimeTick > TFTP_MAX_TIMEOUT)
					TftpTimeTick = TFTP_MAX_TIMEOUT;
				StartTftpTimer();
				}
			else if(tftp.state == CON)
				{
				send_ack(&tftp);
				TftpTimeTick += 30; /* add 300 ms timeout */
				StartTftpTimer();
				}
			tftp.retry++;
			tftp.timeout = 0;
			}
		ReSchedule();
		}
	debugc('!');
	StopTftpTimer();
	StopTimer(&OneSecondTimer);
	udp_close(tftp.con);
	return tftp.length; 
	}
/*
 * name		TftpTimerExpires	- timer expiry handler
 *
 * synopsis	void TftpTimerExpires(void)
 *
 * description	This function is called when the tftp timer "tftp_timer"
 *		expires.  It sets the timeout flag to notifies the 
 *		main polling task.
 *
 * returns	nothing
 */

void TftpTimerExpires()

	{
	tftp.timeout++;
	}

/*
 * name		StartTftpTimer	-	start the tftp timer
 *
 * synopsis	int StartTftpTimer(void)
 *
 * description	It starts the tftp timer.  If the timer is still running,
 *		it stops the timer before starting the timer.
 *
 * returns	TRUE	done
 *		FALSE	error
 */

int StartTftpTimer()

	{
	void 	TftpTimerExpires();

	return StartTimerCall(&TftpTimer, TftpTimeTick, TftpTimerExpires, NULL);
	}


/*
 * name		StopTftpTimer	-	start the tftp timer
 *
 * synopsis	int StopTftpTimer(void)
 *
 * description	It stops the tftp timer.  
 *
 * returns	0	error
 *		otherwise, done
 */

int StopTftpTimer()

	{
	return (int)StopTimer(&TftpTimer);
	}
	
/*
 * name		TRxPacket	handle incoming packet
 *
 * synopsis	int TRxPacket(BlockNumber, Packet, PacketLength)
 *		unsigned int	BlockNumber; <<	of this packet
 *		char 	*Packet; <<	the incoming packet
 *		int	PacketLength; <<	
 *
 * description	It copies the incoming tftp packet into the 
 *		loading area. 
 *
 * returns	0		error
 *		otherwise	done
 */

TRxPacket(BlockNumber, Packet, PacketLength)
unsigned int	BlockNumber;	/* block number */
char	*Packet;	/* pointer to data */
int	PacketLength;		/* packet length */

	{
	int	SetLoadAddress();

	if (BlockNumber == 1)
		{
		/*
		 *	If this is the first packet,
		 *	check the file header is ok and
		 *	get the "text" loading address from
		 *	the header.
		 */
		if (SetLoadAddress(Packet, &LoadBuffer) == 0)
			{
			return FALSE;
			}
		NextLoadBuffer = LoadBuffer;
		}
	/*printf("BLK# %d (%X)##", BlockNumber, NextLoadBuffer);*/
	memcpy((byte *)NextLoadBuffer, Packet, PacketLength);
	NextLoadBuffer += PacketLength;
	return TRUE;
	}
/*
 *	Print out an error message depending upon
 *	the current state of tftp
 */
void PutTftpError(state, server)
int	state;		/* tftp state	*/
in_name	server;		/* server ip address	*/

	{
	switch(state)
		{
		case NOCON:
			/*
			 *	Cannot send packet
			 */
			printf("\nError: Cannot reach tftp server (%s)\n",
				inet_ntoa(server));
			break;

		case REQ:
			/*
			 *	No response from server
			 */
			printf("\nError: No response from tftp server (%s)\n",
				inet_ntoa(server));
			break;

		case CON:
			/*
			 *	Network error
			 */
			printf("\nError: Network error\n");
			break;
		default:
			printf("\nError: Unknown internal error\n");
			break;
		}
	}

/*
 *	print a '.' every second to
 *	show that we are alive
 */
static void AliveTimerCall(TIMER *timer)

	{
	putchar('.');
	StartTimerCall(timer, 100, AliveTimerCall, (int)timer);
	}

