/**
 *	Program Name:	telnet program
 *
 *	Filename:	up.c
 *
 *	$Log:   /b/gregs/i960/tcpip/telnet/up.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:44:48   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:37:44   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:18:28   gregs
 * Initial revision.
 * 
 *    Rev 1.3   11 Nov 1992 09:37:54   ramki
 * No change.
 * 
 *    Rev 1.2   27 Jul 1992 16:02:36   ramki
 * removed extern uint tnsz
 * 
 *    Rev 1.1   08 May 1992 10:07:30   ramki
 * changed LAT related things
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/

#include <types.h>
#include <krnl.h>
#include <task.h>
#include <netbuf.h>
#include <ether.h>
#include <ip.h>
#include <icmp.h>
#include <mtcp.h>
#include <mtcpblk.h>
#include <tcpip.h>
#include <error.h>
#include <telnet.h>


void	*filter_con();
/*
 *  TCP UPCALLS 
 */

/* incoming call */
telnet *tn_filter_con(con, fhost, fskt, lhost, lskt)
TcpCon	con;		/* TCP connection */
in_name	fhost;		/* foreign host */
in_name lhost;
uint	fskt;		/* foreign socket */
uint	lskt;		/* local socket */
{
	extern	telnet	*fnd_tn();
	register telnet	*tn;
	void	*x;
	int	WakeupTime;

	if (!(tn = fnd_tn()))
		return NULL;	/* no resources: reject call */
	if ((x = filter_con(tn, PS_TCPIP, fhost, fskt, lskt, lhost)) == 0)
		return NULL;	/* fetched TN is still marked as free */
	tn->tn_tag = x;
	tn->tn_tcp = con;
	tn->tn_psid = PS_TCPIP;	/* regular TCP protocol */
	tn->tn_nus = TN_NUS_OPEN;

	/* start timer */
	if ((fhost & _initp->net_mask) == (_initp->in_me & _initp->net_mask))
		WakeupTime = 500;	/* on this sub-net: wait up to 5 seconds */
	else
		WakeupTime = 6000;	/* off this sub-net: wait up to a minute */
	StartTimerCall((TIMER *)&tn->tn_tmr, WakeupTime, tn_up_timer, (int)tn);	
	return tn;
}

/* open completed */
tn_up_open(con)
TcpCon	con; 
{
	register telnet *tn = (telnet *)con->ufield;

	if (tn == 0 || tn->tn_chk != TN_CHECK || tn->tn_nus != TN_NUS_OPEN)
		return;	/* must be in waiting state */

	tn->tn_nus = TN_NUS_ACTV;
	tn->tn_do = 0;		/* no options enabled yet */
	tn->tn_do_req = 0;
	tn->tn_will = 0;	/* no options enabled yet */
	tn->tn_will_req = 0;
	tn->tn_mode = 0;
	tn->tn_gchrs = 0;
	tn->tn_take = 0;
	tn->tn_fill = 0;
	tn->tn_fhst = con->fhost;
	tn->tn_fskt = con->dstport;
	tn->tn_lskt = con->srcport;
	tn->tn_bufs = tnsz;
	tn->tn_pktptr = NULL;
	StopTimer(&tn->tn_tmr);
	tn_opened(tn, tn->tn_tag);
}

/* data received */
tn_up_rcv(con, pkt, len, urg)
TcpCon	con;
PACKET	pkt;
int	len;
int	urg;
{
	register telnet	*tn = (telnet *)con->ufield;
	struct tcp	*tp;
	int	oldgchrs = tn->tn_gchrs;
	uint	avail;

	if (con == NULL || tn->tn_chk != TN_CHECK
	|| (tn->tn_nus & ~(TN_NUS_ACTV | TN_NUS_CLOS)) 
	)
	{
		in_free(pkt);
		return 0;
	}

	/* watch for URGENT indications, flush held data if arrived */
	if (urg)
	{
		/* flush any chars hanging around */
		tn->tn_mode |= M_URG;
		tn->tn_gchrs = 0;	/* flush stored data */
		tn->tn_take = 0;
		tn->tn_fill = 0;
	}

	/* process packet */
	SendMessage((MSGHDR *)pkt, &tn->tn_mbox);	/* queue it */
	while (tn_fill(tn))
		continue;	/* copy data from packet(s) to buffer */
	if (oldgchrs == 0 && tn->tn_gchrs != 0)
	{
		tn_received(tn, tn->tn_tag);	/* buffer no longer empty */
	}

	/* return updated window information */
	avail = tn->tn_bufs - tn->tn_gchrs;
	if (avail >= _initp->tn_maxw)
		return _initp->tn_maxw;
	else
		return avail;
}



/* foreign host closed */
tn_up_fclose(con)
TcpCon	con;
{
	register telnet	*tn = (telnet *)con->ufield;

	if (con == NULL || con != (TcpCon)tn->tn_tcp
		|| tn->tn_chk != TN_CHECK || tn->tn_nus != TN_NUS_ACTV)
		return;
	tn->tn_nus = TN_NUS_FCLOSE; /* Foreign host has closed */
	tn_fclosed(tn, tn->tn_tag);
}

/* local side is now closed */
tn_up_close(con, reason)
TcpCon	con;
int	reason;
{
	register telnet	*tn = (telnet *)con->ufield;
	int	state = tn->tn_nus;

	/* free the resources */
	if (con == NULL || con != (TcpCon)tn->tn_tcp
		|| tn->tn_chk != TN_CHECK 
		|| tn->tn_nus == TN_NUS_FREE)
		return;

	tn->tn_tcp = NULL;	/* the connection is already gone! */
	if(tn->tn_nus == TN_NUS_FCLOSE && tn->tn_gchrs)
	{
		/* There is some more data in the buffer wait for the */
		/* application to empty it and do a down call */
		tn->tn_nus = TN_NUS_FCLOSED;
		return;
	}
	/* up indicate closing */
	if (reason)
		tn_faulted(tn, tn_clean(tn), reason); /* abort indication! */
	else if (state == TN_NUS_CLOS)
		tn_closed(tn, tn_clean(tn)); /* graceful close */
	else
		tn_faulted(tn, tn_clean(tn), ERR_F_ABORT); /* abort indication! */
} 



/* tn open/close timeout routine */
void tn_up_timer(tn)
register telnet	*tn;
{
	if (tn->tn_chk != TN_CHECK || tn->tn_nus == TN_NUS_FREE)
		return;
	tn_faulted(tn, tn_clean(tn), ERR_TIMEOUT);	/* kill it now */
}
