/**
 *	Program Name:	telnet program
 *
 *	Filename:	event.c
 *
 *	$Log:   /b/gregs/i960/tcpip/telnet/event.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:44:40   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:37:36   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:18:18   gregs
 * Initial revision.
 * 
 *    Rev 1.3   30 Nov 1992 12:42:12   kenb
 * Added Support for tn3270
 * 
 *    Rev 1.2   27 Jul 1992 17:28:16   forrest
 * Added V2
 * 
 *    Rev 1.0   27 Jul 1992 17:26:14   forrest
 * Initial revision.
 * 
 *    Rev 1.1   08 May 1992 10:04:04   ramki
 * Changed the lat related things
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/
#include <types.h>
#include <krnl.h>
#include <dbd.h>
#include <error.h>
#include <telnet.h>

#ifdef    V2 
#include <dbd.h>
#include <v2main.h>
#include <v2ptp.h>
#include <v2rsp.h>
#include <v2smp.h>
#include <v2fns.h>
#endif

/*
 * EVENT - OUTBOUND
 */

/* event generation */
tn_event(tn, code, urg)
telnet	*tn;
int	code;
int	urg;

	{
	static byte	event[2] = {TN_IAC, 0};

	if (tn->tn_nus != TN_NUS_ACTV)
		return ERR_NOTCONN;

	switch(tn->tn_psid)
		{
	case PS_TCPIP:
#ifdef TN3270
	case PS_TN3270:
#endif
		if (code == TN_SYNC)
			return tn_sync(tn);	/* sync command */
		event[1] = code;	/* make message */
		/* send non-urgent message */
		if (urg == 1 || (urg == 2 && (tfwindow(tn) < 2)))
			tn_sync(tn);
		return tn_putstr(tn, event, 2);	/* send message */
#ifdef LAT 
	case PS_LAT:
		if (code == TN_BREAK)
			lat_send_break(tn->tn_tcp);
		return 0;
#endif
#ifdef  V2
	case PS_V2:
		if (code == TN_BREAK)
			smp_send((V2SESSTBL *)tn->tn_tcp, 1/*INTRSTREAM*/, (char *)event, 0, PKTINTRPT);
		return 0;
#endif


	default:
		return ERR_NOTCONN;
		}
	}


static byte s_req[] = {TN_IAC, TN_SB, TN_STATUS, STA_SEND, TN_IAC, TN_SE};
static byte s_rsp[48] = {0};

tn_status(tn, req)
telnet	*tn;
int	req;
{
	byte	*cp = s_rsp;
	int	i;

	if (tn->tn_psid != PS_TCPIP
#ifdef TN3270
		&& tn->tn_psid != PS_TN3270
#endif
		)
		return 0;

	if (req == REQ)
	{ /* send status request */
		if (!(tn->tn_do & F_STATUS))
			return ERR_NOTNEGOT;	/* not negotiated */
		return tn_putstr(tn, s_req, sizeof(s_req));
	}
	else 
	{ /* send status response */
		if (!(tn->tn_will & F_STATUS))
			return ERR_NOTNEGOT;	/* not negotiated */
		CopyShort(TN_IAC + 256 * TN_SB,cp);
		cp += 2;
		CopyShort(TN_STATUS + 256 * STA_IS,cp);
		cp += 2;
		for (i = 1; i <= F_SYTEK; i <<= 1)
		{
			if (tn->tn_will & i)
			{
				CopyShort(TN_WILL + 256 * flg2char(i),cp);
				cp += 2;
			}
			if (tn->tn_do & i)
			{
				CopyShort(TN_DO + 256 * flg2char(i),cp);
				cp += 2;
			}
		}
		CopyShort(TN_IAC + 256 * TN_SE,cp);
		cp += 2;
		return tn_putstr(tn, s_rsp, cp - s_rsp);
	}
}

static byte s_buf[SBBFMAX+10] = {0};
tn_sytek(tn, a, l, urg)
telnet	*tn;
char	*a;
int	l;
int	urg;
{
	byte *cp = s_buf;

#ifdef  LAT 
	if (tn->tn_psid == PS_LAT)
		return 0;
#endif
#ifdef V2
	if (tn->tn_psid == PS_V2 && (tn->tn_will & F_SYTEK))
		{
		*(a + l) = 0x0d;
		return smp_send((V2SESSTBL *)tn->tn_tcp, /*DATASTREAM*/ 0, a, l+1, (tn->tn_mode) ? NEWPKTPRIVRC : NEWPKTREMCMD);
		}
#endif

	/* send status data */
	if (!(tn->tn_will & F_SYTEK) && !(tn->tn_do & F_SYTEK))
		return ERR_NOTNEGOT;	/* not negotiated */
	if (l > sizeof(s_buf) - 10)
		return OUT_OF_RANGE;

	/* write preamble including my IEEE MFG value */
	CopyShort(TN_IAC + 256 * TN_SB,cp);
	cp += 2;
	CopyShort(TN_SYTEK + 256 * 0x00,cp);
	cp += 2;
	CopyShort(0x00 + 256 * 0x10,cp);
	cp += 2;
	memcpy(cp, a, l);
	cp += l;
	CopyShort(TN_IAC + 256 * TN_SE,cp);
	cp += 2;
	CopyShort(TN_IAC + 256 * TN_DM,cp);

	/* send non-urgent message */
	if (urg == 0 || (tfwindow(tn) >= l + 8  &&  urg == 2))
		return tn_putstr(tn, s_buf, l + 8);
	/* urgent mode required */
	tn_sync(tn);
	return tn_putstr(tn, s_buf, l + 10);
}


/*
 * EVENT - INBOUND
 */

/* process inbound event */
proc_event(tn, c)
telnet	*tn;
uint	c;

	{
	tn_evented(tn, tn->tn_tag, c);
	}

/* status sub-negotiation processing */
proc_status(tn, cp, cl)
register telnet	*tn;
byte	*cp;
int	cl;

	{
	uint	f_do = 0;	/* build foreign do status */
	uint	f_will = 0;	/* build foreign will status */
	uint	f;
	uint	s;

	if (*cp == STA_SEND)
		return tn_statused(tn, tn->tn_tag, 0, 0, IND); /* indication */
	else if (*cp == STA_IS)
		{
		/* parse status */
		while (cl > 0)
			{
			s = *++cp;
			f = char2flg(*++cp);
			cl -= 2;

			switch(s)
				{
			case TN_WILL:
				f_will |= f;
				continue;

			case TN_DO:
				f_do |= f;
				continue;
				}
			}
		return tn_statused(tn, tn->tn_tag, f_will, f_do, CNF); /* cnfrmd */
		}
	}

/* Sytek sub-negotiation processing */
proc_sytek(tn, cp, cl)
telnet	*tn;
byte	*cp;
int	cl;

	{
	if (*cp++ != 0x00 || *cp++ != 0x00 || *cp++ != 0x10)
		return;	/* invalid */
	tn_syteked(tn, tn->tn_tag, cp, cl - 3);
	}


proc_termtype(tn,cp,cl)
telnet	*tn;
byte	*cp;
int	cl;

	{
	if(*cp != STA_SEND)
		return;
	handle_termtype(tn, tn->tn_tag);
	}
