/**			       
*
*	Program Name:	tcp/ip tcp module
*
*	Filename:	send.c
*
*	$Log:   /b/gregs/i960/tcpip/tcp/send.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:44:06   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:37:14   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:17:54   gregs
 * Initial revision.
 * 
 *    Rev 1.2   13 May 1992 10:45:02   pvcs
 * No change.
 * 
 *    Rev 1.1   08 May 1992 13:28:30   ramki
 * Modified send_packet to set the PSH bit only for data packets
 * 
 *    Rev 1.0   08 May 1992 13:25:34   ramki
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		7.26.91
*
*	Version:	1.2
*
*	Programmers:	not known
*
*	Modifications:	K Kong	4.19.91
*			Port to the 80960 platform. 
*			i.e.	remove "far", int is 32 bit ...etc
*
*			K Kong	5.14.91
*			Do not use sizeof() operator to get the the size
*			of tcp header (struct tcp) and tcp pseudo header
*			(struct tcpph) as it will give the size of the
*			structure with padded data. What we really 
*			want is the unpadded size.
*			TCP_SIZE and TCPPH_SIZE are the unpadded size of
*			struct tcp and struct tcpph respectively.
*
*			K Kong	7.26.91
*			Do not pass the destination NID and firsthop 
*			ip address to "in_write".  We should let the 
*			ip layer and the mac layer to find these out.
*			Anyway, the destination NID and firsthop ip are
*			not enough to reach the host we want to talk to.
*			We have multi-ports and we have to know which port
*			the the host is on.
*
*			Ramki 2-13-92
*			Made changes to pass the local host address to in_write
*
*			Ramki 5-8-92
*			Set the PSH in send_packet only if there is data in the
*			packet. Some hosts do not like it otherwise
*
*	Comments:	This file contains the function to send tcp
*			segment.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
 * send.c - Transmit routines for multiple-connection TCP
 *
 * Copyright 1986, 1987, by FTP Software, Inc.
 *
 * Edit History
 * 15-Aug-86	1.1x00	jbvb	Started to fix lock-step transmit.
 * 03-Sep-86	1.1x05	jbvb	tcp_clean() DOES TOO return...
 *				 improve/repair statistics.
 *		1.1x06	jbvb	Use general purpose queue routines (q.h).
 * 08-Sep-86	1.1x07	jbvb	Send 2 buffers if re-xmit & out_q long.
 * 10-Sep-86	2.0	jbvb	Cleaned up for PC/TCP release 2.0
 * 11-Sep-86	2.0	jbvb	Minor optimizations
 * 02-Dec-86	2.0	jbvb	Added lock for xmit queue
 * 08-Dec-86	2.0	jbvb	Added timestamps on newly xmitted buffers,
 *				 flush double xmit (saturates 3C500)
 * 21-Dec-86	2.0	jbvb	Only clear timestamp when required
 * 27-Dec-86	2.1x01	jbvb	Move release of send queue lock.
 * 28-Dec-86	2.1x02	jbvb	Remove obsolete error checks, flush send_me()
 * 02-Jan-87	2.1x03	jbvb	Flush useless code, clear dallytimer on send.
 * 12-Feb-87	2.1x04	jbvb	Move rexmit timeout to allow for slow packet
 *				 send on serial links
 * 17-Apr-87	2.1x05	jbvb	Allow for dynamic TCP header lengths (MSS opt)
 * 20-Apr-87	2.1x06	jbvb	Add retransmit backoff logic.
 * 23-Apr-87	2.1x07	jbvb	Tweak rexmit table after Arpanet tests
 * 27-Sep-87		romkey	Made some printf()'s #ifndef KERNEL for 2.0.
 */

#include <types.h>
#include <krnl.h>
#include <task.h>
#include <ether.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <mtcp.h>
#include <mtcpblk.h>
#include <tcpip.h>
#include <error.h>
#include "internal.h"

static	void	CheckTcpSend(void);

/*
 * Retransmit backoff table: Not optimized for use with 1.1 applications
 */
/*static int backoff[]	= {1, 2, 2, 4, 4, 8, 8, 16};*/
static char backoff[]	= {1, 2, 2, 4, 4, 8, 8, 16};

/* This routine forms the main body of the TCP data sending task.  This task
 * is awakened for one of two reasons: someone has data to send, or a resend
 * timeout has occurred and a retransmission is called for.
 * If data is being sent, we pick up the last packet on the output
 * queue, otherwise we pick up the first packet (avoiding retransmissions
 * of multiple unacked packets, because the net.gurus said this was a
 * bad idea).
 * This routine in either case finishes filling in the header of the
 * output packet, and calls in_write() to send it to the net.
 * Then, it saves the packet on the ack-pending queue, updates the
 * transmitted sequence number, and blocks.
 */
tcp_send_main()
	{
	PACKET	p;

	for (;;)
		{
		/*
		 *	Put to sleep until somebody send me
		 *	a signal to wake up.
		 */
		RcvSignal(&TcpSendSem);
		/*
		 *	Clear the signal
		 */
		TcpSendSem.sm_count = 0;

		while (p = (PACKET)AcptMessage(&clrsMbox))
			{
			in_write(tcpfd, p, p->db_actcnt, (in_name)p->nb_seq,
			         (in_name)p->nb_con, (NID *)NULL, (in_name *)NULL);
			in_free(p);
			}
		CheckTcpSend();
		}
	}

static void CheckTcpSend()

	{
	register TcpCon con;

	/*
	 *	Go through the connection list and check if we
	 *	have anything to send.
	 */
	for (con = tcp_list.tc_flink; con != &tcp_list; con = con->tc_flink)
		{
		if ((con->tc_mustrun & 0x7f) == 0)
			/*
			 *	Nothing to send on this connection,
			 *	check the next one.
			 */
			continue;
		if (con->tc_mustrun & 0x80)
			{
			/* bind ip & IEEE first hop */
			con->tc_mustrun &= ~0x80;
			tcp_send_learn(con);
			}
		if (con->tc_mustrun & TC_RUN_SEND_ALIVE)	
			{
			/* send keep alive */
			/* force data transmission */
			con->tc_mustrun |= TC_RUN_SEND_DATA;	
			/* dont clear the keep alive request flag */
			/* con->tc_mustrun &= ~TC_RUN_SEND_ALIVE;	*/
			tcp_send_alive(con);
			}
		if (con->tc_mustrun & TC_RUN_SEND_DATA)	
			{
			/* send data */
			if (tcp_send_data(con))
				/* clears ack also */
				con->tc_mustrun &= 
					~(TC_RUN_SEND_DATA | TC_RUN_SEND_ACK);
			}
		if (con->tc_mustrun & TC_RUN_SEND_ACK)
			{
			/* send ack */
			if (tcp_send_ack(con))
				con->tc_mustrun &= ~TC_RUN_SEND_ACK;
			}
		}
	}


/* learn IP firsthop and its Ethernet address */
tcp_send_learn(con)
register TcpCon con; 

	{
	int	code;
	NID	*np;
	uint	flags;
	int	PortList;

	/* get IP first hop */
	if (code = inroute(con->fhost, con->lhost, &con->tc_fhop))	
		return code;
	/*
	printf("tcp_send_learn:local host %x\n",con->lhost);
	*/
	if (code = ip2et(&np, &flags, con->tc_fhop, con->lhost, &PortList))
		return code;
	ncopy(&con->tc_nid, np);
	/* store packet flags */
	con->tc_flags = flags;
	/* reset flags in pkt */
	((PACKET)con->out_q.mb_mflink)->nb_flags = flags;
	return 0;
	}


/* send data */
tcp_send_ack(con)
register TcpCon con; 
	{
	register PACKET	x_buf;		/* current packet pointer */
	struct tcp	*otp;		/* tcp header pointer (temp) */
	int		hdr_len;	/* Size of packet's TCP header */

	x_buf = (PACKET) con->out_q.mb_mflink; /* send head buffer by default */
	if (x_buf->db_contrl & DBDINXMT)
		return 0;		/* job not performed! */

	/* put connection's current values into the tcp header */
	otp = (struct tcp *)in_data(in_head(x_buf));
	otp->tc_srcp = con->srcport;		/* init header */
	otp->tc_dstp = con->dstport;
	SeqCopy(&otp->tc_seq, &x_buf->nb_seq);
	SeqCopy(&otp->tc_ack, &con->cur_ack);	/* load current ack */
	otp->tc_win = con->loc_win;
	if (x_buf->nb_furg == 1)
		otp->tc_urg = x_buf->nb_urg;
	tcp_swab_hton(otp);			/* swap the bytes */
	/*
	 *	Copy all the flags such as header length, fin bit,
	 *	push bit, ack valid ... etc.
	 *	This is to speed up the copying of the bit fields.
	 *	This is to assume that the bit fields must be followed 
	 *	by nb->urg.
	 */
	*((ushort *)&otp->tc_win-1) = *((ushort *)&x_buf->nb_urg - 1); 
	/* copy all flags */
	if (con->conn_state >= SYNRCVD)	/* once past SYNSENT, always ack */
		otp->tc_flags |= ACK_BIT;
	otp->tc_flags &= ~PSH_BIT;

	/* prepare checksum */
	hdr_len = x_buf->nb_thl << 2;	/* get TCP header length */
	con->ophp.tp_len = htons(hdr_len);	/* Fill in TCP hdr */
	otp->tc_cksum =	cksum((byte *)&(con->ophp), TCPPH_SIZE >> 1);
	otp->tc_cksum = ~cksum((byte *)otp, (hdr_len + 1) >> 1);
	if (otp->tc_cksum == 0)
		otp->tc_cksum = 0xffff;

	/* transmit */
	in_write(tcpfd, x_buf, hdr_len, con->fhost, con->lhost,
	         NULL, NULL);
	return 1;		/* job performed */
	}


tcp_send_data(con)
register TcpCon con; 
{
	register PACKET		x_buf;		/* current packet pointer */
	uint		rtt_time;	/* Value for re-xmit timer? */

	PACKET	p_ptr = (PACKET) con->out_q.mb_mblink;
	/****
	char	buffer[80];
	*******/

	if (con->SendReason == 0)
		{
		/* AWC 8/16/89 LOOP THROUGH queue to send all the packets*/
		for(x_buf = (PACKET) con->out_q.mb_mflink;
			x_buf != NULL;
			x_buf = x_buf->db_nxtpkt)
			{
			if (x_buf->nb_flags & PKT_SENTOUT)
				{
				continue;
				}
			x_buf->nb_tstamp = RealTimeTicks();/* timestamp it */
			rtt_time = con->retry_time;	/* value for timer */
			tcpcntrs->outseg++;
			if (!(con->tc_mustrun & TC_RUN_SEND_ALIVE))
				((TCP_CON_ENTRY *)con->tc_stats)->outsegs++;
			send_packet(con, x_buf, rtt_time);
			}
		}
	else if (con->SendReason < RTT_MAX)
		{
		/********* K Kong Debug
		sprintf(buffer, "##tcp_send_data(Retry) = %d##", p_ptr->nb_len);
		DebugMessage(buffer);
		*********/
		x_buf = (PACKET) con->out_q.mb_mflink; /* send head buffer */
		x_buf->nb_tstamp = 0;			/* clear timestamp */
		if(con->SendReason > sizeof(backoff))
	    		rtt_time = con->retry_time
					* backoff[sizeof(backoff) - 1];
		else
	    		rtt_time = con->retry_time
					* backoff[con->SendReason - 1];
		if (!(con->tc_mustrun & TC_RUN_SEND_ALIVE))
			{
			((TCP_CON_ENTRY *)con->tc_stats)->retran_segs++;
			tcpcntrs->retran_seg++;
			if (tcpalrms->retran_seg_thold_val)
				if (--tcpalrms->retran_seg_thold_val == 0)
					{
					tcpalrms->retran_seg_thold_val =
					   tcpalrms->retran_seg_thold_rst_val;
/*					lme_alarm(TCP_RETRAN_EVENT, tcpcntrs->retran_seg);  */
					}
			}
		  send_packet(con, x_buf, rtt_time);
		}
	else
		return tcp_abort(con);
}
/****************************************************/
send_packet(con, x_buf, rtt_time)
TcpCon	con; 
PACKET	x_buf;		/* current packet pointer */
int	rtt_time;	/* Value for re-xmit timer? */

	{
	struct	tcp	*otp;	/* tcp header pointer (temp) */
	byte	*odp;		/* tcp data pointer (temp) */
	int	hdr_len;	/* Size of packet's TCP header */
	int	sndlen;		/* Internet length to send */
	
	con->SendReason++;

	/* verify that packet is alterable */
	if (x_buf->db_contrl & DBDINXMT)
		{	
		return 0;		/* job not performed! */
		}

	/* put connection's current values into the tcp header */
	otp = (struct tcp *)in_data(in_head(x_buf));
	otp->tc_srcp = con->srcport;		/* init header */
	otp->tc_dstp = con->dstport;
	SeqCopy(&otp->tc_seq, &x_buf->nb_seq);
	SeqCopy(&otp->tc_ack, &con->cur_ack);	/* load current ack */
	otp->tc_win = con->loc_win;
	if (x_buf->nb_furg == 1)
		otp->tc_urg = x_buf->nb_urg;
	tcp_swab_hton(otp);			/* swap the bytes */
	/*
	 *	Copy all the flags such as header length, fin bit,
	 *	push bit, ack valid ... etc.
	 *	This is to speed up the copying of the bit fields.
	 *	This is to assume that the bit fields must be followed 
	 *	by nb->urg.
	 */
	*((ushort *)&otp->tc_win-1) = *((ushort *)&x_buf->nb_urg - 1); 
	if(x_buf->nb_len)
		otp->tc_flags |= PSH_BIT;
	if (con->conn_state != SYNSENT)
		otp->tc_flags |= ACK_BIT;

	/* prepare checksum */
	sndlen = x_buf->nb_len + (x_buf->nb_thl << 2);
	con->ophp.tp_len = htons(sndlen);	/* Fill in TCP hdr */
	*((char *)otp + sndlen) = 0;	/* end packet with a zero */
	otp->tc_cksum =	cksum((byte *)&con->ophp, TCPPH_SIZE >>1);
	otp->tc_cksum = ~cksum((byte *)otp, (sndlen+1) >> 1);
	if (otp->tc_cksum == 0)
		otp->tc_cksum = 0xffff;

	/* transmit */
	in_write(tcpfd, x_buf, sndlen, con->fhost, con->lhost,
	         /*&con->tc_nid, &con->tc_fhop);*/
	         NULL, NULL);
	x_buf->nb_flags |= PKT_SENTOUT;
	StartTimerCall((TIMER *)&con->tcptm, rtt_time, tmhnd, (int )con);
	return 1;
	}

/*****************************************************/
tcp_send_alive(con)
register TcpCon con; 
	{
	PACKET		x_buf;		/* current packet pointer */

	x_buf = (PACKET) con->out_q.mb_mflink; /* send head buffer by default */
	if (x_buf->nb_len == 0)		/* no data: do keep alive */
		{
		x_buf->nb_len = 1;
		con->SendReason = 0;
		x_buf->nb_seq--;
		}
	else
		con->tc_mustrun &= ~TC_RUN_SEND_ALIVE;	/* CLEAR keep alive req. flag */
	}
