/**			       
*
*	Program Name:	nim960 tcp module
*
*	Filename:	rcv.c
*
*	$Log:   /b/gregs/i960/tcpip/tcp/rcv.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:44:04   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:37:10   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:17:52   gregs
 * Initial revision.
 * 
 *    Rev 1.5   23 Nov 1992 11:34:04   forrest
 * Changed two 'printf()s' to 'Errorlog()s'
 * 
 *    Rev 1.4   27 Jul 1992 10:31:54   vinay
 * 
 *    Rev 1.3   01 Jul 1992 14:14:00   kenb
 * Added ()'s to rtt_chk for the timing of retransmissions.
 * Changed offset in post_data to int rather than uint.
 * 
 *    Rev 1.2   17 Jun 1992 13:11:30   vinay
 * Removed the stuff concerned with Errorlog
 * 
 *    Rev 1.1   16 Jun 1992 15:07:50   vinay
 * Changed printf to include Errorlog function
 * 
 *    Rev 1.0   16 Apr 1992 18:30:46   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		8.13.91
*
*	Version:	1.2
*
*	Programmers:	not known
*
*	Modifications:	K Kong	4.19.91
*			Port to the 80960 platform. 
*			i.e.	remove "far", int is 32 bit ...etc.
*			We cannot assign/extract sequence number and
*			the ack number to/from the communictaion buffer
*			(PACKET) as they may not be properly aligned.
*			We have to copy them out two bytes at a time before 
*			we manipulate them.
*
*			K Kong	5.14.91
*			Do not use sizeof() operator to get the the size
*			of tcp header (struct tcp) and tcp pseudo header
*			(struct tcpph) as it will give the size of the
*			structure with padded data. What we really 
*			want is the unpadded size.
*			TCP_SIZE and TCPPH_SIZE are the unpadded size of
*			struct tcp and struct tcpph respectively.
*
*			K Kong	8.13.91
*			tcp_popen() will free the packet on error.
*			This is necessary as tc_clrs is freeing the packet.
*			The caller does not know if tcp_popen has called
*			tc_clrs, hence freeing the packet, or not on error.

*			Ramki  2-13-92
*			Modified tcp_rcv and tcp_popen to accept local host addr
*			Also tcp_rcv will now pass the local host addr to
*			tn_filter_con.
*
*	Comments:	This file contains the function to send tcp
*			segment.
*
*	Comments:	This file contains the function to process
*			incoming tcp segment.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
 * rcv.c - Receive & process packets for Multiple Connection TCP.
 * 
 * Copyright (C) 1986, 1987 by FTP Software, Inc.
 * 
 * Edit History
 * 05-Sep-86	jbvb	ack_data() maintains seq# in packet left in q.
 * 14-Oct-86	jbvb	Buffer upcall before reject code, improve window
 * 			 calculations (prevent wrap).
 * 01-Nov-86	jbvb	Don't update window from obsolete packets
 * 02-Dec-86	jbvb	Wait for xmit queue to unlock before doing anything
 * 			 serious.
 * 05-Dec-86	jbvb	Fixed long-standing bug in buffer squeeze logic
 * 09-Dec-86	jbvb	Don't ack if neither we nor they are sending
 * 22-Dec-86	jbvb	Set retry time from SYN packet, use for close.
 * 23-Dec-86	jbvb	RTT calc. & bounds checking split out into rtt_chk()
 * 28-Dec-86	jbvb	Rearrange, clean up, fix bug in saved packet logic
 * 30-Dec-86	jbvb	Bug fixes, window update heuristic implemented
 * 02-Jan-87	jbvb	More cleanup, help RTT logic deal with RTT > CONNRT,
 * 			 ack immediately if dallying and no new data.
 * 04-Jan-87	jbvb	Change large RTT logic to cope w/probing, fix bug
 * 			 in post_data() turned up by window-opening testing.
 * 05-Jan-87	jbvb	Don't resend on ack rejecting probe of 0-window.
 * 07-Jan-87	jbvb	Use memcpy() to compress buffers in ack_data()
 * 11-Jan-87	jbvb	Use macros from MTCP.H to handle seq. # wrap.
 * 12-Jan-87	jbvb	Port to MSC 4.0, fix bugs in seq. # wrap.
 * 12-Feb-87	jbvb	Minor tweaking in ack_data()
 * 23-Feb-87	jbvb	Added conditionals for resident kernel version, don't
 * 			 ignore duplicate SYN & FIN packets, if 1st pkt
 * 			 re-xmitted, ignore timestamps on all pkts acked.
 * 17-Apr-87	jbvb	Add get_frn_mss() (incoming Max Seg Size option)
 * 15-May-87	jbvb	Fix RTT escalation on lossy links.
 * 24-Jun-87	jbvb	Try waiting for other host's window shrinking to go
 * 			 away, since fixing it completely is excrutiating...
 * 13-Aug-87	jbvb	Be sure to free saved_pkt as soon as it is obsolete.
 * 20-Aug-87	jbvb	Print some errors if PROTERR enabled.
 * 15-Sep-87	jbvb	New TI Exploder TCP/IP not only violates our window,
 *			 it will send a FIN bit while doing so.  post_data()
 *			 now clears the FIN bit if it truncates the data.
 *			Also, make some more esoteric debugging messages
 *			 conditional on DEVEL, to shrink the .EXE files.
 *MOD:BLL tcp_popen: set lcl skt number from incoming pkt 
 */

#include <types.h>
#include <krnl.h>
#include <task.h>
#include <ether.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <mtcp.h>
#include <mtcpblk.h>
#include <tcpip.h>
#include <error.h>
#include "internal.h"



/* This routine is upcalled by internet when a TCP packet arrives.
 * it processes the packet according to the  algorithm in the
 * "TCP functional specification", pp66-77.  Because of the proliferation
 * of 3 terminating cases in many places, and the need to have a compact
 * binaries, goto's are used (much like a structured break) to get to the
 * correct return point, and improve the code.
 *
 * NOTE: This version of FTP Software's tcp has been tested with send
 *	 and receive sequence numbers wrapping across all boundaries.
 */
/*
 * name		tcp_rcv		handle an incoming TCP segment
 *
 * synopsis	tcp_rcv(inpkt, len, fhost,lhost)
 *		PACKET	inpkt; <<	the TCP segment
 *		int	len; <<		length of the TCP segment in 
 *					"inpkt"
 *		in_name	fhost; <<	ip address of the sender of 
 *					this TCP segment
 *		in_name lhost		Ip address of the receiver
 *
 * description	It handles all the incoming TCP segments.  It checks
 *		if the TCP header is ok and then process the data
 *		as described from page 65 to page 77 or rfc 793.
 *
 * returns	nothing
 */

void tcp_rcv(inpkt, len, fhost,lhost)
PACKET	inpkt;		/* the packet itself */
int	len;		/* length of packet */
in_name	fhost;		/* source of packet */
in_name lhost;		/* destination of packet */

	{
	register TcpCon	con;	/* connection receiving a packet */
	register PACKET opkt;	/* output pkt */
	struct tcp	*itp;	/* input  pkt tcp hdr */
	struct tcp	*otp;	/* output pkt tcp hdr for q-head on pkt's conn.*/
	byte	*idp;		/* input pkt data ptr */
	int	idlen;		/* len of input pkt in bytes */
	ushort	tempsum;	/* temp variable for a checksum */
	ulong	inseq;
	ulong	outack;
	ulong	mywin;
	ulong	winend;
	ulong	inend;
	int	reject;
	int	i;
	int	do_free = TRUE;	/* free packets by default */
	ulong	seq_no;	/*	copy the seq number to here	*/
	ulong	ack_no;	/*	copy the ack number to here	*/
	int	synbit,finbit;

	tcpcntrs->inseg++;

	itp = (struct tcp *)in_data(in_head(inpkt));
	synbit = (itp->tc_flags & SYN_BIT) ? 1 : 0;
	finbit = (itp->tc_flags & FIN_BIT) ? 1 : 0;
	i = ((itp->tc_thl & THL_BIT) >> THL_SHIFT) << 2;	/* get the header length */
	if ((i < 20) || (i > len)) 		/*  & check it */
	{
		Errorlog(0, "Length error %x\n", i);
		goto Return;
	}

	idp = (byte *)itp + i;  /* Make data ptr, use header length temp */
	idlen = len - i;	    /* get incoming data length (using temp) */
	if (idlen >= 0) 
		*(idp + idlen)= 0;	/* fill to word boundary w/0 */

	/* compute incoming tcp checksum here... */
	iphp.tp_len = ntohs(len); /* convert to host order	*/
	iphp.tp_dst = in_mymach(fhost,lhost);
	iphp.tp_src = fhost;
	tempsum = itp->tc_cksum;
	itp->tc_cksum = cksum((byte *)&iphp, TCPPH_SIZE >> 1);
	itp->tc_cksum = ~cksum(itp, ((idlen + 1) >> 1) + (i >> 1));
	if(itp->tc_cksum != tempsum)
		if (tempsum != 0xffff || itp->tc_cksum != 0)
		{
			tcpcntrs->chksum++;	
			Errorlog(0, "TCP Checksum Error\n");
			goto Return;
		}
	tcp_swab_ntoh(itp);    /* reverses bytes to host order	*/

	/*
	 *	The seq number and the ack number may not be
	 *	properly aligned in the communication buffer.
	 *	We copy the them out from the communincation buffer
	 *	to manipulate them.
	 */
	SeqCopy(&seq_no, &itp->tc_seq);
	SeqCopy(&ack_no, &itp->tc_ack);


	/* the packet demuxes if its for one of our ports.  Also, */
	/* make sure we expect the packet from whomever sent it. */
	con = tcp_resolve_con(itp->tc_dstp, lhost, itp->tc_srcp, fhost);

	/* This comes straight from the TCP implementation manual */
	/* FIRST DO STATE PROCESSING FOR OPENING CONNECTIONS */
	switch((int)con)
		{
	case 0:		/* for non existent connection */
		/* get resources */
		if ((con = tcp_popen(itp, fhost, lhost, inpkt)) == NULL)
			/*
			 *	K Kong	8.13.91
			 *	tcp_popen would have released the
			 *	packet "inpkt" on error, we can
			 *	return from here.
			 */
			return;
		con->ufield = (void *)tn_filter_con(con, fhost, itp->tc_srcp,
				lhost, itp->tc_dstp);
		if (!con->ufield)
			{
			tcp_clean(con, -1);	/* clean up the TcpCon resource */
			goto Reset;
			}
		goto Return;	/* successful or not, popen did it all */
	case 1:		/* for 1/2 opened connection */
		goto Return;    
	default:	/* for extant connection */
		con->tc_alive = 5;	/* reset keep alive timer */
		break;
		}
	opkt = (PACKET)con->out_q.mb_mflink;
	otp = (struct tcp *)in_data(in_head(opkt));
	
	if (con->conn_state == SYNSENT)
		{
		/* Ack must be for our initial sequence number */
		if (SEQ_NE(ack_no, con->out_q_seqn) || (itp->tc_flags & ACK_BIT) == 0)
			{
			/* if it's a reset for the wrong ack number, drop it.  
			 * When our SYN is resent, hopefully the connection 
			 * will open
			 */
			if (itp->tc_flags & RST_BIT)
				goto Return;
			goto Reset;			/* reset the other guy (cheat)*/
			}
		if (itp->tc_flags & RST_BIT)
			{
			tcp_clean(con, ERR_F_ABORT);
			goto Return;
			}    
		if(!(itp->tc_flags & SYN_BIT)) 
			{    /* There must be a SYN to open */
			/* HERE IS A DEPARTURE FROM TCP SPECIFICATIONS */
			/* this TCP can't handle simultaneous opens, so I reset */
			/* the other TCP.  boo hiss */
			tcp_newdata(con);	/* start from scratch */
			goto Reset;		/* reset the other guy */
			}
	
		/* Connection opened.  Call the user to tell him. */
		con->max_data = get_frn_mss(itp);	/* get any MSS option... */
		((TCP_CON_ENTRY *)con->tc_stats)->maxseg = con->max_data;
		seq_no++;
		SeqCopy(&itp->tc_seq, &seq_no);	/* (for "Sixth" step) */
		con->cur_ack = seq_no;	/* initialize acks */
		con_estab(con, itp, opkt);	/* common stuff, including upcall */
		tcp_sendack(con);		/* send the singular ACK */
		if (idlen > 0)
			goto Sixth;	/* yick. icky part of the spec */
		goto Return;
		}
	
	/* NOW DO 8 TESTS FOR THE REMAINING STATES */
	
	/* FIRST PROCESS A RESET IF PRESENT */
	
	if (itp->tc_flags & RST_BIT)
		{			/* other guy's resetting me */
		if (con->conn_state == SYNRCVD) 
			{	/* as per TCP spec */
			tcp_hush(con);		/* stop transmissions */
			((TCP_CON_ENTRY *)con->tc_stats)->tcp_state = con->conn_state;
			((TCP_CON_ENTRY *)con->tc_stats)->tcp_id.rem_ip_addr = 0L;
			((TCP_CON_ENTRY *)con->tc_stats)->tcp_id.local_tcp_port = 0;
			((TCP_CON_ENTRY *)con->tc_stats)->tcp_id.rem_tcp_port = 0;
			tcp_clean(con, ERR_F_ABORT);
			tcpcntrs->con_fail++;
			goto Return;
			}
		else
			{
			/* reset while we wait for his close is his problem, not ours*/
			if (con->conn_state == SIMUL 
				|| con->conn_state == TIMEWAIT 
				|| con->conn_state == R_AND_S)
				{
				tcp_clean(con, 0);
				goto Return;
				}
			goto Abort;	/* ??? no check for packet in window???? */
			}		/* end else */
		}			/* end "if (itp-tc_rst)" */
	
/* SECOND TEST IF THE PACKET IS OUT OF SEQUENCE */
/* this follows TCP spec closely except for the variable names: */
/* inseq  = seg.seq , outack = rcv.nxt, mywin  = rcv.win */
/*
The following logic is intended to detect packets which can be rejected
as having no significant content.  It detects five general classes of
useless packet, rejected by number as follows:

1:	No text, and sequence number outside window, or ack obsolete.
2:	No text, and our window zero, and sequence number doesn't match.
3.	Text present, but all outside our window (ahead or behind).
4.	Text, but our window is zero.
5.	Ahead of sequence, but within our window - hold if possible.

Rejected packets will usually be answered with an ack (retransmission of
the head packet on out_q), in the hopes that the sender will smarten up.
The ack is ommitted if neither we nor they are sending at the moment.  We
try to dally before sending it hoping to reduce the packet count.  
*/
	inseq  = seq_no;
	outack = con->cur_ack;		/* compute storage window (2)*/
	mywin  = con->loc_win;
	reject = FALSE;
	winend = mywin + outack;
	if ((idlen + finbit) == 0) 
		{	/* text-less packet */
		if (mywin > 0) 
			{
			if (SEQ_LT(inseq, outack) 
				|| SEQ_GE(inseq, winend)
				||  SEQ_LE(ack_no, opkt->nb_seq)) 
				/* obsolete ack & data */
				reject = 1;	/*  not useful - drop it */
			}
		else if (SEQ_NE(inseq, outack)) 
			reject = 2;
		}
	else 
		{	/* packet has a text */
		/* compute byte no of last byte */
		inend = inseq - 1 + (long) idlen + finbit;
		if (SEQ_GT(inend, winend)) /* did he ignore our window? */
			{
			if (mywin <= 0) 
				reject = 4;
			else if (SEQ_LT(inend, outack) 
				|| SEQ_GT(inseq, winend)) 
				reject = 3;	/* all out of window? */
			else if (SEQ_GT(inseq, outack))  /* In window, but ahead? */
				reject = 5;			/* hang onto it, if we can */
			}
		}
	
	/* if there's nothing interesting in this packet, punt it. */
	/* 1: we aren't in TIMEWAIT    (otherwise steps 5,8 want to see it) */
	/* 2: all the text is old.    (otherwise steps 3-8) */
	/* 3: it ACKS nothing.    (otherwise step 5 wants to see it) */
	
	/* drop pkt if we've sent a lot of acks from TIMEWAIT */
	if (con->conn_state == TIMEWAIT) 
		{  
		if (con->tw_to_live++ < TW_PKTS) 
		    tcp_sendack(con);		/* resend that final packet */
		goto Return;
		}
	
	/*
	 * Window calculation & output unblocking logic - don't prod user unless
	 * the useable window is at least half what the foreign host offered.
	 */
	if (SEQ_GE(ack_no, opkt->nb_seq)) 
		{	/* if window info. current */
		con->frn_win = (unsigned) ((unsigned long) itp->tc_win +
		                           ack_no - con->out_q_seqn);
		if (con->frn_win > itp->tc_win)  /* Is foreign window ok? */
			con->frn_win = 0;	/* Wrapped - rationalize the window */
		}
	/* update LME send window field */
	((TCP_CON_ENTRY *)con->tc_stats)->snd_window = con->frn_win;
	if (con->frn_win == 0)  /* should we do window probing? */
		con->tc_alive = 1;	/* but do keep window probe soon */
	
	/*
	 * Sometimes, we should reply to rejected packets by retransmitting whatever
	 * we last sent.  Don't reply to Reset, ever.  Reply if there was data from
	 * the foreign host, or if we're sending, and the foreign host hasn't shrunk
	 * or closed the window.
	 */
	if (reject && SEQ_LE(ack_no, opkt->nb_seq)) 
		{
		if ((!(itp->tc_flags & RST_BIT)) 		/* Don't ack resets */
			&&  ((idlen + synbit+ finbit) 	/* Ack if data, */
			||  (con->frn_win 	/* or window open */
			&&  SEQ_NE(opkt->nb_seq, con->out_q_seqn))))	/* & we're sending */
			{
			tcp_sendack(con);	/*  bring remote up to date */
			}
		if (reject != 5) 
			{
			goto Return;
			}
		else
			{
			goto SavePkt;	/*  or try to save it */
			}
		}
	
	/* THIRD CHECK SECURITY AND PRECEDENCE (unhandled) */
	
	/* FOURTH CHECK the SYN BIT */
	if (synbit) 
		goto Abort;
	
	/* FIFTH PROCESS AN ACK OF OUR DATA IF PRESENT */
	if (!itp->tc_flags & ACK_BIT)
	    goto Return;	/* ack not present (SYN pkt), all done */
	
	/* Ack for unsent data prompts us to reset. */
	if (con->conn_state == SYNRCVD) 
		{
		if (SEQ_EQ(ack_no, con->out_q_seqn))  /* passive open */
			con_estab(con, itp, opkt); /* common stuff, including upcall */
		else 
			{
			goto Abort;
			}
		}
	else if (!ack_data(ack_no, con, opkt))	
		goto SavePkt;			/* Nothing else to do... */
	
Sixth:  /* SIXTH PROCESS URG INFORMATION (unhandled)*/
	
	
	/* SEVENTH PROCESS THE SEGMENT TEXT */
	if (idlen)
		{				/* If there is any text */
		if (post_data(con, inpkt, idlen) > 0) 
			{ /* If ack was bumped */
			do_free = FALSE;		/* data packet - don't free */
			if (con->saved_pkt) 
				{ 	/* Saved packet - try processing it */
				i = post_data(con, con->saved_pkt, con->saved_len);
				if (i < 0)
					/* Packet was all obsolete data, so */
					in_free(con->saved_pkt); /* in this case, free it */
				if (i != 0)
					/* Something happened to the pkt, */
					con->saved_pkt = (PACKET) NULL;		/* gone. */
				}
			}
	
		/* ack pkt if no one else will & it's not final TIMEWAIT packet */
		if (con->conn_state != TIMEWAIT)
			tcp_sendack(con);
		}		/* end if (idlen) */
	
	/* EIGHTH CHECK THE FIN BIT */
	
	/* check saved FIN, not FIN in the packet bacuse the packet
	** may be freed by post_data routine
	***** for HAC
	******/
	if (finbit) 
		{
		switch(con->conn_state) 
			{
		case ESTAB:
		case SYNRCVD:
			tcp_sendack(con);		/* ack his fin */
			con->conn_state = FINRCVD;
			((TCP_CON_ENTRY *)con->tc_stats)->tcp_state = con->conn_state;
			con->cur_ack++;		/* acknowlege his fin */
			tn_up_fclose(con);	/* tell user its closing */
			tcp_send_ack(con);
			break;
	
		case FINSENT:
			tcp_sendack(con);
			if (!((PACKET) con->out_q.mb_mblink)->nb_len) 
				{
				con->cur_ack++;		/* acknowlege his fin */
				tn_up_fclose(con);	/* tell user its closing */
				con->conn_state = SIMUL;
				((TCP_CON_ENTRY *)con->tc_stats)->tcp_state = 
				              con->conn_state;
				break;
				}
			/* if we fall through it's because our FIN is acked and */
			/* we should really be in the FINACKED state anyway */
	
		case FINACKED:
			con->cur_ack++;		/* acknowlege his fin */
			/* tn_up_fclose(con);*/	/* tell user its closing */
			tn_up_close(con, 0);	/* tell user its closed */
			con->conn_state = TIMEWAIT;
			((TCP_CON_ENTRY *)con->tc_stats)->tcp_state = con->conn_state;
			tcp_timewait(con);
			tcp_sendack(con);		/* send the final ACK */
			break;
	
		case TIMEWAIT:		/* TIMEWAIT timer restarted in step 5 */
			break;		/* so there's nothing to do here */
	
		case SIMUL:
		case R_AND_S:
		case FINRCVD:
			tcp_sendack(con);    /* this is equivalent to a resend */
			}
		}
	
	
SavePkt:		/* Free packet unless it should/can be held */
	/***************
	if ((reject == 5) && (!con->saved_pkt) && (C0tdbdcnt)) 
		{
		con->saved_pkt = inpkt;
		con->saved_len = idlen;
		}
	else if (do_free) 
	*************/
	if(do_free)
		in_free(inpkt);
	return;
	
Abort:				/* blasts everything, unnatural death */
	tcp_clean(con, ERR_F_ABORT);
Reset:				/* just resets other host */
	tc_clrs(inpkt, fhost, lhost);
	/* send task sends and frees RST packet...dont free it here */
	return;
Return:				/* Free packet & return to Internet layer */
	if (do_free) 
		in_free(inpkt);
	return;
	}

/*
 * tcp_popen() replies to a connection request on a listen socket.  It
 * doesn't handle data in the first packet, because we haven't any good
 * place to keep it till the conection reaches ESTAB.
 */
TcpCon tcp_popen(itp, fh, lhost, pkt)
struct	 tcp    *itp;	/* incoming SYN packet pointer */
in_name	fh; 		/* foreign host */
in_name lhost;		/* local host */
PACKET	pkt;		/* Incoming packet pointer, in case we abort */
	
	{
	register TcpCon con;
	ulong	seq_no;

	SeqCopy(&seq_no, &itp->tc_seq);

	/* ignore RST, abrt ACK, abrt no SYN */
	if (itp->tc_flags & SYN_BIT)
		tcpcntrs->pass_con++;
	/*
	 *	K Kong	8.13.91
	 *	Let tc_clrs handle reset packet, as
	 *	tc_clrs takes care of freeing the incoming packet
	 */
	 /***********************
	if (itp->tc_flags & RST_BIT)
		{
		tcpcntrs->con_fail++;
		return 0;   
		}
	**************************/
	if (itp->tc_flags & (ACK_BIT | RST_BIT) || !(itp->tc_flags & SYN_BIT))
		{
		tcpcntrs->con_fail++;
		tc_clrs(pkt, fh, lhost);	
		return NULL;
		}
	/* allocate resources for connection */
	con = tcp_listen(fh, itp->tc_srcp, lhost, itp->tc_dstp);
	if (con == NULL)
		{
		/*	K Kong	8.13.91
		 *	Free the packet on error before returning.
		 */
		in_free(pkt);
		return NULL;
		}
	con->max_data	  = get_frn_mss(itp);	/* get any MSS option... */
	con->cur_ack	  = seq_no + 1; /* ACK SYN (must be there) */
	con->frn_win      = itp->tc_win;
	((TCP_CON_ENTRY *)con->tc_stats)->snd_window = con->frn_win;
	((TCP_CON_ENTRY *)con->tc_stats)->maxseg = con->max_data;
	
	/* we don't reduce the resend time here because we must avoid */
	/* replying with too many SYNs, causing the other host to reset us */
	con->tc_mustrun = 0x80;	/* needs to learn addresses */
	tcp_newdata(con);
	return con;
	}

/*
ack_data() - function to DTRT when foreign side acknowleges our data.

I may eventually move this back in-line to tcp_rcv(), but I need the
abstraction for now (development).

Called with the ack'ed sequence number and the connection, it chomps
down the queue of transmit buffers, freeing those completely ack'ed,
and compressing those partly acked.  Returns 0 if nothing more to be
done, otherwise returns 1.

NOTE: This routine always leaves 1 buffer in the output queue.  This
buffer has a length of zero, and FIN and urgent information are cleared
when it has been completely acked.
*/
int ack_data(acked_seq, con, p_ptr)
seq_t	acked_seq;
register TcpCon	con;
register PACKET	p_ptr;	/* outgoing packet */

	{
	char	*odp;
	seq_t	nxt_seq;
	seq_t	last_byte;
	uint	timestamp;
	int	i;
	
	if (SEQ_GT(acked_seq, con->out_q_seqn)) 
		return(FALSE);
	
	timestamp = p_ptr->nb_tstamp;	/* get 1st packet's timestamp */
	for (;;)
		{
		last_byte =  p_ptr->nb_seq + p_ptr->nb_len;
		nxt_seq = last_byte + p_ptr->nb_syn + p_ptr->nb_fin;
		if (SEQ_LE(acked_seq, p_ptr->nb_seq)) /* If no more to do... */
			break;			    /*  get out of loop! */
		if (SEQ_LT(acked_seq, last_byte))
			{	/* if partly acked */
			odp = (char *)in_data(in_head(p_ptr))
				+ TCP_SIZE;
			i = last_byte - acked_seq;	/* bytes left */
			memcpy(odp, odp + (acked_seq - p_ptr->nb_seq), i);
			p_ptr->nb_len = i;		/* new length */
			if (p_ptr->nb_furg) 
				{		/* acked urgent data ? */
				p_ptr->nb_urg -= (acked_seq - p_ptr->nb_seq);
				if((int) p_ptr->nb_urg  <= 0) 
					{
					p_ptr->nb_urg = 0;
					p_ptr->nb_furg = 0;
					}
			    	}
			p_ptr->nb_seq = acked_seq;
			break;
			}
		p_ptr->nb_urg = 0;	/* all data acked, kill urgent info */
		p_ptr->nb_furg = 0;
		p_ptr->nb_len = 0;		/* no data left in current */
		p_ptr->nb_flags &= ~PKT_SENTOUT;/* this packet is clear */
		if (SEQ_LT(acked_seq, nxt_seq))
			{	/* if data acked */
			p_ptr->nb_seq = acked_seq;	/* update sequence */
			break;				/* all done */
			}
		if (!(p_ptr->db_nxtpkt))
			{		/* all ack'ed: if no next, */
			p_ptr->nb_seq = con->out_q_seqn; /* update seq # for acks */
			tcp_hush(con);	/* stop retransmitting new data */
/*
Adaptive re-transmit calculations: If 1st pkt hadn't been re-xmitted, start
with the round trip time for the last buffer acked by this packet, massage
it, and apply smoothing factor of 0.66.  If the packet has been retransmitted,
and the timestamp is no good, we see how many times.  If RTT_RETRY or
more, we double the retransmit timeout anyway (but not beyond TCP_PROBE).
*/
			if (timestamp)	/* 1st pkt had a valid timestamp? */
				con->retry_time = (con->retry_time * 2 
	                		+ rtt_chk(p_ptr->nb_tstamp)) / 3;
			else if (con->SendReason > RTT_RETRY
				&& con->retry_time == CONNRT)
				con->retry_time = 
					min((con->retry_time*2), TCP_PROBE);
	
			if (p_ptr->nb_fin) 
				{		/* has he acked our FIN? */
			        p_ptr->nb_fin = 0;	/* no need to send more FINs*/
				switch(con->conn_state) 
					{
					case FINSENT:
						con->conn_state = FINACKED;
						((TCP_CON_ENTRY *)con->tc_stats)->tcp_state
							= con->conn_state;
						break;
					case SIMUL:
						con->conn_state = TIMEWAIT;
						((TCP_CON_ENTRY *)con->tc_stats)->tcp_state 
						           = con->conn_state;
						tcp_timewait(con);
						break;

					case R_AND_S:
						tcp_clean(con, 0);    /* normal, zap it */
						return(FALSE);
					}
	    			}
	    		break;			/* all done */
	        	}
		in_free((PACKET) dequeue(&con->out_q)); /* dequeue & free pkt */
		p_ptr = (PACKET) con->out_q.mb_mflink; /* new head pointer */
		}
	return(TRUE);
	}

/*
 * rtt_chk() - called to derive & check TCP round-trip times.  Returns
 * the massaged RTT as an integer.
 *
 * Input is the timestamp for a buffer, the difference is doubled, and then
 * peak-limited. High limit is RTT_HI (see MTCPBLK.H), low limit is RTT_LOW,
 * smoothing factor is up to the caller.
 */
uint rtt_chk(time_stamp)
uint	time_stamp;		/* caller's timestamp (assumed > 0) */

	{
	uint	retransmit;
	
	retransmit = 2 * (RealTimeTicks() - time_stamp);	/* start with 2*RTT */
	if (retransmit > RTT_HI)
		retransmit = RTT_HI;	/* peak limit it */
	else if (retransmit < RTT_LOW)
		retransmit = RTT_LOW;	/*  apply low limit too... */
	return (retransmit);
	}

/*
 * post_data() - take a packet and give the useful portion (if any) of
 * its contents to the user's upcall routine.  Bump the ack as required.
 * Returns the number of bytes posted to user.  Conditional compilation
 * provided for the resident kernel, passes packet instead of data ptr.
 */
int post_data(con, p_ptr, len)
register TcpCon	con;
register PACKET	p_ptr;			/* the packet we need to process */
int	len;			/* the TCP data length */

	{
	struct tcp	*itp;	/* temp pointer to TCP header */
	byte	*idp;		/* ditto, for TCP data area */
	int	useful_offset;
	int	useful_len;
	int     urg = 0;	/* no reason to be urgent */
	ulong	seq_no;		/* sequence number in "itp"	*/
	
	itp = (struct tcp *)in_data(in_head(p_ptr));
	SeqCopy(&seq_no, &itp->tc_seq);
	useful_offset = con->cur_ack - seq_no;
	useful_len	= len - useful_offset;
	if(useful_len > (int)con->loc_win)
		{     /* Exceeded our window: */
		useful_len = con->loc_win;  /*  trim the data */
		itp->tc_flags &= ~FIN_BIT;
		}
	if (useful_len > 0) 
		{
		if (useful_offset >= 0)
			{
			idp = (byte *)itp + (((itp->tc_thl & THL_BIT) >> THL_SHIFT)<< 2);
			p_ptr->nb_prot = idp + useful_offset;
			p_ptr->nb_len  = useful_len;
			if (itp->tc_flags & URG_BIT)
				if (idp + itp->tc_urg 
					>= p_ptr->nb_prot)
					urg = 1;
			con->loc_win = tn_up_rcv(con, p_ptr, useful_len, urg);
			con->cur_ack += useful_len;
			return(1);	/* tell caller how much we used */
	    		}
		}
	else if (useful_len < 0)
		{	/* If negative, packet is obsolete */
		return (-1);		/*  & inform caller */
		}
	return(0);		/* Tell caller packet was ahead of seq. */
	}


int current_direction = 1;
	
/*
 * con_estab() - does common processing for conection reaching
 * Established state.  Called when our SYN is acked and we are in
 * either SYNSENT or SYNRCVD state.  Upcalls user's us_open() procedure.
 */
void
con_estab(con, itp, opkt)
register TcpCon	con;
struct	tcp	*itp;
register PACKET opkt;

	{
	con->conn_state	= ESTAB;
	((TCP_CON_ENTRY *)con->tc_stats)->tcp_state = con->conn_state;
	con->frn_win	= itp->tc_win;
	((TCP_CON_ENTRY *)con->tc_stats)->snd_window = con->frn_win;
	opkt->nb_thl	= TCP_SIZE >> 2;  /* Done with MSS opt */
	opkt->nb_syn	= 0;		/* clear the SYN bit */
	opkt->nb_seq++;			/*  & count it */
	if (((PACKET)con->out_q.mb_mflink)->nb_tstamp) /* if timestamp ok */
		con->retry_time =
		    rtt_chk(((PACKET)con->out_q.mb_mflink)->nb_tstamp);
	else				/* otherwise, use default */
		con->retry_time = CONNRT;
	tcp_hush(con);			/* quiet any rexmitting in progress */
	tcpcntrs->current_con++;
	/*	if (tcpalrms->cur_opened_thold_value != 0)
	**		if (current_direction
	**		&&  tcpcntrs->current_con >= tcpalrms->cur_opened_thold_value)
	**			{
	**			if (tcpalrms->cur_opened_del_val != 0)
	**				current_direction = 0;
	**			lme_alarm(TCP_CUR_OPENED_EVENT, (long)tcpcntrs->current_con);
	**			}
	**	if (tcpalrms->event_enable & ESTAB_EVENT_ENABLE)
	**		lme_alarm(TCP_OPENED_EVENT, con->tc_stats);
	*/
	tn_up_open(con);  /* tell User connection is open */
	}
	
/*
 * get_frn_mss() - pick up any Max Seg Size option in the SYN packet,
 * and return it.  Default to DFLT_MSS if not present.
 *
 * NOTE: Logic that checks the MSS against the network maximum *will* fail
 *	 when multiple interfaces are implemented.
 */
int get_frn_mss(itp)
struct	tcp	*itp;

	{
	int	i;
	int	max_seg;
	int	tmp_seg;
	char	*opt_ptr;
	
	max_seg = DFLT_MSS;
	if ((i = (((itp->tc_thl & THL_BIT) >> THL_SHIFT)<< 2)) > TCP_SIZE)
		{	/* options? */
		i -= TCP_SIZE; 	/* count options only */
		opt_ptr = ((char *) itp) + TCP_SIZE;	/* skip... */
		while ((i--) > 0)
			{
			switch (*opt_ptr++)
				{
			case 1:		/* no-op */
				break;
			case 2:		/* max_seg_size!! */
				if ((*opt_ptr++) == 4)
				    	{	/* correct */
					tmp_seg = 0;
					tmp_seg |= (*opt_ptr++) << 8;
					tmp_seg |= (*opt_ptr++) & 0xff;
					if ((tmp_seg > 128) &&
					    (tmp_seg < (_initp->tlenfree - 128)))
						max_seg = tmp_seg;
					i -= 3;		/* count it */
					break;
					}	
					/* fall through on bad length */
			case 0:		/* end-of-option-list */
			default:	/*  or we don't grok it */
				return(max_seg > DFLT_MSS ? DFLT_MSS : max_seg);	/* so bail out */
	    			}
			}
		}
	return (max_seg > DFLT_MSS ? DFLT_MSS : max_seg);
	}
