
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	rcv_pkt.c
 *
 *	$Log:   /b/gregs/i960/tcpip/snmp/rcv_pkt.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:43:34   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:36:50   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:17:04   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:26:44   pvcs
 * Initial revision.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */

/****************************************************************************
 *     Copyright (c) 1988  Epilogue Technology Corporation
 *     All rights reserved.
 *
 *     This is unpublished proprietary source code of Epilogue Technology
 *     Corporation.
 *
 *     The copyright notice above does not evidence any actual or intended
 *     publication of such source code.
 ****************************************************************************/

#include <libfuncs.h>
#include <asn1.h>
#include <localio.h>
#include <buffer.h>
#include <decode.h>
#include <snmp.h>
#include <syteksnm.h>

extern	int	Get_PDU_Common(SNMP_PKT_P , EBUFFER_P , int);

/****************************************************************************
NAME:  Get_PDU_Common

PURPOSE:  Do the common processing for GET REQUEST and GET NEXT REQUEST PDUs.

PARAMETERS:
	SNMP_PKT_T *	The decoded GET/GET NEXT PDU
	EBUFFER_T *	Buffer where the resulting PDU should be placed.
			The memory to hold the PDU will be dynamically
			allocated.
	int		SNMP access privilege.

RETURNS:  int		0 if things went OK and a reasonable packet is
			in the result buffer.  This DOES NOT mean that
			no errors have occurred -- the result buffer might
			contain an error response packet according to the
			SNMP protocol.
			-1 some sort of error has occurred, the result
			buffer should not be considered to hold a valid
			SNMP packet.
****************************************************************************/
int
Get_PDU_Common(pktp, ebuffp, priv)
SNMP_PKT_P	pktp;
EBUFFER_P	ebuffp;
int		priv;
{
	/* Assume that things are going to work */
	pktp->pdu.std_pdu.error_status = NO_ERROR;
	pktp->pdu.std_pdu.error_index = 0;


	if (Process_SNMP_GetClass_PDU((SNMP_PKT_P)pktp,
	    (EBUFFER_P)ebuffp, priv) == -1)
		{
			return -1;
		}

	/* A valid response packet is now in the result e-buffer, although we	*/
	/* don't know here whether the contents were generated using pktp or	*/
	/* new_pkt.								*/

	return 0;
}
