
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	proc_snm.c
 *
 *	$Log:   /b/gregs/i960/tcpip/snmp/proc_snm.c_v  $
 * 
 *    Rev 1.5   16 Nov 1993 10:22:44   vinay
 * fixed snmp authentication for community=public for get and get_nxt
 * 
 *    Rev 1.4   26 Oct 1993 17:01:54   vinay
 * removed printing of udp_send fail 
 * 
 *    Rev 1.3   12 Oct 1993 10:43:32   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:36:48   franks
 * No change.
 * 
 *    Rev 1.1   23 Aug 1993 11:13:20   vinay
 * changed the specific trap to handle the trap #10.
 * 
 *    Rev 1.0   14 Jul 1993 10:17:02   gregs
 * Initial revision.
 * 
 *    Rev 1.3   07 Oct 1992 15:41:38   suresh
 * Removed the lmalloc for the VarBindList when the preallocated is finished
 * Also inclreased the number of VarBinds allocated to 20
 * 
 *    Rev 1.2   15 May 1992 11:40:18   ramki
 * The SnmpInProgress flag was not getting reset if the Manager is not
 * defined. Modified the code to reset it
 * 
 *    Rev 1.1   08 May 1992 13:33:10   ramki
 * Fixed the trap manager problem. The trap packets were getting send to wrong
 * hosts sometimes. This was because the local variables mgr1 amd mgr2 were
 * not cleared.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */

/******************************************************
**
**         (c) Copyrights SYTEK Inc. 1989
**
**         This file contains modules for SNMP stuff
**
*******************************************************/

#include <types.h>  
#include <krnl.h>
#include <dbd.h>
#include <tcpip.h>
#include <libfuncs.h>
#include <buffer.h>
#include <decode.h>
#include <localio.h>
#include <asn1.h>
#include <snmp.h>
#include <mib.h>
#include <buildpkt.h>
#include <syteksnm.h>
#include <telnet.h>

POINTER pstart;
POINTER pend;
POINTER pnext;
VB_P pVarBin;
SNMP_PKT_P dsnmp;

SNMP_PKT_P rcv_snmp_pkt;
SNMP_PKT_P trap_snmp_pkt;
SNMP_GP_P snmp_count;
POINTER tx_rebuffp;
POINTER trap_rebuffp;

POINTER pdu_typep;
POINTER err_statusp;
POINTER err_indxp;

/* This flag is used to make sure that at any time only one SNMP Request */
/* is handled by the SNMP software. Otherwise all the buffers will get */
/* mixed up and can result in a crash. */
int	snmpInProgress;
byte sys_flag = 0;
extern	tcpip *_initp;

int init_snmp()
{
	register POINTER ptr;

	ptr = (POINTER)lmalloc((long) (sizeof(SNMP_PKT_T)*2));
	rcv_snmp_pkt = (SNMP_PKT_P)ptr;

	ptr += sizeof(SNMP_PKT_T);

	trap_snmp_pkt = (SNMP_PKT_P)ptr;
	trap_snmp_pkt->community.start_bp = trap_snmp_pkt->community.next_bp = NULL;

	rcv_snmp_pkt->pdu.std_pdu.std_vbl.vblist=NULL;
	trap_snmp_pkt->pdu.std_pdu.std_vbl.vblist=NULL;

	if((trap_rebuffp = (POINTER)lmalloc((long) SNMP_MAX_PACKET_SIZE)) == NULL)
		return -1;

	if(init_mem_alloc() == 0)
		return -1;
	if(init_VarBin_list(VBCOUNT) == -1)
		return -1;
	if((snmp_count=(SNMP_GP_P)lmalloc((long) sizeof(SNMPGROUP))) == NULL)
		return -1;
	memset((char  *)snmp_count,0,sizeof(SNMPGROUP));

/*
	snmp_product_id[8] = find_pr_code();
*/

	/*  send system boot up alarm to my manager */
	startup_alarm();
	return 0;

}

/*******************************************************************
**
**  PROCESS SNMP PACKET ROUTINE
**
*******************************************************************/
proc_snmp_pkt(src_ip,sport,dport,snmp_pdu,len,dhost)
UINT_32_T src_ip;
UINT_32_T dhost;
UINT_16_T sport,dport;
POINTER snmp_pdu;
INT_16_T len;
{
	register x,y;
	register  acc_type;
	EBUFFER_T  buffp;
	int privilege;
	char  *pp;

	tx_rebuffp =  snmp_pdu;
	privilege = 0;
	snmp_count->inpktcount++;
	if(snmpInProgress)
		return;	/*The SNMP software handles only one request at a time*/
	snmpInProgress = 1;

	/* initialize decode and encode buffer */
	init_mem();

	/* return all VarBind to free VarBin Pool */
	acc_type = snmp_access();

	/* first decode the packet */
	dsnmp = SNMP_Decode_Packet((POINTER)snmp_pdu,len,src_ip,sport,dport,dhost);
	if(dsnmp == NULL)
	{
		/* error happened in decoding, discard the packet */
		snmp_count->badparse++;
		snmpInProgress = 0;
		return;
	}
	switch(dsnmp->pdu_type)
	{
	case GET_REQUEST_PDU:
	case GET_NEXT_REQUEST_PDU:
		snmp_count->outgetresp++;
		if((privilege = check_access_control(acc_type,src_ip,sport,dport,
		    snmp_pdu,len,dhost)) == -1)

		{
			Free_All_VarBin();
			snmpInProgress = 0;
			return;
		}
		if(Get_PDU_Common((SNMP_PKT_P)dsnmp,(EBUFFER_P )&buffp, privilege) != -1)
		{
			if(udp_send(src_ip,sport,dport,buffp.start_bp,
			    		(buffp.next_bp-buffp.start_bp),dhost))
				;
/*
				printf("udp_send fail\n");
*/
		}
		snmp_count->outpktcount++;
		Free_All_VarBin();
		snmpInProgress = 0;
		return;

	case SET_REQUEST_PDU:
		snmp_count->insetreq++;
		snmp_count->outgetresp++;
		if((privilege = check_access_control(acc_type,src_ip,sport,dport,
		    		snmp_pdu,len,dhost)) == -1)
			set_err_resp(GEN_ERR,0);
		else
		{
			if (Process_SNMP_Set_PDU((SNMP_PKT_P)dsnmp,(EBUFFER_P )&buffp,
			    privilege) == 0)
				/* set no error resp */
				set_err_resp(0,0);
		}
		udp_send(src_ip,sport,dport,snmp_pdu,len,dhost);
		snmp_count->outpktcount++;
		Free_All_VarBin();
		
		/* If IP address is changed */
		if(sys_flag == 1)
			SetNewIP();
		/* If Server reset call the service function */
		else if(sys_flag == 2)
			HandleReset(src_ip);	
		sys_flag = 0;
		snmpInProgress = 0;
		return;

	default:
		snmp_count->badtype++;
		snmpInProgress = 0;
		return;
	}
	udp_send(src_ip,sport,dport,buffp.start_bp,(buffp.next_bp-buffp.start_bp,dhost));
	snmpInProgress = 0;
}

/*****************************************************
**
**    check_access_control
**
****************************************************/
int check_access_control(acc_type,src_ip,sport,dport,snmp_pdu,len,dhost)
int acc_type;
UINT_32_T src_ip;
UINT_32_T dhost;
UINT_16_T sport,dport;
POINTER snmp_pdu;
INT_16_T len;
{
	char comm_buf[CSIZE];
	int privilege = -1;

	switch(acc_type)
	{
	case SNMP_ACC_COMMUNITY:
		memset(comm_buf,0,CSIZE);
		memcpy((char  *)comm_buf,(OCTET_P)dsnmp->community.start_bp,
		    (CSIZE-dsnmp->community.remaining));

		if ((privilege = verify_community((OCTET_P)comm_buf)) == -1 )
		{	
			/* 
			*	invalid community string, check if it is
			*	a get_request or get_nxt and community is 
			*	public.
			 */
			if(dsnmp->pdu_type == GET_REQUEST_PDU || 
				dsnmp->pdu_type == GET_NEXT_REQUEST_PDU)
			{
				if(strcmp("public",(char *)comm_buf) == 0)
					return 0;
			}
			snmp_count->badcommname++;
			/* #### SEND ALARM AUTH_FAIL ###  */
			snmpInProgress = 0; 	/* Reset the flag. It will be set */
				    		/* again by generic_trap */
			generic_trap(AUTH_FAILURE);
			return -1;
		}
		break;

	case SNMP_ACC_NONE:
		privilege = 0xf;		/* give highest privilege */
	}
	return privilege;
}

/******************************************************
**
**     init_mem_alloc()
**
*****************************************************/
init_mem_alloc()
{
	if(( pstart = (POINTER)lmalloc((long) BUFFER_POOL_SIZE)) ==
	    (POINTER ) 0)
		return 0;
	pend = pstart + BUFFER_POOL_SIZE;
	return 1;
}

/******************************************************************
**
**   Free_All_VarBin
**
*****************************************************************/
Free_All_VarBin()
{
	Free_VarBin_list(rcv_snmp_pkt->pdu.std_pdu.std_vbl.vblist);
	rcv_snmp_pkt->pdu.std_pdu.std_vbl.vblist=NULL;

}

/********************************************************************
**
**   ALLOC_MEM  ROUTINE 
**  
**   allocate 1 buffer from the buffer pool
********************************************************************/
POINTER alloc_mem(size)
word size;
{
	register POINTER x;

	size = (size + 3) & (~3);
	x=pnext;
	pnext += size;
	if(pnext > pend)
		return 0;
	else
		return x;
}

/********************************************************************
**
**   int_mem  ROUTINE 
**  
**   
********************************************************************/
init_mem()
{
	pnext = pstart;
	memset((char  *)pstart,0,BUFFER_POOL_SIZE);
}

/************************************************************
**
**    init_VarBind_list
**
*************************************************************/
init_VarBin_list(count)
int count;
{

	register i=0;
	register VB_P now,next;

	if((pVarBin = (VB_P)lmalloc((long)(sizeof(VB_T)*count))) == NULL)
		return -1;
	now = pVarBin;
	next = now;
	for(i=0;i<count-1;i++)
	{
		next++;
		now->next = next;
		now=next;
	}
	now->next = NULL;
}

/*************************************************************
**
**    Get_VarBin()
**
**************************************************************/
VB_P Get_VarBin()
{
	register VB_P next;
	register VB_P var;

	if(pVarBin != NULL)
	{
		next = pVarBin->next;
		var = pVarBin;
		pVarBin = next;
		var->next = NULL;
	}
	else
		var = NULL;
	return var;
}

/***********************************************************
**
**    Free_VarBin(var)
**
************************************************************/
Free_VarBin(var)
VB_P var;
{
	register VB_P next;

	/* put in front of pool */
	next = pVarBin;
	pVarBin = var;
	pVarBin->next = next;
}

/**********************************************************
**
**    Free_VarBin_list(var);
**
***********************************************************/
Free_VarBin_list(var)
VB_P var;
{
	register VB_P next;
	register VB_P rel;

	if(var == (VB_P)0)
		return;
	next = var;
	while(next != (VB_P)0)
	{
		rel = next;
		next = next->next;
		Free_VarBin(rel);
	}
}

/****************************************************************
**
**    ALARM_UPCALL  ROUTINE
**
**    input: 
**          trap_type - either GENERIC_TRAP or SPECIFIC_TRAP
** 			trap_id - the specific reason for this trap
**			len  - the length of alarm message ( if any )
** 			value - point to the alarm message.
*****************************************************************/
generic_trap(trap_id)
unsigned int trap_id;
{
	in_name	mgr1 = 0,mgr2 = 0;

	if(snmpInProgress)
		return;
	GetSnmpMgr(&mgr1,&mgr2,GENERIC_TRAP,trap_id);
	if(mgr1 == 0 && mgr2 == 0)
		return;
	snmpInProgress = 1;
	init_mem();
	build_SNMP_Common(GENERIC_TRAP,trap_id);
	send_trap(mgr1,mgr2);
	snmpInProgress = 0;
}

/***********************************************************
**
***    build_SNMP_Common
**
**********************************************************/
build_SNMP_Common(trap_type,trap_id)
int trap_type;
int trap_id;
{

	/* prepare the packet */
	trap_snmp_pkt->pdu.trap_pdu.trap_vbl.vbl_count=0;
	trap_snmp_pkt->pdu_type = TRAP_PDU;
	trap_snmp_pkt->snmp_version = VERSION_RFC1067;
	if (build_object_id(snmp_product_id_count,
	    (unsigned int  *)snmp_product_id,
	    (OBJ_ID_T  *)&(trap_snmp_pkt->pdu.trap_pdu.enterprise_objid)) == -1)
		return ;
	memcpy((POINTER)trap_snmp_pkt->pdu.trap_pdu.net_address,
	    (POINTER)&_initp->in_me,4);
	if ( trap_type == GENERIC_TRAP )
	{
		trap_snmp_pkt->pdu.trap_pdu.generic_trap = trap_id;
		trap_snmp_pkt->pdu.trap_pdu.specific_trap = 0;
	}
	else
		if ( trap_type == SPECIFIC_TRAP )
		{
			trap_snmp_pkt->pdu.trap_pdu.specific_trap = trap_id;
			trap_snmp_pkt->pdu.trap_pdu.generic_trap = ENTERPRISE_SPECIFIC;

		}
	trap_snmp_pkt->pdu.trap_pdu.trap_time_ticks = RealTimeTicks();
}

/**************************************************************
**     send_trap()
**
*************************************************************/
send_trap(mgr1,mgr2)
in_name	mgr1,mgr2;
{
	EBUFFER_T ebuffp;
	register len,stat;

	if(SNMP_Encode_Packet((SNMP_PKT_P)trap_snmp_pkt,(EBUFFER_P)&ebuffp) == -1)
	{
		return;
	}
	len =ebuffp.next_bp-ebuffp.start_bp;
	if(mgr1)
		stat=udp_send(mgr1,SNMP_TRAP_PORT,
		    SNMP_REQUEST_PORT,(OCTET_P)ebuffp.start_bp,
		    len,_initp->in_me);
	if(mgr2)
		udp_send(mgr2,SNMP_TRAP_PORT,
		    SNMP_REQUEST_PORT,(OCTET_P)ebuffp.start_bp,
		    len,_initp->in_me);
	Free_VarBin_list(trap_snmp_pkt->pdu.trap_pdu.trap_vbl.vblist);
	trap_snmp_pkt->pdu.trap_pdu.trap_vbl.vblist=NULL;
}

/****************************************************************
**
**   specific_trap(trap_id)
**
******************************************************************/
specific_trap(int trap_id, int protocol, byte *remoteAddr, int localPort,
		int remotePort, int inOctets, int outOctets, int closeCause,
		uint oldhubid, uint oldslotid, uint hubid, uint slotid)
{
	in_name	mgr1 = 0,mgr2 = 0;
	register  word    *objp;
	register  VBL_P   vblp;
	register  VB_P	  vbp;
	int num_obj,i,maxobj;
	int	size;

	if(snmpInProgress)
		return;
	GetSnmpMgr(&mgr1,&mgr2,SPECIFIC_TRAP,trap_id);
	if(mgr1 == 0 && mgr2 == 0)
		return;
	snmpInProgress = 1;
	init_mem();
	build_SNMP_Common(SPECIFIC_TRAP,trap_id);
	vblp = (VBL_P )&trap_snmp_pkt->pdu.trap_pdu.trap_vbl;

	if(trap_id > 6 && trap_id != 10)
		maxobj = 7;
	else
		maxobj = 4;
	for(i=0;i<maxobj;i++)
	{
		if((vbp = Get_VarBin()) == NULL)
		{
			Free_VarBin_list(vblp->vblist);
			vblp->vblist=NULL;
			snmpInProgress = 0;
			return;
		}
		if (build_object_id(snmp_product_id_count,
		    (unsigned int  *)snmp_product_id,
		    (OBJ_ID_T  *)&vbp->vb_obj_id) == -1)
		{
			Free_VarBin_list(vblp->vblist);
			vblp->vblist=NULL;
			snmpInProgress = 0;
			return ;
		}
		objp = vbp->vb_obj_id.component_list + (snmp_product_id_count-2);
		*objp++ = HLSTRAP;
		if(i== 0)
		{
			vblp->vblist = vbp;
			vblp->vblast= vbp;
		}
		else
		{
			vblp->vblast->next = vbp;
			vblp->vblast = vbp;
		}
		vbp->vb_obj_id.num_components++;
		*objp = i+1;
		if(trap_id != 10)
		{
			switch(i)
			{
			case 0:
				vbp->value_u.v_number = protocol;
				vbp->vb_data_flags_n_type = VT_NUMBER;
				break;

			case 1:
				if(protocol == PS_LAT)
					size = 6;
				else if(protocol == PS_V2)
					size = 2;
				else
					size = 4;
				EBufferPreLoad((EBUFFER_P)&(vbp->value_u.v_string),
				    (OCTET_P)remoteAddr, size,size);
				vbp->vb_data_flags_n_type = VT_STRING;
				break;

			case 2:
				vbp->value_u.v_number = localPort;
				vbp->vb_data_flags_n_type = VT_NUMBER;
				break;

			case 3:
				vbp->value_u.v_number = remotePort;
				vbp->vb_data_flags_n_type = VT_NUMBER;
				break;

			case 4:
				vbp->value_u.v_number = inOctets;
				vbp->vb_data_flags_n_type = VT_NUMBER;
				break;

			case 5:
				vbp->value_u.v_number = outOctets;
				vbp->vb_data_flags_n_type = VT_NUMBER;
				break;

			case 6:
				vbp->value_u.v_number = closeCause;
				vbp->vb_data_flags_n_type = VT_NUMBER;
				break;
			}
		}
		else
		{
			switch(i)
			{
			case 0:
				vbp->value_u.v_number = oldhubid;
				vbp->vb_data_flags_n_type = VT_NUMBER;
				break;

			case 1:
				vbp->value_u.v_number = oldslotid;
				vbp->vb_data_flags_n_type = VT_NUMBER;
				break;

			case 2:
				vbp->value_u.v_number = hubid;
				vbp->vb_data_flags_n_type = VT_NUMBER;
				break;

			case 3:
				vbp->value_u.v_number = slotid;
				vbp->vb_data_flags_n_type = VT_NUMBER;
				break;

			}
		}
	}
	vblp->vbl_count = maxobj;
	send_trap(mgr1,mgr2);
	snmpInProgress = 0;
}

/*
 *	Clear the snmp counters
 */
SnmpClearCounters()
	{
	memset(snmp_count, '\0', sizeof(SNMPGROUP));
	}
