
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	udptable.c
 *
 *	$Log:   /b/gregs/i960/tcpip/mib2/udptable.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:41:30   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:42:02   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:15:04   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:24:50   pvcs
 * Initial revision.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */

/******************************************************
**
**         (c) Copyrights SYTEK Inc. 1989
**
**  This file contains modules for SNMP UDP TABLE
**  
**          Created on 4-3-89
*******************************************************/


#include <types.h> 
#include <krnl.h>
#include <dbd.h>
#include <tcpip.h>
#include <netbuf.h>
#include <ip.h>
#include <udp.h>
#include <asn1.h>
#include <snmp.h>
#include <mib.h>
#include <syteksnm.h>
#include <sockets.h>

extern tcpip initp;


/****************************************************************
**    SVC_INDATAGRAMS ROUTINE    ( UDP - 1 )
*****************************************************************/
int
svc_udpInDatagrams(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = udp_indgrams;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}


/****************************************************************
**    SVC_UDPNOPORTS ROUTINE   ( UDP - 2 )
*****************************************************************/
int
svc_udpNoPorts(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = udp_noport;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}


/****************************************************************
**    SVC_UDPINERRS ROUTINE     ( UDP - 3 )
*****************************************************************/
int
svc_udpInErrors(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = udp_inerror;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}


/****************************************************************
**    SVC_OUTDATAGRAMS ROUTINE      ( UDP - 4 )
*****************************************************************/
int
svc_udpOutDatagrams(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service) {
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code);

	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = udp_outdgrams;
		else 
			return NO_SUCH_NAME;
		break;

	}
	return 0;
}

/****************************************************************
**    SVC_UDPLOCALADDRESS ROUTINE      ( UDPENTRY - 1 )
*****************************************************************/
int
svc_udpLocalAddress(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int rtn_code;

	rtn_code = chk_udpinst(compc,compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_udpnxtinst(compc,compl);

	case SNMP_GET:
		if(rtn_code == 0)
			*value = _initp->in_me;
		else 
			return rtn_code;
		break;

	}
	return 0;
}

chk_udpinst(compc,cp)
byte  *compc;
unsigned int  *cp;
{
	AIP     local_ip;
	word   local_port;
	int		i;

	if ( *compc != 5 )
		return NO_SUCH_NAME;
	for ( i=0; i<4; i++,cp++ )
		local_ip.ip[i] = *cp;
	local_port = *cp;
	if(local_ip.ip_adr == _initp->in_me &&
/** K Kong 2.24.92  (local_port == SNMP_PORT || local_port == ADMIN_PORT))***/
	    (local_port == SNMP_PORT))
		return(0);
	return NO_SUCH_NAME;
}

get_udpnxtinst(compc,compl)
byte  *compc;
unsigned int  *compl;
{
	AIP ipp;
	int j;
	unsigned int  *cp;

	if(*compc == 0)
	{
		ipp.ip_adr = _initp->in_me;
		for(j=0; j<4; j++, compl++)
			*compl = ipp.ip[j];
		*compl = SNMP_PORT;
		*compc = 5;
		return 0;
	}
/***** 2.24.92	K Kong
	else if(chk_udpinst(compc,compl) == 0)
	{
		cp = compl + 4;
		if(*cp == SNMP_PORT)
		{
			*cp = ADMIN_PORT;
			*compc = 5;
			return 0;
		}
	}
******/
	*compc = 0;
	*compl = 0;
	return NO_SUCH_NAME;
}

/****************************************************************
**    SVC_UDPLOCALPORT ROUTINE      ( UDPENTRY - 2 )
*****************************************************************/
int
svc_udpLocalPort(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int rtn_code;
	unsigned int  *cp;

	rtn_code = chk_udpinst(compc,compl);
	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_udpnxtinst(compc,compl);

	case SNMP_GET:
		if(rtn_code == 0)
		{
			cp = compl + 4;
			if(*cp == SNMP_PORT)
				*value = SNMP_PORT;
			/*** K Kong 2.24.92
			else
				*value = ADMIN_PORT;
			**********/
		}
		else 
			return rtn_code;
		break;

	}
	return 0;
}

