
/*
 *	Program Name:	SNMP Program
 *
 *	Filename:	snmptable.c
 *
 *	$Log:   /b/gregs/i960/tcpip/mib2/snmptable.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:41:24   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:41:56   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:15:00   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:24:46   pvcs
 * Initial revision.
 *
 *	Comments:	Initial version for the 960 platform
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */

#include <types.h> 
#include <krnl.h>
#include <asn1.h>
#include <snmp.h>
#include <mib.h>
#include <syteksnm.h>
#include <netbuf.h>

/****************************************************************
**     SVC_SNMPINPKTS ROUTINE  ( SNMP - 1 )
*****************************************************************/
int
svc_snmpInPkts(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,0));
}

/****************************************************************
**     SVC_SNMPOUTPKTS ROUTINE  ( SNMP - 2 )
*****************************************************************/
int
svc_snmpOutPkts(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,1));
}

/****************************************************************
**     SVC_SNMPINBADVERSIONS ROUTINE  ( SNMP - 3 )
*****************************************************************/
int
svc_snmpInBadVersions(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,2));
}

/****************************************************************
**     SVC_SNMPINBADCOMMUNITYNAMES ROUTINE  ( SNMP - 4 )
*****************************************************************/
int
svc_snmpInBadCommunityNames(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,3));
}

/****************************************************************
**     SVC_SNMPINBADCOMMUNITYUSES ROUTINE  ( SNMP - 5 )
*****************************************************************/
int
svc_snmpInBadCommunityUses(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,4));
}

/****************************************************************
**     SVC_SNMPINASMPARSEERRS ROUTINE  ( SNMP - 6 )
*****************************************************************/
int
svc_snmpInASNParseErrs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,5));
}

/****************************************************************
**     SVC_SNMPINBADTYPES ROUTINE  ( SNMP - 7 )
*****************************************************************/
int
svc_snmpInBadTypes(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,6));
}

/****************************************************************
**     SVC_SNMPINTOOBIGS ROUTINE  ( SNMP - 8 )
*****************************************************************/
int
svc_snmpInTooBigs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpnosupport(service,compc,compl,lenp,value,0));
}

/****************************************************************
**     SVC_SNMPINNOSUCHNAMES ROUTINE  ( SNMP - 9 )
*****************************************************************/
int
svc_snmpInNoSuchNames(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpnosupport(service,compc,compl,lenp,value,0));
}

/****************************************************************
**     SVC_SNMPINBADVALUES ROUTINE  ( SNMP - 10 )
*****************************************************************/
int
svc_snmpInBadValues(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpnosupport(service,compc,compl,lenp,value,0));
}

/****************************************************************
**     SVC_SNMPINREADONLYS ROUTINE  ( SNMP - 11 )
*****************************************************************/
int
svc_snmpInReadOnlys(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpnosupport(service,compc,compl,lenp,value,0));
}

/****************************************************************
**     SVC_SNMPINGENERRS ROUTINE  ( SNMP - 12 )
*****************************************************************/
int
svc_snmpInGenErrs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpnosupport(service,compc,compl,lenp,value,0));
}

/****************************************************************
**     SVC_SNMPINTOTALREQVARS ROUTINE  ( SNMP - 13 )
*****************************************************************/
int
svc_snmpInTotalReqVars(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,7));
}

/****************************************************************
**     SVC_SNMPINTOTALSETVARS ROUTINE  ( SNMP - 14 )
*****************************************************************/
int
svc_snmpInTotalSetVars(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,8));
}

/****************************************************************
**     SVC_SNMPINGETREQUESTS ROUTINE  ( SNMP - 15 )
*****************************************************************/
int
svc_snmpInGetRequests(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,9));
}

/****************************************************************
**     SVC_SNMPINGETNEXTS ROUTINE  ( SNMP - 16 )
*****************************************************************/
int
svc_snmpInGetNexts(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,10));
}

/****************************************************************
**     SVC_SNMPINSETREQUESTS ROUTINE  ( SNMP - 17 )
*****************************************************************/
int
svc_snmpInSetRequests(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,11));
}

/****************************************************************
**     SVC_SNMPINGETRESPONSES ROUTINE  ( SNMP - 18 )
*****************************************************************/
int
svc_snmpInGetResponses(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpnosupport(service,compc,compl,lenp,value,0));
}

/****************************************************************
**     SVC_SNMPINTRAPS ROUTINE  ( SNMP - 19 )
*****************************************************************/
int
svc_snmpInTraps(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpnosupport(service,compc,compl,lenp,value,0));
}

/****************************************************************
**     SVC_SNMPOUTTOOBIGS ROUTINE  ( SNMP - 20 )
*****************************************************************/
int
svc_snmpOutTooBigs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,12));
}

/****************************************************************
**     SVC_SNMPOUTNOSUCHNAMES ROUTINE  ( SNMP - 21 )
*****************************************************************/
int
svc_snmpOutNoSuchNames(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,13));
}

/****************************************************************
**     SVC_SNMPOUTBADVALUES ROUTINE  ( SNMP - 22 )
*****************************************************************/
int
svc_snmpOutBadValues(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,14));
}

/****************************************************************
**     SVC_SNMPOUTREADONLYS ROUTINE  ( SNMP - 23 )
*****************************************************************/
int
svc_snmpOutReadOnlys(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,15));
}

/****************************************************************
**     SVC_SNMPOUTGENERRS ROUTINE  ( SNMP - 24 )
*****************************************************************/
int
svc_snmpOutGenErrs(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,16));
}

/****************************************************************
**     SVC_SNMPOUTGETREQUESTS ROUTINE  ( SNMP - 25 )
*****************************************************************/
int
svc_snmpOutGetRequests(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpnosupport(service,compc,compl,lenp,value,0));
}

/****************************************************************
**     SVC_SNMPOUTGETNEXTS ROUTINE  ( SNMP - 26 )
*****************************************************************/
int
svc_snmpOutGetNexts(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpnosupport(service,compc,compl,lenp,value,0));
}

/****************************************************************
**     SVC_SNMPOUTSETREQUESTS ROUTINE  ( SNMP - 27 )
*****************************************************************/
int
svc_snmpOutSetRequests(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpnosupport(service,compc,compl,lenp,value,0));
}

/****************************************************************
**     SVC_SNMPOUTGETRESPONSES ROUTINE  ( SNMP - 28 )
*****************************************************************/
int
svc_snmpOutGetResponses(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,17));
}

/****************************************************************
**     SVC_SNMPOUTTRAPS ROUTINE  ( SNMP - 29 )
*****************************************************************/
int
svc_snmpOutTraps(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	return(svc_snmpcommon(service,compc,compl,lenp,value,18));
}

/****************************************************************
**     SVC_SNMPENABLEAUTHTRAPS ROUTINE  ( SNMP - 30 )
*****************************************************************/
int
svc_snmpEnableAuthenTraps(service, compc, compl, lenp, value, priv)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int priv;
{
	int rtn_code,flag;

	rtn_code = chk_index(*compc,*compl);
	switch(service)
	{
	case SNMP_GET:
		if ( rtn_code == 0 )
			flag = gs_snmpauthtrap(0,0);
		else 
			return NO_SUCH_NAME;
		break;

	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code)) == 0 )
		{
			flag = gs_snmpauthtrap(0,0);
			*value = (UINT_32_T)(flag == 0 ? 2 : 1);
		}
		else
			return rtn_code;
		break;

	case SNMP_SET:
		flag = gs_snmpauthtrap(*value,1);
		break;

	case SNMP_TEST:
		if(rtn_code == 0)
		{
			if(*value == 1 || *value == 2)
				return(0);
			else
				return BAD_VALUE;
		}
		else
			return(rtn_code);

	}
	return 0;
}

/****************************************************************
**     SVC_SNMPCOMMOM ROUTINE
*****************************************************************/
svc_snmpcommon(service, compc, compl, lenp, value, index)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int index;
{
	int rtn_code;
	long  *lp = (long *)snmp_count;

	rtn_code = chk_index(*compc,*compl);
	switch(service)
	{
	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = (UINT_32_T)lp[index];
		else 
			return NO_SUCH_NAME;
		break;

	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code)) == 0 )
			*value = (UINT_32_T)lp[index];
		else
			return rtn_code;
		break;

	}
	return 0;
}

/****************************************************************
**     SVC_SNMPNOSUPPORT ROUTINE
*****************************************************************/
svc_snmpnosupport(service, compc, compl, lenp, value, index)
unsigned int	service;
byte  *compc;
unsigned int *compl;
int  *lenp;
UINT_32_T  *value;
int index;
{
	int rtn_code;

	rtn_code = chk_index(*compc,*compl);
	switch(service)
	{
	case SNMP_GET:
		if ( rtn_code == 0 )
			*value = (UINT_32_T)0;
		else 
			return NO_SUCH_NAME;
		break;

	case SNMP_GETNXT:
		if ( (rtn_code = get_nxtidx((int  *)compc, 
		    (unsigned int  *)compl,rtn_code)) == 0 )
			*value = (UINT_32_T)0;
		else
			return rtn_code;
		break;

	}
	return 0;
}
