/**			       
*
*	Program Name: 	Internet Packet Buffer Allocation	 
*
*	Filename:	in_alloc.c
*
*	$Log:   /b/gregs/i960/tcpip/ip/in_alloc.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:40:24   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:29:50   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:12:02   gregs
 * Initial revision.
 * 
 *    Rev 1.3   16 Jun 1992 14:53:10   vinay
 * No change.
 * 
 *    Rev 1.2   13 May 1992 10:14:54   pvcs
 * 
 *    Rev 1.1   17 Apr 1992 14:54:20   kwok
 * commenting out the debugging message.
 * 
 *    Rev 1.0   16 Apr 1992 18:22:44   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		2.8.91
*
*	Version:	1.0
*
*	Programmers:	
*
*	Modifications:
*
*	Comments:	Port to i960 platform.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/* Copyright 1986 FTP Software, Inc. */

/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */

#include <types.h>
#include <krnl.h>
#include <dbd.h>
#include <ether.h>
#include <netbuf.h>
#include <tcpip.h>
#include <ip.h>
#include "internal.h"

extern MBOX FreeMbox;

/* Allocate and internet packet. Has to grunge around with local net header
	sizes to do the right thing.
*/

PACKET in_alloc(datalen, optlen)
int	optlen;
int	datalen;

	{
	register PACKET p;
	struct ip	*pip;
	int	len;

	optlen = (optlen + 3) & ~3;
	len = (MAXLNH + IPHSIZ + optlen + datalen + 1) & ~1;

	if (len > _initp->tlenfree)
		return NULL;
	if ((p = (PACKET)getfree()) == NULL)
	{
	/*	printf("No Buffers. Count %d\n",FreeMbox.mb_count);*/
		return NULL;
	}

	p->nb_len = 0;
	p->nb_prot = p->db_buffer + MAXLNH;	/* Generalized packet */
	p->nb_flags = PKT_IEEEHDR;
	PutIpHeaderLength(in_head(p), IP_IHL + (optlen >> 2));
	return p;
	}


/* Free up an internet packet */
in_free(buffer)
PACKET buffer; 
	{
	putfree((DBD *)buffer);
	}
