/**			       
*
*	Program Name:	FTP to NIM 960 Channel Driver 
*
*	Filename:	et_rcv.c
*
*	$Log:   /b/gregs/i960/tcpip/drv/et_rcv.c_v  $
 * 
 *    Rev 1.3   12 Oct 1993 10:39:48   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:28:38   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:55:24   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:13:48   gregs
 * Initial revision.
 * 
 *    Rev 1.2   10 Nov 1992 15:27:50   kwok
 * If the packet is 802.x frame, then the length of the upper layer PDU should
 * have been db_actcnt - IEEESIZE rather than db_actcnt - PKT_IEEEHDR. 
 * PKT_IEEEHDR is a flag rather than the length of a 802.x MAC header. This 
 * was a typing error.
 * 
 *    Rev 1.1   13 May 1992 10:02:30   pvcs
 * 
 *    Rev 1.0   16 Apr 1992 18:20:58   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		2.8.91
*
*	Version:	1.0
*
*	Programmers:
*
*	Modifications:
*
*	Comments:	Port to i960 platform.
*			Replaced all unsigned, unsword, unsigned by ushort.
*			lword by ulong.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <krnl.h>
#include <types.h>
#include <dbd.h>
#include <netbuf.h>
#include <ether.h>
#include <tcpip.h>


extern	MBOX IpReceiveMbox;
extern IF_ENTRY	*ifcntrs;
extern	NID* MyNid();


/*
 *  ROUTINES TO TRANSLATE FROM FTP TYPE DRIVERS TO THE NIM CHANNEL DRIVER
 */ 

/* 
 * Process received packet:
 *   funnel to TCP/IP or Arpanet - shift to FTP type buffer
 *   funnel to V2, packet as is.
 */
etarp_rcv(d, ieee)
register PACKET d;
uint	ieee;	/* flags that packet has ieee header */

	{
	struct ieeehdr	*i = (struct ieeehdr *)d->db_buffer;
	uint	type;

	/* setup TCP/IP fields */
	d->nb_len  = d->db_actcnt;
	d->nb_tstamp = RealTimeTicks();
	if (ieee)
		{
		d->nb_prot = d->db_buffer + IEEESIZ;
		d->nb_flags = PKT_IEEEHDR;
		d->nb_len = d->db_actcnt - IEEESIZ;
		type = i->i_type;
		}
	else
		{
		d->nb_prot = d->db_buffer + ETHRSIZ;
		d->nb_flags = 0;
		d->nb_len = d->db_actcnt - ETHRSIZ;
		type = i->i_size;	/* use this type field */
		}

	/* filter the packet */
	if (*(byte *)i->i_dst & 0x01)
		d->nb_flags |= PKT_RCV_BROADCAST;
	else if (IsMyNid(i->i_dst, d->db_rcvportno) != TRUE)
		{
		(ifcntrs + d->db_rcvportno)->inerrpkts++;
		snc_put_dbd((DBD *)d);
		return;
		}
	if (d->db_actcnt < ET_MINLEN  || d->db_actcnt > _initp->rlenfree)
		{
		(ifcntrs + d->db_rcvportno)->inerrpkts++;
		snc_put_dbd((DBD *)d);
		return;
		}
	/* branch on protocol type */
	switch(type)
		{
	case ET_TRAILER0:
	case ET_TRAILER1:
	case ET_TRAILER2:
		fix_trailer(d, d->db_actcnt);
		/* fall through... */
	case ET_IP:
		SendMessage((MSGHDR *)d, (MBOX *)&IpReceiveMbox);
		break;
	case ET_ARP:
		etarrcv(d, d->nb_len);
		break;
	default:
		(ifcntrs + d->db_rcvportno)->inunknwnpkts++;
		snc_put_dbd((DBD *)d);
		}
	}
