/**			       
*
*	Program Name:	ARP 
*
*	Filename:	et_arp.c
*
*	$Log:   /b/gregs/i960/tcpip/drv/et_arp.c_v  $
 * 
 *    Rev 1.8   12 Oct 1993 10:39:46   franks
 * No change.
 * 
 *    Rev 1.7   11 Oct 1993 11:29:18   vinay
 * checking for fddi h/w type on arp reply.
 * 
 *    Rev 1.6   29 Sep 1993 10:28:36   franks
 * No change.
 * 
 *    Rev 1.5   10 Sep 1993 15:57:16   franks
 * Changed the time an idle entry is aged out of the arp cache from 60 min to 10 min.
 * 
 *    Rev 1.4   30 Jul 1993 13:55:22   franks
 * No change.
 * 
 *    Rev 1.3   20 Jul 1993 09:29:08   franks
 * 
 *    Rev 1.2   19 Jul 1993 17:31:20   franks
 * 
 *    Rev 1.1   16 Jul 1993 17:49:40   franks
 * 
 *    Rev 1.0   14 Jul 1993 10:13:46   gregs
 * Initial revision.
 * 
 *    Rev 1.2   16 Jun 1992 14:51:34   vinay
 * No change.
 * 
 *    Rev 1.1   13 May 1992 09:57:24   pvcs
* 
*    Rev 1.0   16 Apr 1992 18:20:56   pvcs
* Initial revision.
*
*	Creation Date:	not known
*
*	Date:		2.11.92
*
*	Version:	1.4
*
*	Programmers:	 
*
*	Modifications:	1.1	K Kong	2.28.91
*			It supports multi-ethernet ports.  Each port has
*			its own ethernet address. 
*
*			1.2	K Kong	8.12.91
*			merge the sources for the bridge and the terminal
*			server such that they share a common source and
*			object. All application specified functions have 
*			been removed from this file.  The major change is
*			the support for slip port in the terminal server.
*			Whenever there is a check on the slip port, the 
*			terminal server has to provide the function to 
*			support it, the bridge will provide a dummy function
*			for it such that there will be a single common 
*			object file.
*			The following functions have been changed :-
*			1	etarrcv()
*				Check the destination ip "ip_dest" against
* 				my ip and the ip of the slip ports. 
*			2	ip2et()
*				Adding the parmeter "srcip" such that the
*				source ip in the arp packet can be myself
*				or one of the slip port.
*			3	arp_send_req()
*				Adding the parameter "srcip" because it can
*				can myself, or any one of the slip port.
*				
*			1.3	K Kong	11.12.91
*			If the ARP packet is not for me, check if it
*			is for the SYSCARD - i.e. the admin. bus.
*
*			1.4	K Kong	2.11.92
*			Relearn the MAC address in "arp_add_cache()".
*
*	Comments:	Port to i960 platform.
*			Replaced all unsigned, unsword, unsigned by ushort.
*			lword by ulong.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
Copyright (C) 1986,1987 by FTP Software, Inc.

This software is furnished under a license and may be used and copied
only in accordance with the terms of such license and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to any
other person. No title to and ownership of the software is hereby
transferred.

The information in this software is subject to change without notice
and should not be construed as a commitment by FTP Software, Inc.
MOD: BLL - changed pctcp/error.h to error.h
*/
#include <krnl.h>
#include <types.h>
#include <dbd.h>
#include <netbuf.h>
#include <ether.h>
#include <tcpip.h>
#include <error.h>
#include <arp.h>

extern IF_ENTRY	*ifcntrs;
extern int	PortNum2List(int);
extern int	PortList2Num(int);

extern int	NumberOfSonicPort;
extern tcpip 	*_initp;

extern int 	IsSlipIP(in_name);
extern int 	IsSyscardIP(in_name);
extern int	IsMyPortIp(in_name);
extern NID	*MyNid();


/* Ethernet address resolution protocol (ARP) for IP. This is not a
	multihardware or multiprotocol implementation.
*/

/* EDIT HISTORY:
	6/24/86	Ramki	changed ip2et() to retry on network failure.
	6/24/86	Ramki	rewrote ARP caching code. rewrote counter management.
	9/4/86	Ramki	rewrote for source code sharing among various
			ethernet drivers.
	08/25/87 jbvb	Took version that allowed for space ahead of ether
			 header (for NS8390 chip), and ported to 2.0.
	09/27/87 ramki	brought up to date with latest kernel statistics code.
			 put in new 2.0 error stuff.
*/
int arp_send_req(in_name ipaddr, in_name srcip);
static struct tabent *ArpLookup(in_name ip);
static void arphnd(void);
static int et_arp_send(PACKET p, NID *dst);


volatile static uint	etipid;	   	/* increment by 1 whenever an 
				 * entry is added or accessed in the table 
				 * such that
				 * we know which entry is the least recently
				 * used one. 
				 */
struct tabent	table[ARP_CACHE_SIZE];
volatile uint	etneed = 0;
volatile uint	etlook = 0;
static TIMER	arptmr;		/* arp timer to flush the arp table */

/* Plummer's internals. All constants are already byte-swapped. */
#define	ARETH	0x100		/* ethernet hardware type */
#define	ARFDDI	0x600		/* fddi hardware type */
#define	ARIP	ET_IP		/* internet protocol type */
#define	ARREQ	0x100		/* byte swapped request opcode */
#define	ARREP	0x200		/* byte swapped reply opcode */

#define	ARP_MAX_TRIES	3

#define FDDI_PORT_NUM	3

/* ARP packet definition
*/
struct arp_pkt
	{
	ushort	ar_hd;		/* hardware type */
	ushort	ar_pro;		/* protcol type */
	byte	ar_hln;		/* hardware addr length */
	byte	ar_pln;		/* protocol header length */
	ushort	ar_op;		/* opcode */
	ushort	ar_sha[3];	/* sender hardware address */
	ushort	ar_spa[2];	/* sender protocol address */
	ushort	ar_tha[3];	/* target hardware address */
	ushort	ar_tpa[2];	/* target protocol address */
	};
/*
 *	The unpadded size of struct arp_pkt.
 *	Do not use the sizeof operator as it will give the
 *	padded size and NOT the unpadded size.
 */
#define	ARP_PKT_SIZE	28
/* ARP counters
*/
ARP_STAT	ArpStat = {0};

etainit()

	{
	register struct tabent *tp;
	int	i;

	for(i = 0, tp = table; i < ARP_CACHE_SIZE; i++, tp++) 
		tp->etip_id = 0;
	CreatTimer(&arptmr);
	StartTimerCall(&arptmr, 6000, arphnd, NULL);	/* start 1 min timer */

	return 0;	/* all is ok */
	}

fls_arp_cache()

	{
	register struct tabent *tp;
	int i;

	for(i = 0, tp = table; i < ARP_CACHE_SIZE; i++, tp++) 
		tp->etip_id = 0;
	}


/* add an entry to the arp cache. if the cache is full, flush lru entry. */
arp_add_cache(ip, et, ieee, PortNo)
in_name	ip;	/* the ip address		*/
byte	*et; 	/* the ethernet address of "ip"	*/
uint	ieee; 	/* Is it ieee or blue book ethernet	*/
uint	PortNo;	/* which port it is on		*/

	{
	register struct tabent *tp;
	struct tabent	*ltp; 
	struct tabent	*ftp = NULL; 
	int	i;


	if (ip == 0)
		return;
	/* scan the cache for this host or vacant entry.
	 *   keep track of last used entry
	 */
	for(i = 0, ltp = tp = table; i < ARP_CACHE_SIZE; i++, tp++) 
		{
		if (tp->etip_id == 0)
			ftp = tp;	/* we found a free entry */
		else 
			{
			if (tp->ip_addr == ip)
				{
				/*
				 *	K Kong, 2.11.92, relearn the address
				 */
				ftp = NULL;
				ltp = tp;
				break;
				}
			else if (tp->etip_id < ltp->etip_id)
				ltp = tp;	/* and the least recently used one */
			}
		}
	tp = ftp ? ftp /* free entry*/ : ltp /* last used entry */;
	tp->etip_id = ++etipid;
	tp->ip_addr = ip;
	tp->et_ttl  = 10;	/* 10 minutes */
	tp->et_ieee = ieee;
	ncopy(tp->et_addr, et);
	tp->PortNo = PortNo;
	}

/* Handle an incoming ARP packet. If it is a request and is for us, answer it.
	If it is a reply to us, cache it. Otherwise, discard it.
*/
void etarrcv(p, len)
PACKET	p;
uint	len;

	{
	struct arp_pkt	*padr;
	int	i;
	in_name	ip_src;		/*	src ip address in the arp packet */
	in_name	ip_dest;	/*	dest ip address in the arp packet */

	padr = (struct arp_pkt *)p->nb_prot;

	/*
	 *	Do not manipulate the 
	 *	protocol (IP) address as it is not
	 *	proper aligned. Copy it out first.
	 */
	ipcopy(&ip_dest, padr->ar_tpa);
	ipcopy(&ip_src, padr->ar_spa);


	if (ip_dest == NULL)
		{
		(ifcntrs + p->db_rcvportno)->inunknwnpkts++;
		putfree((DBD *)p);
		return;
		}
	switch(padr->ar_op) 
		{
	case ARREQ:
		/*
		 *	K Kong. Adding support for slip
		 *	If the destination ip is not for me, we
		 *	check if it is for one of the slip ports
		 *	K Kong, 11.12.91
		 *	check if it is for the SYSCARD.
		 */
		if(ip_dest != _initp->in_me && 
			!IsSlipIP(ip_dest) && 
			!IsSyscardIP(ip_dest) &&
			!IsMyPortIp(ip_dest)) 
			{
			putfree((DBD *)p);
			return;
			}

		/*
		 *	Hardware type must be ethernet or fddi
		 *	Protocol type must be IP, 
		 *	or it's an error
		 */
		if ( (padr->ar_hd != ARETH && padr->ar_hd != ARFDDI) ||
			padr->ar_pro != ARIP) 
		{
			(ifcntrs + p->db_rcvportno)->inunknwnpkts++;
			putfree((DBD *)p);
			return;
		}
		arp_add_cache(ip_src, padr->ar_sha, p->nb_flags, p->db_rcvportno);
		/*
		 *	assemble a ARP reply packet
		 */
		padr->ar_op = ARREP;
		/*
		 *	target hardware address (Ethernet) is
		 *	the hardware address of the sender in
		 *	the request packet.
		 */
		ncopy(padr->ar_tha, padr->ar_sha);
		/*
		 *	The sender hardware address is my
		 *	Ethernet address.
		 */

		ncopy(padr->ar_sha, MyNid(p->db_rcvportno));

		/*
		 *	The target protocol address is the
		 *	sender protocol address in the request
		 *	packet.
		 */
		ipcopy(padr->ar_tpa, &ip_src);
		/*
		 *	The sender protocol address is the 
		 *	destination address in the request packet.
		 */
		ipcopy(padr->ar_spa, &ip_dest);
		/*
		 *	To the port where it comes from
		 */
		p->db_xmtportlist = PortNum2List(p->db_rcvportno);
		et_arp_send(p, (NID *)padr->ar_tha);
		return;

	case ARREP:
		/*
		 *	Check if it is for me or one of the slip port.
		 *	Check if it is for the SYSCARD - admin. bus.
		 */
		if(ip_dest != _initp->in_me && 
			!IsSlipIP(ip_dest) && 
			!IsSyscardIP(ip_dest) &&
			!IsMyPortIp(ip_dest)) 
			{
			(ifcntrs + p->db_rcvportno)->inunknwnpkts++;
			putfree((DBD *)p);
			return;
			}
		/*
		 *	Hardware type must be ethernet,
		 *	Protocol type must be IP, 
		 *	or it's an error
		 */
		if((padr->ar_hd != ARETH && padr->ar_hd != ARFDDI)
			 || padr->ar_pro != ARIP) 
			{
			(ifcntrs + p->db_rcvportno)->inunknwnpkts++;
			putfree((DBD *)p);
			return;
			}
		arp_add_cache(ip_src, padr->ar_sha, p->nb_flags, p->db_rcvportno);
		putfree((DBD *)p);

		/* 'wake' the sleeper, in darkness */
		etlook += etneed;
		return;

	default:
		(ifcntrs + p->db_rcvportno)->inunknwnpkts++;
		putfree((DBD *)p);
		}
	}

/* Try looking up the IP address in the ARP cache. If found, copy the
	corresponding ethernet address into the storage provided.
	Otherwise send an ARP request and wait a while for the reply
*/
/*
 *	K kong, adding the parameter srcip to support slip in the
 *	terminal server.
 */
ip2et(ether, flagp, ip, srcip, PortList)
NID	**ether;
uint	*flagp;
in_name	ip;	/*	destination ip	*/
in_name	srcip;	/*	from this ip	*/
int	*PortList;

	{
	register struct tabent *tp;
	int	i;
	ulong	time;
	int	retries;

	/*
	 *	see if its for me, or
	 *	one of the slip port.
	 */

	if (ip == _initp->in_me || IsSlipIP(ip) || IsMyPortIp(ip))
		{
		/*
		 *	If it is for me,
		 *	send it to port 1
		 */
		*ether = MyNid(0);
		*flagp = PKT_IEEEHDR;
		*PortList = 1;
		return 0;
		}
	if ((tp = ArpLookup(ip)) != NULL)
		{
		*ether = (NID *)tp->et_addr;
		*flagp = tp->et_ieee;
		*PortList = PortNum2List(tp->PortNo);
		tp->etip_id = ++etipid;
		return 0;
		}
	/* retry the send up to ARP_MAX_TRIES in case of net failure */
	for(retries = 0; retries < ARP_MAX_TRIES; retries++)
		{
		/* 
		 *	one more waiter 
		 *	MUST be incremented before calling
		 *	arp_send_req() as arp_send_req will reschedule
		 *	and let the receiving task to run. 
		 *	The receiving task will check etneed.
		 */
		etneed++;	
		if (!arp_send_req(ip, srcip))	
			{
			etneed--;
			return ERR_NETFAIL;
			}
		if (etlook)
			etlook++;	/* and if packet being examined, one more looker */

		/* wait 1/2 second for response */
		time = RealTimeTicks() + 50;
		while(time > RealTimeTicks()) 
			{
			if (etlook)
				{
				etlook--;	/* one more waiting task has checked the table */
				if ((tp = ArpLookup(ip)) != NULL)
					{
					*ether = (NID *)tp->et_addr;
					*flagp = tp->et_ieee;
					*PortList = PortNum2List(tp->PortNo);
					tp->etip_id = ++etipid;
					etneed--;	/* one less waiter */
					return 0;	/* AOK */
					}
				}
			ReSchedule();
			}
		etneed--;	/* one less waiter */
		}
	return ERR_NET_UNREACHABLE;
	}

/* 	Broadcast ARP reply for ip to flush the arp table of all the hosts
 *	on the network
 */
int BroadcastArpReply(ipaddr)
in_name ipaddr;
	{
	struct arp_pkt	*padr;
	register PACKET p;
	int	i;
	int	PortList;
	int	failed = 0;
	int	PortNo = 0;
	int	sv_end_port_list;	/* 
					 *	SV_MAX_PORT << 1	
					 *	i.e if max port = 4, 
					 *	sv_end_port_list = 0x10
					 */

	sv_end_port_list = 1 << NumberOfSonicPort+1;
	/*
	 *	Transmit on all ports - one at a time
	 */
	for (PortList = 1; PortList < sv_end_port_list; 
		PortList <<= 1, PortNo++)
		{
/*** 	K Kong 3.19.91 
	Send Ethernet packet only.
		for (i = 0; i < 2; i++)
*******/
		for (i = 0; i < 1; i++)
			{
			if ((p = (PACKET)getfree()) == NULL)
				return TRUE;	/* did not send, but is ok */
			p->db_xmtportlist = PortList;
			if (i)
				{
				p->nb_prot = p->db_buffer + IEEESIZ;
				p->nb_flags = PKT_IEEEHDR;
				}
			else
				{
				p->nb_prot = p->db_buffer + ETHRSIZ;
				p->nb_flags = 0;
				}
	
			/* fill in the details */
			padr = (struct arp_pkt *)p->nb_prot;
			padr->ar_hd = ARETH;
			padr->ar_pro = ARIP;
			padr->ar_hln = 6;
			padr->ar_pln = sizeof(in_name);
			padr->ar_op  = ARREP;
			memset(padr->ar_tha, 0, 6);
			ncopy(padr->ar_sha, MyNid(PortNo));
			memset(padr->ar_tpa, 0, 4);
			ipcopy(padr->ar_spa, &ipaddr);
			if (et_arp_send(p, (NID *)ETBROADCAST))
				failed++;
			}
		}
	/*
	 *	It is ok if we can send on at least one of the
	 *	ports
	 */
	return (failed < NumberOfSonicPort+1) ? TRUE : FALSE;
	}

ShowArpTable()
	{
	register struct tabent *tp;
	int	i;
	int	entries = 0;

	printf("\n\n");
	for(i = 0, tp = table; i < ARP_CACHE_SIZE; i++, tp++) 
		{
		if (tp->etip_id != 0)
			{
			entries++;
			printf("%s\t\t%s\tPort %d\t%s\n", 
				inet_ntoa(tp->ip_addr),
				NidToString(tp->et_addr),
				tp->PortNo + 1, 
				((tp->et_ieee & PKT_IEEEHDR) ? "802.3" : "ethernet"));
			}
		}
	if (entries == 0)
		printf("The ARP table is empty\n");
	printf("\n\n");
	}
/* Broadcast ARP request for ipaddr. Doesn't wait to get a response. */
int arp_send_req(ipaddr, srcip)
in_name ipaddr;
in_name	srcip;	/*	use this as the source ip address	*/
	{
	struct arp_pkt	*padr;
	register PACKET p;
	int	i;
	int	PortList;
	int	failed = 0;
	int	PortNo = 0;
	int	sv_end_port_list;	/* 
					 *	SV_MAX_PORT << 1	
					 *	i.e if max port = 4, 
					 *	sv_end_port_list = 0x10
					 */

	sv_end_port_list = 0x10;
	/*
	sv_end_port_list = 1 << NumberOfSonicPort;
	*/

	/*
	 *	Transmit on all ports - one at a time
	 */
	for (PortList = 1; PortList < sv_end_port_list; 
		PortList <<= 1, PortNo++)
		{
/*** 	K Kong 3.19.91 
	Send Ethernet packet only.
		for (i = 0; i < 2; i++)
*******/
		for (i = 0; i < 1; i++)
			{
			if ((p = (PACKET)getfree()) == NULL)
				return TRUE;	/* did not send, but is ok */
			p->db_xmtportlist = PortList;
			if (i)
				{
				p->nb_prot = p->db_buffer + IEEESIZ;
				p->nb_flags = PKT_IEEEHDR;
				}
			else
				{
				p->nb_prot = p->db_buffer + ETHRSIZ;
				p->nb_flags = 0;
				}
	
			/* fill in the details */
			padr = (struct arp_pkt *)p->nb_prot;
			padr->ar_hd = ARETH;
			padr->ar_pro = ARIP;
			padr->ar_hln = 6;
			padr->ar_pln = sizeof(in_name);
			padr->ar_op  = ARREQ;
			ncopy(padr->ar_sha, MyNid(PortNo));
			memset(padr->ar_tha, 0, 6);
			ipcopy(padr->ar_spa, &srcip);
			ipcopy(padr->ar_tpa, &ipaddr);
			if (et_arp_send(p, (NID *)ETBROADCAST))
				failed++;
			}
		/*
		 *	Check if we have received any arp reply
		 */
		ReSchedule();
		/* 
		 *	If we have received an valid ARP replay,
		 *	we are done and do not have to send any more
		 *	arp request on the other ports
		 */
		if (ArpLookup(ipaddr) != NULL)
			return TRUE;
		}
	/*
	 *	It is ok if we can send on at least one of the
	 *	ports
	 */
	return (failed < NumberOfSonicPort+1) ? TRUE : FALSE;
	}


/* send an arp packet - assumes it's already formatted up. */
static int et_arp_send(p, dst)
register PACKET p;
NID	*dst;
	{
	uint	x;
	uint	len;
	char  da_xlate[6];

	if (p->nb_flags & PKT_IEEEHDR)
		{
		struct ieeehdr	*pi = (struct ieeehdr *)(p->nb_prot - IEEESIZ);

		/* set ethernet mac fields: dst src len */
		len = ARP_PKT_SIZE + IEEESIZ;
		ncopy(pi->i_dst, dst);
		ncopy(pi->i_src, MyNid(PortList2Num(p->db_xmtportlist)));
		pi->i_size = htons(len - ETHRSIZ);

		/* set LLC fields: snap auth=DOD type */
		pi->i_snp0 = IEEESNP0;
		pi->i_snp2 = IEEESNP2;
		pi->i_dod0 = IEEEDOD0;
		pi->i_dod1 = IEEEDOD1;
		pi->i_type = ET_ARP;  
		}
	else	/* normal ether header */
		{
		
		struct ethhdr	*pe = (struct ethhdr *)(p->nb_prot - ETHRSIZ);
			
		/* set ethernet mac fields: dst src type */
		len = ARP_PKT_SIZE + ETHRSIZ;
		ncopy(pe->e_dst, dst);

		ncopy(pe->e_src, MyNid(PortList2Num(p->db_xmtportlist)));
		pe->e_type = ET_ARP;  
		}

	/* forward ho */
	p->db_indent = 0;
	x = nim_xmt(p, len);
	putfree(p);
	if (x == ERR_NORSRC)	
		x = 0;		 /* its ok to run out of buffers */
	return x;
	}


/* 1 minute timer routine for cache */
static void arphnd()
	{
	register struct tabent *tp;
	int	i;

	/* tick down all timers */
	for (i = 0, tp = table; i < ARP_CACHE_SIZE; i++, tp++) 
		if (tp->etip_id != 0)
			if (--tp->et_ttl == 0)	/* and it is time out */
				tp->etip_id = 0;	/* then free it */
	/* re-start 1 min timer */
	StartTimerCall(&arptmr, 6000, arphnd, NULL);		
	}

static struct tabent *ArpLookup(in_name ip)

	{
	int	i;	/* temp counter	*/
	struct tabent	*tp;	/* arp table pointer	*/

	/* linear search the cache...oh well... */
	for(i = 0, tp = table; i < ARP_CACHE_SIZE; i++, tp++) 
		if (tp->etip_id && tp->ip_addr == ip)	/* found it */
			{
			return tp;
			}
	return NULL;
	}



