/*
 * This file contains the routines which implement the IBM PC multitasking
 * system. Only the (hopefully) machine-independent routines are included
 * herein; the machine dependent routines are in the files stack.c and
 * tk_util.a86. The following routines are included:
 *	tk_fork		creates additional tasks.  Returns 0 if no memory left.
 *	tk_block	blocks the current, goes through the circular list 
 *			of tasks task in round robbin order until it finds
 *			one that is awake and starts it running 
 *	tk_wake		awakens a task by seting its event flag 
 *	tk_exit		to kill your own task
 *	tk_kill		to kill another task
 *	tk_stats()	to print statistics on tasking
 *     
 *	$Log:   /b/gregs/i960/tcpip/async/task.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 10:39:00   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 10:27:32   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:12:58   gregs
 * Initial revision.
 * 
 *    Rev 1.0   16 Apr 1992 18:19:18   pvcs
 * Initial revision.
 */

#include <types.h>
#include <krnl.h>
#include <dbd.h>
#include <sys.h>
#include <task.h>

extern MBOX TmrMbox;

/*
 *	Create a new task with the specified amount of stack space
 *	Returns a pointer to the task structure if successful.
 *	else a NULL value is returned
 *
 */
task *
tk_fork(start,stk_size,arg)
int 	(*start)();
int	stk_size;
unsigned int arg;
{
	task	*tskp;
	int	*stkp;

	if((tskp = (task *)lmalloc(sizeof(SEM))) == NULL)
	{
		printf("lmalloc error\n");
		return NULL;
	}
	if((stkp = (int *)hmalloc(stk_size)) == NULL)
	{
		printf("hmalloc error\n");
		return NULL;
	}
	CreatTask(start,stkp,stk_size,0);
	return(tskp);
}
/*
 * Queue
 */

q_elt q_create()
{
	queue *q;
	if (q = (queue *)malloc(sizeof(queue)))
		CreatMailbox(q);
	return (q_elt)q;
}


/* Allocate a timer and return a pointer to it */
TIMER *tm_alloc()
{
	TIMER *tm = (TIMER *)malloc(sizeof(TIMER));

	if (tm != NULL)
		CreatTimer(tm);
	return tm;
}

/* Free up a timer. Returns true if successful, false otherwise */
tm_free(tm)
register TIMER *tm;
{
	word status = tm_clear(tm);
	free(tm,sizeof(TIMER));
	return status;
}

/*
 * Set a timer.  store processing routine and argument for later.
 */
tm_tset (nticks, subr, arg, tm)
int	nticks;		/* timer expiration time */
int	(*subr)();	/* subroutine to call on expiration */
char	*arg;	/* arg to pass to subr. */
register TIMER	*tm;
{		/* place to return timer id */
	StartTimerCall(tm,nticks,subr,arg);
}

tm_retset (n,t)
int n;
TIMER t;
{
	StopTimer(&t);
	StartTimerCall(&t, n, t.tm_subr,t.tm_arg);
}

/* 
 * Clear the timer.
 * Returns FALSE if timer not found.
 * Free the timer's storage to the free list.
 * TRUE otherwise.
 */
tm_clear(tm)
register TIMER *tm;
{
	return StopTimer(tm) ? TRUE : FALSE;
}
