

/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	dis.c
*
*	$Log:   /b/gregs/i960/newdebug/dis.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 10:36:28   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 10:25:48   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:26:16   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 12:55:28   franks
 * No change.
 * 
 *    Rev 1.0   05 Apr 1993 17:27:48   ramki
 * Initial revision.
 * 
 *    Rev 1.1   09 Jun 1992 19:15:28   kwok
 * Declare the static functions at the beginning of the file.
 * 
 *    Rev 1.0   30 Mar 1992 16:54:44   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/


#include <dbdefines.h>
#include <regs.h>

/************************************************/
/*	LOOKUP TABLE FOR OPCODES		*/
/* This table is rather confusing at first 	*/
/* glance.  Given the embedded nature of NINDY, */
/* the table is designed to pack the op's in as */
/* tight as possible in a somewhat logical 	*/
/* order.  The opcodes are inserted into the 	*/
/* table in their respective places where 	*/
/* possible.  All of the two digit opcodes are  */
/* just a straight lookup.  The three digit 	*/
/* opcodes often must be inserted elsewhere into*/
/* the table where there is room.  Their new	*/
/* location is pointed to by the first two 	*/
/* digit's straight lookup.  It then turns into */
/* somewhat of a hash table to find the correct */
/* opcode from there.  Believe it or not it all	*/
/* works out fine.  It just takes some time for	*/
/* the programmer to get it all sorted out.	*/
/************************************************/

static	dis();
static 	cobr(unsigned instruction, int op);
static	ctrl(unsigned instruction, int op);
static	mem(unsigned instruction, int op);
static	reg(unsigned instruction, int op);
static	invalid(int instruction);
static	regop(int mode1, int src, int fp);
static	mema(unsigned instruction, int op, char *reg1, char *reg2);
static	memb(unsigned instruction, int op, char *reg1, char *reg2);


static const struct { short opcode; char *name; short numops; }
instr[] = {

	0,	NULL,		0,	/* --------00-------- */
	0x670,	"emul",		3,
	0x671,	"ediv",		3,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0x08,	"b",		1,
	0x09,	"call",		1,
	0x0a,	"ret",		0,
	0x0b,	"bal",		1,
	0x741,	"muli",		3,
	0x748,	"remi",		3,
	0x749,	"modi",		3,
	0x74b,	"divi",		3,	/* ________0F________ */
	0x10,	"bno",		1,	/* --------10-------- */
	0x11,	"bg",		1,
	0x12,	"be",		1,
	0x13,	"bge",		1,
	0x14,	"bl",		1,
	0x15,	"bne",		1,
	0x16,	"ble",		1,
	0x17,	"bo",		1,
	0x18,	"faultno",	0,
	0x19,	"faultg",	0,
	0x1a,	"faulte",	0,
	0x1b,	"faultge",	0,
	0x1c,	"faultl",	0,
	0x1d,	"faultne",	0,
	0x1e,	"faultle",	0,
	0x1f,	"faulto",	0,	/* ________1F________ */
	0x20,	"testno",	1,	/* --------20-------- */
	0x21,	"testg",	1,
	0x22,	"teste",	1,
	0x23,	"testge",	1,
	0x24,	"testl",	1,
	0x25,	"testne",	1,
	0x26,	"testle",	1,
	0x27,	"testo",	1,
	0x640,	"spanbit",	2,
	0x641,	"scanbit",	2,
	0x645,	"modac",	3,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,	/* ________2F________ */
	0x30,	"bbc",		3,	/* --------30-------- */
	0x31,	"cmpobg",	3,
	0x32,	"cmpobe",	3,
	0x33,	"cmpobge",	3,
	0x34,	"cmpobl",	3,
	0x35,	"cmpobne",	3,
	0x36,	"cmpoble",	3,
	0x37,	"bbs",		3,
	0x38,	"cmpibno",	3,
	0x39,	"cmpibg",	3,
	0x3a,	"cmpibe",	3,
	0x3b,	"cmpibge",	3,
	0x3c,	"cmpibl",	3,
	0x3d,	"cmpibne",	3,
	0x3e,	"cmpible",	3,
	0x3f,	"cmpibo",	3,	/* ________3F________ */
	0,	NULL,		0,	/* --------40-------- */
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,	/* ________4F________ */
	0x610,	"atmod",	3,	/* --------50-------- */
	0x612,	"atadd",	3,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	(char*)0xd0,	0,
	0,	(char*)0xb3,	0,
	0,	(char*)0xa3,	0,
	0,	(char*)0xbd,	0,
	0x5cc,	"mov",		2,
	0,	(char*)0xe0,	0,
	0x5ec,	"movt",		2,
	0x5fc,	"movq",		2,	/* ________5F________ */
	0,	NULL,		0,	/* --------60-------- */
	0,	(char*)0x50,	0,
	0,	NULL,		0,
	0,	(char*)0x71,	0,
	0,	(char*)0x28,	0,
	0,	(char*)0xff,	0,
	0,	(char*)0xf0,	0,
	0,	(char*)0x01,	0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,	/* ________6F________ */
	0,	(char*)0x8d,	0,	/* --------70-------- */
	0x630,	"sdma",		3,
	0x631,	"udma",		0,
	0,	NULL,		0,
	0,	(char*)0x0c,	0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0, 	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,	/* ________7F________ */
	0x80,	"ldob",		2,	/* --------80-------- */
	0,	NULL,		0,
	0x82,	"stob",		2,
	0,	NULL,		0,
	0x84,	"bx",		1,
	0x85,	"balx",		2,
	0x86,	"callx",	1,
	0,	NULL,		0,
	0x88,	"ldos",		2,
	0,	NULL,		0,
	0x8a,	"stos",		2,
	0,	NULL,		0,
	0x8c,	"lda",		2,
	0x701,	"mulo",		3,
	0x708,	"remo",		3,
	0x70b,	"divo",		3,	/* ________8F________ */
	0x90,	"ld",		2,	/* --------90-------- */
	0,	NULL,		0,
	0x92,	"st",		2,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0x98,	"ldl",		2,
	0,	NULL,		0,
	0x9a,	"stl",		2,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,	/* ________9F________ */
	0xa0,	"ldt",		2,	/* --------A0-------- */
	0,	NULL,		0,
	0xa2,	"stt",		2,
	0x5a0, 	"cmpo",		2,
	0x5a1, 	"cmpi",		2,
	0x5a2, 	"concmpo",	2,
	0x5a3, 	"concmpi",	2,
	0x5a4, 	"cmpinco",	3,
	0x5a5, 	"cmpinci",	3,
	0x5a6, 	"cmpdeco",	3,
	0x5a7, 	"cmpdeci",	3,
	0x5ac, 	"scanbyte",	2,
	0x5ae, 	"chkbit",	2,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,	/* ________AF________ */
	0xb0,	"ldq",		2,	/* --------B0-------- */
	0,	NULL,		0,
	0xb2,	"stq",		2,
	0x590, 	"addo",		3,
	0x591, 	"addi",		3,
	0x592, 	"subo",		3,
	0x593, 	"subi",		3,
	0x598, 	"shro",		3,
	0x59a, 	"shrdi",	3,
	0x59b, 	"shri",		3,
	0x59c, 	"shlo",		3,
	0x59d, 	"rotate",	3,
	0x59e, 	"shli",		3,
	0x5b0, 	"addc",		3,
	0x5b2, 	"subc",		3,
	0, 	NULL,		0,	/* ________BF________ */
	0xc0,	"ldib",		2,	/* --------C0-------- */
	0,	NULL,		0,
	0xc2,	"stib",		2,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0xc8,	"ldis",		2,
	0,	NULL,		0,
	0xca,	"stis",		2,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,	/* ________CF________ */
	0x580,	"notbit",	3,	/* --------D0-------- */
	0x581,	"and",		3,
	0x582,	"andnot",	3,
	0x583,	"setbit",	3,
	0x584,	"notand",	3,
	0,	NULL,		0,
	0x586,	"xor",		3,
	0x587,	"or",		3,
	0x588,	"nor",		3,
	0x589,	"xnor",		3,
	0x58a,	"not",		2,
	0x58b,	"ornot",	3,
	0x58c,	"clrbit",	3,
	0x58d,	"notor",	3,
	0x58e,	"nand",		3,
	0x58f,	"alterbit",	3,	/* ________DF________ */
	0x5d8,	"eshro",	3, 	/* ________E0________ */
	0x5dc,	"movl",		2,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,	/* ________EF________ */
	0x660,	"calls",	1,	/* --------F0-------- */
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0,	NULL,		0,
	0x66b,	"mark",		0,
	0x66c,	"fmark",	0,
	0x66d,	"flushreg",	0,
	0,	NULL,		0,
	0x66f,	"syncf",	0,	/* ________FF________ */
	0x650,	"modify",	3,
	0x651,	"extract",	3,
	0x654,	"modtc",	3,
	0x655,	"modpc",	3,
	0,	NULL,		0,
	0x659,	"sysctl",	3,
};

static const char
regs[][4] = {
	"pfp", "sp", "rip", "r3",  "r4",  "r5",  "r6",  "r7",
	"r8",  "r9", "r10", "r11", "r12", "r13", "r14", "r15",
	"g0",  "g1", "g2",  "g3",  "g4",  "g5",  "g6",  "g7",
	"g8",  "g9", "g10", "g11", "g12", "g13", "g14", "fp"
};

static char *fregs[] = { "fp0", "fp1", "fp2", "fp3", "0.0", "1.0" };
static char tab[] = "           ";

static unsigned int *ip;


/************************************************/
/* Disassemble A Word in Memory        		*/
/*                           			*/
/************************************************/
dasm( dummy, nargs, addr, cnt )
int dummy;	/* Ignored */
int nargs;	/* Number of following arguments that are valid (0,1, or 2) */
int addr;	/* Optional address of instruction (defaults to ip)	*/
int cnt;	/* Optional number of instructions (defaults to 1)	*/
{
	/* Set defaults */
	if ( nargs <= 1 ){
		cnt = 1;
		if ( nargs == 0 ){
			addr = register_set[REG_IP];
		}
	}

	ip = (unsigned int *)addr;
	while ( cnt-- ) {
		dprintf("\n%08X : %08X", ip, *ip);
		dis();
		ip++;
	}
}

/****************************************/
/* Disassemble Instructions		*/
/****************************************/
static
dis()
{
unsigned int instruction; 	/* 32 bit machine instruction */
unsigned int opcode; 	

	instruction = *ip;
	opcode = instruction >> 24;

	/* check for valid opcode */
	if (instr[opcode].opcode != 0) {
		if (opcode < 0x20) {
			dprintf(tab);
			ctrl(instruction, opcode);
		}
		else if (opcode < 0x40) {
			dprintf(tab);
			cobr(instruction, opcode);
		}
		else if (opcode > 0xCA) {
			dprintf(tab);
			invalid(instruction);
		}
		else if (opcode >= 0x80) {
			mem(instruction, opcode);
		}
		else {
			dprintf(tab);
			reg(instruction, opcode);
		}
	}

	/* still may be valid opcode, but of REG format */
	else {
		/* valid REG opcode */
		if ( instr[opcode].name != NULL ) {
			dprintf(tab);
			reg(instruction, opcode);
		}
	
		/* invalid instruction, print as data word */ 
		else {
			dprintf(tab);
			invalid (instruction);
		}
	}
}

/****************************************/
/* CTRL format				*/
/****************************************/
static
ctrl(instruction, op)
unsigned int instruction;
int op;
{
int displace;

	if ( (instruction & 0x1) && (instr[op].opcode == op) ){
		invalid(instruction);
	} else {
 		if (instruction & 0x2){ 
			dprintf("%s.f  ", instr[op].name );
                } else {
			dprintf("%s  ", instr[op].name );
		}

		if ((op < 0x18) && (strcmp(instr[op].name, "ret"))) {
			displace = (int)(instruction & 0xfffffc);
			if (displace & 0x800000) { /* sign bit is set */
				/* sign extend displacement */
				displace |= -1 & ~0x00ffffff;
			}
			displace += (int)ip;
			dprintf("0x%08X",displace);
		}
	}
}

/****************************************/
/* COBR format				*/
/****************************************/
static
cobr(instruction, op)
unsigned int instruction;
int op;
{
int displace, dst;

	if ( (instruction & 0x1) && (instr[op].opcode == op) ){
		invalid (instruction);
		return;
	}
	dprintf("%s", instr[op].name);

 	if (instruction & 0x3)
                dprintf(".f  ");
        else
                dprintf("  ");

	dst = (instruction >> 19) & 0x1f;

	if (op >= 0x30) {
		if ( instruction & 0x2000 ) {
			dprintf("0x%b,  ",dst);
		} else {
			dprintf("%s,   ", regs[dst]);
		}
		
		dprintf("%s,  ", regs[(instruction>>14) & 0x1f] );

		displace = (int)(instruction & 0x1ffc);
		if (displace & 0x1000) { /* negative displacement */
			/* sign extend displacement */
			displace = (-1 & ~0x1fff) | displace;
		}
		dprintf("0x%08X", displace + (int)ip );
	}
	else {
		dprintf(regs[dst]);
	}
}

/****************************************/
/* MEM format				*/
/****************************************/
static
mem(instruction, op)
unsigned int instruction;
int op;
{
const char *reg1, *reg2;

	reg1 = regs[ (instruction>>19) & 0x1f ];
	reg2 = regs[ (instruction>>14) & 0x1f ];

	if  ( instruction & 0x1000 ){
		memb(instruction, op, (char *)reg1, (char *)reg2);
	} else { 			/* MEMB format */
		mema(instruction, op, (char *)reg1, (char *)reg2);
	}
}

/****************************************/
/* REG format				*/
/****************************************/
static
reg(instruction, op)
unsigned int instruction;
int op;
{
int index, mode1, mode2, mode3, fp;
int src, dst, src2, tmp, count, check, valid;

	check = (instruction >> 5) & 0x03;
	if (check != 0) {
		invalid (instruction);
		return;
	}

	if ((instr[op].opcode == 0x5cc)
		|| (instr[op].opcode == 0x5ec)
		|| (instr[op].opcode == 0x5fc))
	{
		index = op;
		op = (op << 4) + ((instruction >> 7) & 0x0f);
		if (instr[index].opcode != op)
		{
			invalid (instruction);
			return;
		}
	}
	else
	{
		index = (int) instr[op].name;
		op = (op << 4) + ((instruction >> 7) & 0x0f);
		count = 0;
		while (instr[index].opcode != op)
		{
			if (count++ > 15)
			{
				invalid (instruction);
				return;
			}
			index++;
		}
	}
	dprintf("%s  ", instr[index].name );

	mode1 = (instruction >> 11) & 0x01;
	mode2 = (instruction >> 12) & 0x01;
	mode3 = (instruction >> 13) & 0x01;
	src = instruction & 0x1f;
	src2 = (instruction >> 14) & 0x1f;
	dst = (instruction >> 19) & 0x1f;
	if ((op >= 0x78b) || ((op < 0x6e9) && (op >= 0x674))) 
		fp = TRUE;
	else
		fp = FALSE;

	switch ( instr[index].numops ){
		case 1:
			if (op == 0x673) {
				mode1 = mode3;
				src = dst;
			}
			regop (mode1, src, fp);
			break;
		case 2:
			if ( ((op >= 0x5a0) && (op <= 0x5ae))
			||   ((op >= 0x600) && (op <= 0x602))
			||   (op == 0x684) || (op == 0x685)
			||   (op == 0x694) || (op == 0x695) ) {
				dst = src2;
				mode3 = mode2;
			}
			regop(mode1,src,fp);
			dprintf(",  ");
			regop(mode3,dst,fp);
			break;
		case 3:
			regop(mode1,src,fp);
			dprintf(",  ");
			regop(mode2,src2,fp);
			dprintf(",  ");
			regop(mode3,dst,fp);
			break;
	}
}

/************************************************/
/* Print out effective address			*/
/*                           			*/
/************************************************/
static
ea(mode, reg2, reg3, word2, scale)
int mode;
char *reg2, *reg3;
unsigned int word2;
int scale;
{
	switch (mode) {
		case 4:	 		/* (reg) */
			dprintf("(%s)",reg2);
			break;
		case 5:			/* displ+8(ip) */
			word2 += 8;
			dprintf("0x%x(0x%x)", word2, ip);
			break;
		case 7:			/* (reg)[index*scale] */
			if (scale == 1) {
				dprintf("(%s)[%s]",reg2,reg3);
			} else {
				dprintf("(%s)[%s*%b]",reg2,reg3,scale);
			}
			break;
		case 12:		/* displacement */
			dprintf("0x%08X",word2);
			break;
		case 13:		/* displ(reg) */
			dprintf("0x%08X(%s)",word2,reg2);
			break;
		case 14:		/* displ[index*scale] */
			if (scale == 1) {
				dprintf("0x%x[%s]",word2,reg3);
			} else {
				dprintf("0x%x[%s*%b]",word2,reg3,scale);
			}
			break;
		case 15:		/* displ(reg)[index*scale] */
			dprintf("0x%x(%s)[%s",word2,reg2,reg3);
			if (scale != 1) {
				dprintf("*%b",scale);
			}
			dprintf("]");
			break;
		default:
			invalid (*ip);
			return;
	}
}

/************************************************/
/* MEMA instruction type      			*/
/*                           			*/
/************************************************/
static
mema (instruction, op, reg1, reg2)
unsigned int instruction;
int op;
char *reg1, *reg2;
{
int mode, offset;

	dprintf(tab);
	if (instr[op].opcode != op) {
		invalid (instruction);
		return;
	}
	dprintf("%s  ",instr[op].name);
	mode = instruction & 0x2000;
	offset = instruction & 0xfff;

	switch ( op & 0x0f ){
	case 0:
	case 5:
	case 8:
	case 12:
		/* load type */
		dprintf("0x%x",offset);
		if (mode != 0) {
			dprintf("(%s)",reg2);
		}
		dprintf(",   %s",reg1);
		break;

	case 2:
	case 10:
		/* store type */
		dprintf("%s,   0x%x",reg1,offset);
		if (mode != 0) {
			dprintf("(%s)",reg2);
		}
		break;

	case 4:
	case 6:
		/* bx/callx type */
		dprintf("0x%x",offset);
		if (mode != 0) {
			dprintf("(%s)",reg2);
		}
		break;
	}
}

/************************************************/
/* MEMB instruction type      			*/
/*                           			*/
/************************************************/
static
memb (instruction, op, reg1, reg2)
unsigned int instruction;
int op;
char *reg1, *reg2;
{
int scale, mode;
unsigned int word2;
unsigned int *oldip;
static const int scaler[] = {1, 2, 4, 8, 16};

	mode = (instruction >> 10) & 0x0f;
	scale = (instruction >> 7) & 0x07;
	if ((scale > 4) || (instruction & 0x60) != 0 ) {
		invalid (instruction);
		return;
	}
	if (instr[op].opcode != op) {
		dprintf(tab);
		invalid (instruction);
		return;
	}

	switch (mode) {
		case 4:	
		case 7:
			dprintf("%s%s  ", tab, instr[op].name);
			break;
		case 5:
		case 12:
		case 13:
		case 14:
		case 15:
			oldip = ip++;
			word2 = *ip;
			dprintf(" %08X  %s  ",word2,instr[op].name);
			break;
		default:
			invalid (instruction);
			return;
	}


	op &= 0xf;

	if ( op == 2 || op == 10 ){				/* store type */
		dprintf("%s,   ",reg1);
	}

	ea(mode,reg2, regs[instruction & 0x1f], word2, scaler[scale], oldip);

	if ( op == 0 || op == 5 || op == 8 || op == 12 ){	/* load type */
		dprintf(",   %s",reg1);
	}
	
}

/************************************************/
/* Output a single register operand 		*/
/*                           			*/
/************************************************/
static
regop(mode1,src,fp)
int mode1, src, fp;
{
	if(mode1 == 0) {
		dprintf(regs[src]);
	} else if (fp) {
		if (src == 16) src = 4;
		if (src == 22) src = 5;
		dprintf(fregs[src]);
	} else {
		dprintf("%x", src);
	}
}

/************************************************/
/* Invalid operation                		*/
/*                           			*/
/************************************************/
static
invalid (instruction)
int instruction;
{
	dprintf(".word     0x%08X",instruction);
}	
