/**			       
*
*	Program Name:	TESTER for stanley
*
*	Filename:	menuparse.c
*
*	$Log:   /b/gregs/i960/libutil/menuparse.c_v  $
 * 
 *    Rev 1.3   12 Oct 1993 10:35:32   franks
 * No change.
 * 
 *    Rev 1.2   29 Sep 1993 10:25:06   franks
 * No change.
 * 
 *    Rev 1.1   10 Sep 1993 15:25:34   franks
 * No change.
 * 
 *    Rev 1.0   08 Sep 1993 11:46:30   franks
 * Initial revision.
 * 
 *    Rev 1.0   08 Apr 1992 09:39:30   pvcs
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		6.17.91
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	This is the command line parsing. It is based on
*			the nindy debugger.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/
#include <menuparse.h>

static	struct cmd * lookup_cmd();
static	int get_words();
static char *lookup_help(char *cmd ,const char **help_table);

/************************************************************************
 * COMMAND TABLE
 *
 * The following table describes the keyboard commands.
 * The fields in each entry have the following meanings:
 *
 * cmd_name
 *	Name of command as a '\0'-terminated string.  Only the number of
 *	leading characters required for a match with user-entered input
 *	appear here,
 *
 * cmd_action
 *	Function that actually performs the command.  It should be
 *	invoked with the following arguments, in order:
 *		- the cmd_internal_arg from the command entry.
 *		- the number of following arguments that are valid on
 *			this call (some arguments may be optional).
 *		- one or more user-entered arguments, already parsed
 *			according to the corresponding cmd_argtypes.
 *
 * cmd_internal_arg
 *	First argument to be passed to the command action function.
 *
 * cmd_argtypes
 *	A '\0'-terminated list of characters describing the legal
 *	user-entered arguments to the command.  The ascii version
 *	of each argument should be translated into the corresponding
 *	type before it is passed to the action function.  Valid types are:
 *
 *	D  The text may be either a decimal constant (it should be
 *	   converted to binary before being passed) or a register name
 *	   (the register's contents should be passed).
 *
 *	H  The text may be either a hexadecimal constant (it should be
 *	   converted to binary before being passed) or a register name
 *	   (the register's contents should be passed).
 *
 *	S  The ASCII string should be passed unchanged to the action function.
 *
 *	Upper case letters indicate required arguments, lower case letters
 *	indicated optional arguments.  It is assumed that all required
 *	arguments always precede all optional ones.
 *
 ************************************************************************/


/************************************************/
/* Look up a command in the command table	*/
/************************************************/
static
struct cmd *
lookup_cmd( cmd, cmd_table )
char *cmd;
struct cmd *cmd_table;
{
struct cmd *cp;

	for ( cp = (struct cmd *)cmd_table; cp->cmd_name != NULL; cp++ ){
		if ( !strncmp(cmd,cp->cmd_name,strlen(cp->cmd_name)) ){
			return cp;
		}
	}
	return NULL;
}

int
MenuParse(char *Greetings, const struct cmd *cmd_list)
{
struct cmd *cp;
long pargs[4];
char histbuff[LINELEN] = "";	/* command history buffer */
char *args[MAXARGS];    /* Pointers to the individual words in linebuff.
			 * Each word is '\0'-terminated.
			 */
unsigned char linebuff[LINELEN];	/* command line buffer */
int nargs;		/* Number of meaningful entries in 'args' */
unsigned char *p;
int i;
int r;
int invalid_arg;
int RetCode;

	printf("%s", Greetings);
	while (TRUE){
		do {
			printf( "\n%s", "->");
			gets(linebuff);
		} while ( linebuff[0] == '\0' );

		for ( p = linebuff; *p; p++ ){
			if ( isupper(*p) ){
				*p = tolower(*p);
			}
		}

		/* Check if first non-blank is repeat command
		 */
		for ( p = linebuff; *p == ' ' || *p == '\t'; p++ ){
			;
		}
		if ( *p == '.' ){
			strcpy(linebuff,histbuff);
			printf("\n%s",histbuff);
		} else {
			/* not repeat command, add to history buffer */
			strcpy( histbuff, linebuff );
		}
		printf("\n");


		/* Break individual arguments out of command
		 */
		nargs = get_words( linebuff, args, MAXARGS );


		/* Check for valid command and number of arguments
		 */
		if ( (cp=lookup_cmd(args[0], cmd_list)) == NULL ){
			printf("Invalid command\n");
			continue;
		}
		if ( nargs > strlen(cp->cmd_argtypes)+1 ){
			/* +1 since nargs includes command name */
			printf( "Too many arguments\n" );
			continue;
		}


		/* Parse arguments according to types stored in command table
		 */
		p = cp->cmd_argtypes;
		invalid_arg = 0;
		for ( i = 1; i < nargs; i++, p++ ){
			switch ( *p ){
			case 'H':
			case 'h':
				if ( !atoh(args[i],&pargs[i]) ){
					printf("Invalid hex number: %s\n",args[i]);
					invalid_arg = 1;
				}
				break;
			case 'D':
			case 'd':
				if ( !atod(args[i],&pargs[i]) ){
					printf( "Invalid decimal number: %s\n",
								args[i] );
					invalid_arg = 1;
				}
				break;
			case 'S':
			case 's':
				pargs[i] = (long) args[i];
				break;
			}
		}

		/* Make sure all required arguments were present.
		 * If so, call action function.
		 */
		if ( !invalid_arg ){
			if ( isupper(*p) ){
				printf( "Missing argument(s)\n" );
			} else {
/***
				if (strcmp(cp->cmd_name, "ex") == 0)
					return 0;
****/
				if ((RetCode = cp->cmd_action( cp->cmd_internal_arg, 
						i - 1, pargs[1], 
						pargs[2], pargs[3] )) != 0)
						return RetCode;
			}
		}
	}
}

/************************************************/
/* Help                         		*/
/*                           			*/
/************************************************/
menuparse_help( help_table, nargs, cmdname )
const char	*help_table[];
int nargs;	/* Number of the following arguments that are valid */
char * cmdname;
{
	const char *p;

	printf("\n");
	if ( (nargs > 0) && (p=lookup_help(cmdname, &help_table[1])) != NULL )
		printf( p );
	else {
		printf("Available commands are:\n%s", help_table[0] );
	}
	return 0;
}
/************************************************/
/* get_words:	break individual words out of 	*/
/*		a command.			*/
/*						*/
/* Output:					*/
/*	words[0] is left pointing to first word	*/
/*	in command (command name), words[1]	*/
/*	points to 2nd word (first argument),	*/
/*	etc.  All words are '\0'-terminated.	*/
/*	Words are separated by whitespace or '#'*/
/*						*/
/* Return value:				*/
/*	Number of words in list.		*/
/*	Unused entries in 'words' are zeroed.	*/
/*						*/
/************************************************/
static int
get_words( p, words, max )
    register char *p;	/* Pointer to space-separated operands; MUCKED BY US */
    char *words[];	/* Output arg -- see above	*/
    int max;		/* Max number of words to be accommodated.
			 *	'words' must contain 'max' entries.
			 */
{
	register int n;		/* Number of words found */

	for ( n = 0; n < max; n++ ){
		words[n] = NULL;
	}

	n = 0;

	while ( *p != '\0' ){

		/* Skip lead white space */
		while ( *p == ' ' || *p == '\t' || *p == '#' ){
			p++;
		}

		if ( *p == '\0' ){
			break;
		}

		if ( n++ < max ){
			words[n-1] = p;
		}

		/* Find end of word */
		while ( *p != ' ' && *p != '\t' && *p != '#' && *p != '\0' ){
			p++;
		}

		/* Terminate word */
		if ( *p != '\0' ){
			*p++ = '\0';
		}
	}
	return n;
}


/************************************************/
/* Look up a command in the command table	*/
/************************************************/
static
char *
lookup_help( cmd , help_table)
char *cmd;
const char **help_table;
{
const char **p;

	for ( p = help_table; *p != NULL; p++ ){
		if ( !strncmp(cmd,*p,strlen(cmd)) ){
			return (char *) *p;
		}
	}
	return NULL;
}

