

/**
*	Product Name:	all i960 based products
*
*	Program Name:	eebridge
*
*	Filename:	memcpy.c
*
*	$Log:   /b/gregs/i960/libc/memcpy.c_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:55:24   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 10:24:04   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:24:26   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:31:20   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:47:40   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:23:14   gregs
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:01:04   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	gnu
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
 * memcpy(), memmove(), bcopy() : memory copying routines.
 *                                memmove() is guaranteed to work correctly
 *                                even if source and dest overlap.
 *
 * [atw] 18-Sep-89.
 */

#include "types.h"
#include "inc.h"

typedef struct {
  long x[4]; } QWORD;
typedef struct {
  long x[2]; } DWORD;

#undef memcpy
#undef memmove
#undef bcopy

void *
memmove(dest, src, len)
void *dest;
const void *src;
size_t len;
{
  const void *lasts;
  void *lastd;
  void *retval;
  
  /*
   * check for overlap; if not, use the
   * (presumably faster) memcpy routine.
   */
  lasts = src + (len-1);
  lastd = dest + (len-1);
  if (((dest < src) || (dest > lasts)) &&
      ((lastd < src) || (lastd > lasts)))
    return memcpy(dest, src, len);
  
  /*
   * no joy; copy the strings byte-by-byte
   * in the appropriate order (increasing byte
   * addresses if dest<src, decreasing if dest>src).
   */
  
  retval = dest;
  if (dest < src)
    while (len--)
      *(char *)dest++ = *(char *)src++;
  else
    while (len--)
      *(char *)lastd-- = *(char *)lasts--;
  
  return retval;
}

void *
memcpy(dest, src, len)
void *dest;
const void *src;
size_t len;
{
  void *retval=dest;

  /*
   * try quad word moves if possible
   */
  if ((((long)dest | (long)src) & 0xF)==0)
    {
      while ( len >= sizeof(QWORD))
	{
	  *(QWORD *)dest = *(QWORD *)src;
	  dest += sizeof(QWORD);
	  src += sizeof(QWORD);
	  len -= sizeof(QWORD);
	}
      if (len==0) return retval;
    }
  /*
   * ... now long word moves ...
   */
  if ((((long)dest | (long)src) & 0x7)==0)
    {
      while ( len >= sizeof(DWORD))
	{
	  *(DWORD *)dest = *(DWORD *)src;
	  dest += sizeof(DWORD);
	  src += sizeof(DWORD);
	  len -= sizeof(DWORD);
	}
      if (len==0) return retval;
    }
  /*
   * ... single word moves ...
   */
  if ((((long)dest | (long)src) & 0x3)==0)
    {
      while ( len >= sizeof(long))
	{
	  *(long *)dest = *(long *)src;
	  dest += sizeof(long);
	  src += sizeof(long);
	  len -= sizeof(long);
	}
      if (len==0) return retval;
    }
  /*
   * ... short word moves ...
   */
  if ((((long)dest | (long)src) & 0x1)==0)
    {
      while ( len >= sizeof(short))
	{
	  *(short *)dest = *(short *)src;
	  dest += sizeof(short);
	  src += sizeof(short);
	  len -= sizeof(short);
	}
      if (len==0) return retval;
    }
  /*
   * finish up with byte moves.
   */
  while (len--)
    *(char *)dest++ = *(char *)src++;
  return retval;
}
