#include <types.h>
#include <malloc.h>
#include <krnl.h>

static Header base;
static Header *freep ;


initmalloc(start_addr,size)
char *start_addr;
unsigned  size;
{
   base.s.ptr = (Header *) start_addr;
   base.s.size = 0;
   freep = (Header *) start_addr;
   freep->s.size = size/sizeof(Header) - 1;
   freep->s.ptr = &base;
}

void *malloc(unsigned int nbytes)
{
   Header *p,*prevp;
   unsigned nunits;
	register word saveMask;

	MaskAllInts(saveMask);
   nunits = (nbytes + sizeof(Header)-1)/sizeof(Header) +1;
   prevp = freep;
   for (p = prevp->s.ptr;;prevp = p, p = p->s.ptr) {
      if (p->s.size >= nunits) { /* big enough */
	 if (p->s.size == nunits) /* exactly */
	    prevp->s.ptr = p->s.ptr;
	 else {  /*allocate tail end */
	    p->s.size -= nunits;
	    p += p->s.size;
	    p->s.size = nunits;
	 }
	 freep = prevp;

	 /****************************/
	 p->s.marker = MALLOC_MARKER_DRAM;
	 /****************************/
	 RestoreIntMask(saveMask);
	 return (void*)(p+1);
	}
		if (p == freep) {	/* wrap around */
			RestoreIntMask(saveMask);
			return NULL;
		}
   }
   RestoreIntMask(saveMask);
   return NULL;
}


void free(void *ap)
{
   Header *bp, *p;
   int	count = 0;
	static int fscnt = 0;
	register word saveMask;

	MaskAllInts(saveMask);
   bp = (Header *)ap - 1;

	fscnt++;
/************************************/
   if(bp->s.marker != (MALLOC_MARKER_DRAM))
     enter_debug(0xaaaa,bp,ap);
/***********************************/
   for (p=freep; !(bp > p && bp < p->s.ptr); p = p->s.ptr)
   {
		if (p >= p->s.ptr && (bp > p || bp < p->s.ptr))
			break;
   }

   if (bp + bp->s.size == p->s.ptr) { /* join to upper */
      bp->s.size += p->s.ptr->s.size;
      bp->s.ptr = p->s.ptr->s.ptr;
   } else
      bp->s.ptr = p->s.ptr;
   if (p + p->s.size == bp) {
      p->s.size += bp->s.size;
      p->s.ptr = bp->s.ptr;
   } else
      p->s.ptr = bp;
   freep = p;
	RestoreIntMask(saveMask);
}





lmalloc(int size) {

    return malloc(size);
}

hmalloc(int size) {

    return malloc(size);
}
