

/**
*	Product Name:	all i960 based products
*
*	Program Name:	eebridge
*
*	Filename:	atol.c
*
*	$Log:   /b/gregs/i960/libc/atol.c_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:55:12   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 10:23:52   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:24:12   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:31:00   franks
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:47:30   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:23:08   gregs
 * Initial revision.
 * 
 *    Rev 1.2   08 Apr 1993 14:45:10   kenb
 * Update for 2.2 compiler
 * 
 *    Rev 1.1   21 Apr 1992 16:39:14   pvcs
 * No change.
 * 
 *    Rev 1.0   30 Mar 1992 17:00:54   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	gnu
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
 * strtol, atol, atoi : convert a string to long.
 *
 * Andy Wilson, 2-Oct-89.
 */

#include "types.h"
#include <limits.h>
#include "inc.h"

long atol(s)
     CONST register char *s;
{
  return strtol(s, NULL, 10);
}

int
atoi(s)
     CONST char *s;
{
  return (int) strtol(s, NULL, 10);
}

long
strtol(s, ptr, base)
     const char *s;
     char **ptr;
     int base;
{
  int minus=0;
  unsigned long tmp;
  const char *start=s;
	char *eptr;

  if (s==NULL)
    {
      if (!ptr)
	*ptr = (char *)start;
      return 0L;
    }
  while (*s == ' ')
	s++;
  if (*s == '-') {
	s++;
	minus = 1;
      }
  else if (*s == '+')
    s++;

  /*
   * let strtoul do the hard work.
   */
  tmp = strtoul(s, &(char *)eptr, base);
  if (ptr != NULL)
    *ptr = (eptr==s) ? (char *)start : eptr;
  if (tmp==ULONG_MAX)
    return (minus ? LONG_MIN : LONG_MAX);
  else
    return (minus ? (long) -tmp : (long) tmp);
}

unsigned long
strtoul(s, ptr, base)
     const char *s;
     char **ptr;
     int base;
{
  unsigned long total = 0, tmp = 0;
  unsigned digit;
  int radix;
  const char *start=s;
  int did_conversion=0;

  if (s==NULL)
    {
      if (!ptr)
	*ptr = (char *)start;
      return 0L;
    }

  while (*s == ' ')
    s++;
  if (*s == '+')
    s++;
  radix = base;
  if (base==0 || base==16)
    {
      /*
       * try to infer radix from the string
       * (assume decimal).
       */
      if (*s=='0')
	{
	  radix = 8;	/* guess it's octal */
	  s++;		/* (but check for hex) */
	  if (*s=='X' || *s=='x')
	    {
	      s++;
	      radix = 16;
	    }
	}
    }
  if (radix==0)
    radix = 10;

  while ( digit = *s )
    {
      if (digit >= '0' && digit < ('0'+radix))
	digit -= '0';
      else
	if (radix > 10)
	  {
	    if (digit >= 'a' && digit < ('a'+radix))
	      digit = digit - 'a' + 10;
	    else if (digit >= 'A' && digit < ('A'+radix))
	      digit = digit - 'A' + 10;
	    else
	      break;
	  }
	else
	  break;
      did_conversion = 1;
      tmp = (total * radix) + digit;
      if (tmp < total)	/* check overflow */
	{
	  if (ptr != NULL)
	    *ptr = (char *)s;
	  return (ULONG_MAX);
	}
      total = tmp;
      s++;
    }
  if (ptr != NULL)
    *ptr = (did_conversion) ? (char *)s : start;
  return (total);

}
