 /******************************************************************/
/*		Copyright (c) 1990, Intel Corporation

   Intel hereby grants you permission to copy, modify, and
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of
   Intel Corporation not be used in advertising or publicity
   pertaining to distribution of the software or the documentation
   without specific, written prior permission.

   Intel Corporation does not warrant, guarantee or make any
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness,
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own
   risk.							  */
/******************************************************************/
/*******************  Z85C30 Serial ports A-B  *******************/
 
struct SCCport {
	volatile unsigned char control;
	unsigned char dummy[7];
	volatile unsigned char data;
};

#define SCC_PORTA	((volatile struct SCCport *) (UARTIO+4))
#define SCC_PORTB	((volatile struct SCCport *) UARTIO)
#define CONSOLE		SCC_PORTB
#define	PCLK		8000000

#define SLIP_PORT 	SCC_PORTB

/* baud rate generator frequency(MHZ) */

typedef struct que
{
	word	put;
	word	get;
	word	max;
	char	*loc;
} QUE;

typedef struct uart
{
	QUE	inque;
	byte	inbuf[128];
	QUE	outque;
	byte	outbuf[128];
	word	flowed;
	word	cntrls;
} UART;

extern UART uart_mem;


#define BCODE_300   300
#define BCODE_600   600
#define BCODE_1200  1200
#define BCODE_2400  2400
#define BCODE_4800  4800
#define BCODE_9600  9600
#define BCODE_19200 19200
#define BCODE_38400 38400

/* define the register relate to TX & RX interrupt */
/* read reg 0 for 85c30 */
#define RX_CHR_AVAI  0x01       /* Rx character available */
#define TX_BUF_EMPTY 0x04       /* Tx buffer empty */

/* read reg 3 for 85c30 */
#define PORTB_TX_IP  0x02       /* PortB TX Interrupt pending */
#define PORTB_RX_IP  0x04       /* PortB RX Interrupt pending */
#define PORTA_TX_IP  0x10       /* PortA TX Interrupt pending */
#define PORTA_RX_IP  0x20       /* PortA RX Interrupt pending */

/* write reg0 for 85c30 */
#define ENABLE_NEXT_RCV  0x20    /* enable next receive interrupt */
#define RESET_TX_PENDING 0x28    /* reset  TX interrupt pending */
#define RESET_HIGHEST_IUS  0x38    /* reset highest IUS */
