#define MAX_SCC_RX_BUFFER	4096	/* size of DMA rcv buff (bytes)	*/
#define MAX_SCC_TX_BUFFER	1024	/* size of DMA xmt buff	(bytes) */
#define MAX_SCC_RX_GAP		36	/* maximum rcv buff gap (bytes) */
#define SCC_RX_SAFETY_MARGIN	512	/* bytes before end of rcv buff */ 
#define	DMA_CHANNEL_0	0x00000040	/* ram area of DMA info for 	*/
#define	DMA_CHANNEL_1	0x00000060	/* channels 0 & 1		*/
#define MAX_SCC_BD	40		/* no. of SCC Buffer Descriptor */
#define BD_FREE		0		/* Descriptor type: 0 - free	*/
#define BD_XMT		1		/*	1 - xmt, 2 - rcv	*/
#define BD_RCV		2

/*--------------------------------------------------------------------------
 * Scc buffer descriptor data structure.
 *--------------------------------------------------------------------------
 */
typedef struct _SCC_BD
{
	struct _SCC_BD	*next;
	byte		*buff_ptr;
	int		length;
	int		bd_type;
} SCC_BD;

/*--------------------------------------------------------------------------
 * Scc buffer descriptor queue structure.
 *--------------------------------------------------------------------------
 */
typedef struct 	
{
	SCC_BD *head;
	SCC_BD *tail;
} SCC_BD_QUEUE;

/*--------------------------------------------------------------------------
 * i960 DMA channel information in RAM.
 *--------------------------------------------------------------------------
 */
typedef struct
{
	word	byte_count;
	byte	*src_addr;
	byte	*dst_addr;
	byte	*next_ptr;
	word	reserved[4];
} DMA_INFO;

byte	*get_scc_tx_buff( int );

SCC_BD	*get_scc_bd( int );
void	free_scc_bd( SCC_BD* );
void	init_scc_bd( void );

void	set_xmt_dma( void );
void	set_rcv_dma( void );

extern	SCC_BD_QUEUE	scc_bd_q;
