/**			       
*
*	Program Name:	ADMIN bus driver
*
*	Filename:	immedcom.c
*
*	$Log:   /b/gregs/i960/adminbus/immedcom.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:36:12   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 10:19:46   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 10:13:28   gregs
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:32:52   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:27:30   gregs
 * Initial revision.
 * 
 *    Rev 1.1   13 Apr 1992 18:34:46   kwok
 * ImmedCommandHandler takes the extra parameter "RspOffset", the offset
 * to the Response buffer.
 * 
 *    Rev 1.0   30 Mar 1992 16:48:52   pvcs
 * Initial revision.
*
*	Creation Date:	2.20.92
*
*	Date:		4.9.92
*
*	Version:	1.1
*
*	Programmers:	K Kong
*
*	Modifications:	4.9.92	1.1	K Kong
*			The extra parameter "RspOffset" is passed
*			to the function ImmCommandHandler().
*
*	Comments:	K Kong	2.20.92
*			This is the default immediate command handler
*			for the function card.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/
#include <krnl.h>
#include <types.h>
#include <netbuf.h>
#include <tcpip.h>
#include <ether.h>
#include <admdrv.h>


#ifndef	BASE10T
#include <sockets.h>
#endif


/*----------------------------------------------------------------
	This function handles the Immediate Command.
  ----------------------------------------------------------------*/
int FAR ImmCommandHandler(int slot, int CmdCode, int CmdOffset, int RspOffset)
	{
	ADM_IRSP	Rsp;
	ADM_ICMD	Cmd;
	int	ret;
#ifndef	 BASE10T
	static	void *bootps = NULL;
	extern	int	BootpServer();
#endif

	memset((char FAR *) &Rsp, '\0', sizeof(Rsp));
	adm_read(slot, CmdOffset, sizeof(Cmd), (char FAR *)&Cmd);
	switch(CmdCode)
		{
		case ICMDRELAYON:

#ifndef	 BASE10T
			if (bootps == NULL)
				{
				bootps = (void *)udp_open(UDP_BOOTPS, BootpServer, 0);
				if (bootps == NULL)
					{
					Rsp.iRspType = IRSPNACK;
					Rsp.iRspData.iRspReason = IRSPNAK_BUSY;
					AdminCounters.AdmRelayerRefuseds++;
					break;
					}
				}
#endif
			AdminCounters.AdmRelayerAccepteds++;
			_initp->relayer = TRUE;	
			_initp->syscard = Cmd.iCmdData.iCmdIpAddr;
			Rsp.iRspType = IRSPACK;
#ifdef ADM_DEBUG
			AdmDebugMessage("Relayer on, syscard ip = %s\n",
				inet_ntoa(_initp->syscard));
#endif
			BroadcastArpReply(_initp->syscard);
			fls_arp_cache();
			break;

		case ICMDRELAYOFF:
			_initp->relayer = FALSE;
			_initp->syscard	= (in_name) 0;
			Rsp.iRspType = IRSPACK;
#ifndef	 BASE10T
			if (bootps != NULL)
				{
				udp_close(bootps);
				bootps = NULL;
				}
#endif
#ifdef ADM_DEBUG
			AdmDebugMessage("Relayer off\n");
#endif
			break;

		case ICMDCHANGEIP:
			if ( _initp->relayer == 0 )
				{
				Rsp.iRspType = IRSPNACK;
				Rsp.iRspData.iRspReason = IRSPNOTRELAYER;
				}
			else
				{
				_initp->syscard = Cmd.iCmdData.iCmdIpAddr;
				Rsp.iRspType = IRSPACK;
				}
			Rsp.iRspType = IRSPACK;
#ifdef ADM_DEBUG
			AdmDebugMessage("change syscard ip = %s\n",
				inet_ntoa(_initp->syscard));
#endif
			BroadcastArpReply(_initp->syscard);
			fls_arp_cache();
			break;

		case ICMD_CONS_OPEN:
			/*
			 *	Check if the application wants to accept the 
			 *	open request.
			 */
			ret = IRSPNAK_BUSY;
			if (IsAdmConOpened(slot) || 
				(ret = AdmOpenUpcall(slot)) != 0)
				{
				Rsp.iRspType = IRSPNACK;
				Rsp.iRspData.iRspReason = ret;
				}
			else
				{
				AdmOpenRequestInit(slot);
				Rsp.iRspType = IRSPACK;
				}
			break;
			
		case ICMD_CONS_CLOSE:
			ret = IRSPNAK_NOTOPEN;
			if (!IsAdmConOpened(slot) ||
				(ret = AdmCloseUpcall(slot)) != 0)
				{
				Rsp.iRspType = IRSPNACK;
				Rsp.iRspData.iRspReason = ret;
				}
			else
				{
				AdmCloseRequestCleanUp(slot);
				Rsp.iRspType = IRSPACK;
				}
			break;
	
		default:
			AdminCounters.AdmUnknownICmds++;
			Rsp.iRspType = IRSPNACK;
			Rsp.iRspData.iRspReason = IRSPNAKDOWN;
			break;
		}
	adm_write(slot, RspOffset, 
		sizeof(Rsp), (char FAR *)&Rsp);
	}

#if defined(BASE10T) && defined(ADM_DEBUG)
inet_ntoa(long ip)
	{
	static	char buf[20];
	unsigned char *p = (unsigned char *)&ip;

	sprintf(buf, "%d.%d.%d.%d", *p, *(p+1), *(p+2), *(p+3));
	return buf;
	}
#endif
