/**			       
*
*	Program Name:	Admin Bus driver - FUNCARD
*
*	Filename:	funcinf.c
*
*	$Log:   /b/gregs/i960/adminbus/funcinf.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:36:10   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 10:19:44   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 10:13:24   gregs
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:32:48   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:27:28   gregs
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 16:48:50   pvcs
 * Initial revision.
*
*	Creation Date:	11.8.91
*
*	Date:
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	K Kong	11.8.91
*			This module contains interface functions
*			to the lower level of the FUNCARD (stanley).
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/
#include <types.h>

extern	char	*AdminBusAddress;

/*
 * name		adm_read
 *
 * synopsis	adm_read(slot, offset, length, BuffPtr)
 *		int	slot; <<	not used
 *		uint	offset; <<	from the admin. bus shared ram.
 *		uint	length; <<	how many bytes to be read.
 *		char	*BuffPtr; <<	return data in this buffer
 *
 * description	Read "length" bytes starting from offset "offset" from
 *		the admin. bus shared ram and return the data in "BuffPtr".
 *
 * returns	number of bytes read
 */

int adm_read( int slot, uint offset, uint length, char *BuffPtr)

	{
	memcpy(BuffPtr, (char *)AdminBusAddress + offset, length);
	return length;
	}
/*
 * name		adm_read
 *
 * synopsis	adm_write(slot, offset, length, BuffPtr)
 *		int	slot; <<	not used
 *		uint	offset; <<	from the admin. bus shared ram.
 *		uint	length; <<	how many bytes to be written.
 *		char	*BuffPtr; <<	data to be written
 *
 * description	Copy "length" bytes from "BuffPtr" to the beginning of 
 *		admin. bus shared ram + "offset".
 *
 * returns	number of bytes written.
 */

int adm_write( int slot, uint offset, uint length, char *BuffPtr)

	{
	memcpy((char *)AdminBusAddress + offset, BuffPtr, length);
	return length;
	}

adm_memset(int offset, int data, int length)
	{
	memset((char*)AdminBusAddress + offset, data, length);
	}

IsValidSlot(int slot)
	{
	return SysCardPresent();
	}

