/* adminf.c - Defines the Administration Bus lower level primitives */
/*----------------------------------------------------------------

   Hughes LAN System.
   Mountain View, CA.

   CopyRight(c) 1991.
   All Rights Reserved

   Author:  Pedro E. Rangel

   $Log:   /b/gregs/i960/adminbus/admutil.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:36:10   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 10:19:42   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 10:13:22   gregs
 * No change.
 * 
 *    Rev 1.1   30 Jul 1993 13:32:48   franks
 * No change.
 * 
 *    Rev 1.0   14 Jul 1993 10:27:28   gregs
 * Initial revision.
 * 
 *    Rev 1.2   12 May 1992 20:53:50   kwok
 * Remove the out of date comment in the function AdmImmedCommand().
 * 
 *    Rev 1.1   13 Apr 1992 18:32:42   kwok
 * Check if the immediate command response is an ACK or a NACK after
 * calling adm_cmd().
 * 
 *    Rev 1.0   30 Mar 1992 16:48:50   pvcs
 * Initial revision.

   Rev    Date    Who   Comments
  -----  -------- ---   ------------------------------------------------
  00.00  08/17/91 PER   Initial software version.
  ----------------------------------------------------------------
*/
#if defined(SYSCARD) || defined(BASE10T)
#include <confsys.h>
#endif

#if !defined(KLHR) && !defined(STTG)
#include <krnl.h>
#include <dbd.h>
#endif

#include <netbuf.h>
#include <types.h>
#include <lme.h>
#include <admdrv.h>

extern	int FAR iRspCmdHandler();
extern	IF_ENTRY	FAR *AdmIfentry;

extern int FAR iRspCmdHandler();


/*----------------------------------------------------------------
	Dummy function to be called at the protocols not being 
	handle by the appliation.
  ----------------------------------------------------------------*/
int FAR DummyHandler()
	{
	AdmIfentry->inunknwnpkts++;
#ifdef ADM_DEBUG
	AdmDebugMessage("Dummy protocol Handler\n");
#endif
	}

/*----------------------------------------------------------------
	Add a command response handler.  This allow the upper
	layer function to be called every time a RspCmdID is
	needed from the system card.
  ----------------------------------------------------------------*/
int adm_add_ImmCmdRsp(int RspCmdID, int (FAR *RspCmdHandler)() )
	{
	int err = E_FAILURE;

 	if ( RspCmdID >= ICMDMIN && RspCmdID <= AdmMaxCommands && RspCmdHandler != NULL )
		{
		*(ImmRspTable + RspCmdID) = RspCmdHandler;
		err = E_SUCCESS;
		}
	return(err);
	}
/*----------------------------------------------------------------
	Deletes a command response handler.  This allow the upper
	layer function to be called every time a RspCmdID is
	needed from the system card.
  ----------------------------------------------------------------*/
int adm_del_ImmCmdRsp(int RspCmdID)
	{
	int err = E_FAILURE;

 	if ( RspCmdID >= ICMDMIN && RspCmdID <= AdmMaxCommands )
		{
		*(ImmRspTable + RspCmdID) = iRspCmdHandler;
		err = E_SUCCESS;
		}
	return(err);
	}
/*----------------------------------------------------------------
	Add a ADMIN BUS Buffer Protocol handler.  This enable the 
	ADMIN driver to pass to the upper layer a just received buffer
	(with the ProtocolID number).
  ----------------------------------------------------------------*/

int adm_add_protocol(int ProtocolID, int (FAR *ProtocolHandler)() )
	{
	int err = E_FAILURE;

 	if ( ProtocolID >= MINPROT && ProtocolID <= AdmMaxProtocols && ProtocolHandler != NULL )
		{
		*(ProtocolTable + ProtocolID) = ProtocolHandler;
		err = E_SUCCESS;
		}
	return(err);
	}

/*----------------------------------------------------------------
	Disables a ADMIN BUS Buffer Protocol handler.  Buffers received
	by the driver will be dropped.
  ----------------------------------------------------------------*/
int adm_del_protocol(int ProtocolID)
	{
	int err = E_FAILURE;

 	if ( ProtocolID >= MINPROT && ProtocolID <= AdmMaxProtocols )
		{
		*(ProtocolTable + ProtocolID) = DummyHandler;
		err = E_SUCCESS;
		}
	return(err);
	}

/*
 * name		CheckRxBufs
 *
 * synopsis	CheckRxBufs(slot, FillOff, AckOff, BufsOff)
 *		int	slot;	<<	slot number to be polled.
 *					0 for FUNCARD
 *					1 <= slot <= 13 for SYSCARD
 *		unsigned FillOff; <<	offset to the "BufFill",
 *					FUNCARD: "shmToBufFill"
 *					SYSCARD: "shmFromBufFill"
 *		unsigned AckOff;  <<	offset to the "BufAck"
 *					FUNCARD: "shmFromBufAck"
 *					SYSCARD: "shmToBufAck"
 *		unsigned BufsOff; <<	offset to the "list of buffers offset"
 *					FUNCARD: "shmToBuffers[0]"
 *					SYSCARD: "shmFromBuffers[0]"
 *
 * description	Check if there is any packet to be read. The action is
 *		based on the "fill" bit and the "ack" bit.
 *		"fill"	"ack" 	action
 *		0	0	Buffer is empty, do nothing
 *		0	1	Buffer's ack bit has been seen, reset ack bit
 *		1	0	Buffer contains data, read data and set ack bit
 *		1	1	Buffer has been acked, do nothing
 *
 *
 * returns	nothing
 */

CheckRxBufs(int slot, unsigned FillOff, unsigned AckOff, unsigned BufsOff)

	{
	int	i;
	short	AckList;
	short	TmpRxList;
	short	RxList;
	short	AckBits = 0;
	short	RxBuffer;
	ADMB	packet;
	int	PktType;	/* 	packet type	*/
	short	debugack;

	
	adm_read(slot, FillOff, sizeof(RxList), (char FAR *)&RxList);
	adm_read(slot, AckOff, sizeof(AckList), (char FAR *)&AckList);
	if (RxList != 0)
		{
		adm_read(slot, FillOff, sizeof(RxList), (char FAR *)&RxList);
		}
	/*
	 *	Check for any incoming packet
	 */
	for (i = 0; i < ADMBUFF && RxList != 0; i++, RxList >>= 1)
		{
		/* is there a buffer to be read */
		if ( (RxList & 1) != 0 && ((AckList >> i) & 1) == 0)
			{
			/*
			 *	"fill" = 1, "ack" = 0;
			 */
			/*
			 *	get the ADMB buffer offset
			 */
			adm_read(slot, BufsOff + (i * sizeof(RxBuffer)),
				sizeof(RxBuffer), (char FAR *)&RxBuffer);
			/*
			 *	get the ADMB buffer header
			 */
			adm_read(slot, RxBuffer, sizeof(packet), 
				(char FAR *)&packet);
			PktType = packet.bufFormat;
			/*
			 *	CHECK if type is ok !
			 */
			if (PktType < MINPROT || AdmMaxProtocols < PktType)
				{
				/*
				 *	Invalid packet type, 
				 *	(*ProtocolTable[0])()
				 *	will handle it.
				 */
				AdmIfentry->inerrpkts++;
				PktType = 0;
				}
			else
				{
				AdmIfentry->inucastpkts++;
				AdmIfentry->inbytecnt += packet.bufLength;
				}
			/*
			 *	pass the packet to the 
			 *	protocol handler.
			 */
			(**(ProtocolTable + PktType))(slot, RxBuffer, 
				packet.bufLength);
			/*
			 *	set the ack bit
			 */
			AckBits |= (1 << i);
			}
		}
	if (AckBits != 0)
		{
		/*
		 *	Set the "ack" bits.
		 */
		AckBits |= AckList;;
		adm_write(slot, AckOff, sizeof(AckList), (char FAR *)&AckBits);
		}
	/*
	 *	Check for "ACK bit is seen".
	 */
	if (AckList != 0)
		{
		/*	Fill	ACK
		 *	0	1	Buffer's ack bit has 
		 *			been seen, reset ack bit
		 */
		AckList |= AckBits;
		AckBits = 0;
		TmpRxList = AckList;
		adm_read(slot, FillOff, sizeof(RxList), (char FAR *)&RxList);
		for (i = 0; i < ADMBUFF && TmpRxList != 0; 
			i++, TmpRxList >>= 1, RxList >>= 1)
			{
			if ((RxList & 1) == 0 && (TmpRxList & 1) != 0)
				{
				/*
				 *	set the ack bit
				 */
				AckBits |= (1 << i);
				}
			}
		/*
		 *	Reset the ACK bits if it is not 0.
		 */
		if (AckBits != 0)
			{
			AckList &= ~AckBits;
			adm_write(slot, AckOff, sizeof(AckList), 
				(char FAR *)&AckList);
			}
		}
	}

/*
 * name		CheckTxCompletion
 *
 * synopsis	CheckTxCompletion(slot, FillOff, AckOff, BufsOff)
 *		int	slot;	<<	slot number to be polled.
 *					0 for FUNCARD
 *					1 <= slot <= 13 for SYSCARD
 *		unsigned FillOff; <<	offset to the "BufFill",
 *					FUNCARD: "shmFromBufFill"
 *					SYSCARD: "shmToBufFill"
 *		unsigned AckOff;  <<	offset to the "BufAck"
 *					FUNCARD: "shmToBufAck"
 *					SYSCARD: "shmFromBufAck"
 *
 * description	Check for transmit completion. The action is
 *		based on the "fill" bit and the "ack" bit.
 *		"fill"	"ack" 	action
 *		1	1	Buffer has been read, reset fill bit
 *
 *
 * returns	nothing
 */

CheckTxCompletion(int slot, unsigned FillOff, unsigned AckOff)
	
	{
	int	i;
	unsigned short	AckBuffer;
	unsigned short	TxBuffer;
	unsigned short	TmpTxBuffer;
	unsigned short	AckBits;

	/*
	 *	check for completion of Tx buffer
	 */
	adm_read(slot, AckOff, sizeof(AckBuffer), (char*)&AckBuffer);
	if (AckBuffer == 0)
		return;
	adm_read(slot, FillOff, sizeof(TxBuffer), (char FAR *)&TxBuffer);
	TmpTxBuffer = TxBuffer;
	AckBits = 0;
	for (i = 0; i < ADMBUFF && AckBuffer != 0; 
		i++, AckBuffer >>= 1, TxBuffer >>= 1)
		{
		/*
		 *	we handle the case where
		 *	the received has set the "ack" bit.
		 *	i.e.
		 *	"fill" = 1,  "ack" = 1.
		 *	We have to reset the "fill" bit.
		 */
		if ( (TxBuffer & 1) && (AckBuffer & 1) )
			{
			AckBits |= (1 << i);
			}
		}
	if (AckBits != 0)
		{
		TmpTxBuffer &= ~AckBits;
		adm_write(slot, FillOff, sizeof(TmpTxBuffer), 
			(char FAR *)&TmpTxBuffer);
		}
	}

/*
 *	look for a free buffer from the "BufAck" and "BufFill".
 */
GetFreeBuffer(unsigned AckBuffList, unsigned TxBuffList)

	{
	int	i;

	for (i = 0; i < ADMBUFF; i++, AckBuffList >>= 1, TxBuffList >>= 1)
		{
		if ( ((TxBuffList & 1)) == 0 && ((AckBuffList & 1) == 0)) 
			return i;
		}
#ifdef ADM_DEBUG
	AdmDebugMessage("Error: No Tx buffer\n");
#endif
	return -1;
	}

/*
 * name		AdmImmedCommand
 *
 * synopsis	AdmImmedCommand(slot, CmdType, CmdData, DataLength)
 *		int	slot; <<	In the SYSCARD:-
 *					to the FUNCARD in this slot
 *					1 <= slot <= 13.
 *					In the FUNCARD:-
 *					0
 *		int	CmdType; <<	what is this command, i.e.
 *					ICMPCHANGEIP, ICMP_CON_CLOSE ...etc
 *		void	FAR *CmdDate; <<	Command specific data.
 *						no data for ICMD_CONS_CLOSE,
 *						or ICMD_FUNCARD_RESET.
 *						IP pr NETMASK for 
 *						ICMPCHANGEIP and 
 *						ICMP_CHANGE_NETMASK.
 *		int	DataLenght; <<		length of CmdData.
 *
 * description	Send the "CmdType" immediate command 
 *		from the FUNCARD to the SYSCARD.
 *
 * returns	0		SYSCARD has accepted the command	
 *		non-zero	error code
 */

AdmImmedCommand(int slot, int CmdType, void FAR *CmdData, int DataLength)

	{
	ADM_ICMD	Cmd;	/* the command buffer	*/
	ADM_IRSP	Rsp;	/* the response buffer	*/
	int	ret;	/* return code		*/

	memset((char FAR *)&Rsp, '\0', sizeof(Rsp));
	Cmd.iCmdType = CmdType;
	Cmd.iCmdLength = sizeof(Cmd.iCmdType) + sizeof(Cmd.iCmdLength) + DataLength;
	memcpy((char FAR *)&Cmd.iCmdData, (char FAR *)CmdData, DataLength);
	ret = adm_cmd(slot, &Cmd, Cmd.iCmdLength, &Rsp);
	if (ret == E_SUCCESS && Rsp.iRspType == IRSPNACK)
		{
		/*
		 *	If we get a NACK, 
		 *	we return the reason for the NACK to
		 *	the caller.
		 */
		ret = Rsp.iRspData.iRspReason;
		}
	return ret;
	}
/*
 *	Clear the traffic counters
 */
void AdmClearCounters()
	{
	memset((char FAR *)&AdminCounters, 0, sizeof(AdminCounters));
	}




