/* product.h - This file defines TOKEN RING Concentrator product specifics values */
/*----------------------------------------------------------------

   Hughes LAN System.
   Mountain View, CA.

   CopyRight(c) 1991.
   All Rights Reserved

   Author:  Pedro E. Rangel

   Rev    Date    Who   Comments
  -----  -------- ---   ------------------------------------------
  00.00  12/15/92 PER   Initial software version.
  $ Log: $
  ----------------------------------------------------------------
*/

#ifndef PRODUCT_H
/*----------------------------------------------------------------
	Admin Bus Related definitions
  ----------------------------------------------------------------*/
#define RING_MAP_BYTE   4
#define POWER_REQUIRED  22	/* power req. for base board 	  */
#define POWER_REQ_EXT	3	/* power req. for extension board */	
#define POWER_REQ_RIRO	5	/* power req. for RIRO board	  */	
#define MILLI_AMP_REQUIRED 4000 /* mA req. for base board	  */
#define MILLI_AMP_REQ_EXT  500	/* mA req. for extension board	  */ 
#define MILLI_AMP_REQ_RIRO 800	/* mA req. for RIRO board	  */

/*----------------------------------------------------------------
	STACK Related definitions
  ----------------------------------------------------------------*/
#define MAC_IFS         1
#define MAX_INTFS	2

#define IF_NAME		"Hughes LAN Systems Token Ring Concentrator Version 1.0"
#define IF_MTU		2043
#define IF_SPEED	(get_token_ring_speed() == SIXTEEN_MEGABIT ? 16000000:4000000)
#define IF_TYPE		9

/*
* default defines for the manufactures record
*/
#define DEFAULT_PORTS	16
#define DEFAULT_MODEL	0x20363135

#endif
