
/*

Queue data types

 *	$Log:   /shasta/home/pvcs/include/a_queue.h_v  $
 * 
 *    Rev 1.5   01 Oct 1992 17:00:30   markv
 * Slight problem with the prototype declaration of search and next.
 * 
 *    Rev 1.4   01 Oct 1992 16:35:48   markv
 * Added two more function prototypes - missed them out earlier.
 * 
 *    Rev 1.3   15 Sep 1992 11:39:04   jang
 * added ifndef _A_QUEUE_H_ to avoid multiple include
 * 
 *    Rev 1.2   11 Sep 1992 09:52:38   markv
 * Made the declaration of FAR and NULL sensitive to whether they're declared already.
 *
*/

#ifndef _A_QUEUE_H_
#define _A_QUEUE_H_



#ifndef FAR
#define FAR
#endif
#ifndef NULL
#define NULL ((void FAR *) 0)
#endif

typedef void FAR * q_node_p ;

typedef struct QUEUE_NODE {
     q_node_p prev;
     q_node_p next;
#ifndef save_space
     q_node_p my_self;
     /* Points to the location this is the node for */
     unsigned short int sane;
     /* Used by self-checker to trap cycles in queues */
     unsigned short int order;
     /* Used by the list handling to maintain sort order. */
#endif
} queue_node ;

typedef struct QUEUE_HEAD {
     queue_node queue_list;
     /* Queue heads themselves are placed in a list */
     void FAR * front;
     void FAR * back;
     unsigned int offset;
     /* The offset into the structure of the q_nodes */
     unsigned int size;
     /* The number of entries in the queue - if empty = 0 */
#ifdef QUEUESEM
     SEMPTR queue_sem;
     /* Use semaphores, if allowed */
#else
     unsigned int queue_sem;
     /* Otherwise, use critical regions, and this counter */
#endif
     char FAR * queue_name;
     /* Points to a string describing this queue */
     void (*queue_pfunc)(void FAR *);
     /* points to a function that can print data on this node */
     int (*queue_order)(void FAR *, void FAR *);
     /* points to a function that can detirmine order on the nodes */
    unsigned int queue_options;
    /* Mask of options that apply to this queue */
} queue_head;

#define q_offset(record,q_node)  \
((unsigned int)((unsigned int)&record##.##q_node - (unsigned int)&record))

/* Options to be specified at open time */

#define STRICT_ERROR_CHECKS (0x01)
#define SORTED_QUEUE	(0x02)
#define UNIQUE_QUEUE	(0x04)

/* Each queue is defined as one of the following */

#define DOUBLE_LINKED_LIST (0x10)
#define CIRCULAR_QUEUE (0x20)


extern queue_head list_of_queues;   /* Root queue */

void a_queue_init ( void );
void open_queue (queue_head FAR * new_head, unsigned int offset,
	  char FAR * name,
	  int options,
	  void (*prt_func)(void FAR *),
	  int (*order_func)(void FAR *, void FAR *)
);
int close_queue(queue_head FAR * head);
void FAR * pop_queue (queue_head FAR * head);
int push_queue (queue_head FAR * head, void FAR * new_node);
int append_queue (queue_head FAR * head, void FAR * new_node);
void FAR * de_queue (queue_head FAR * head);
int insert_queue (queue_head FAR * head, void FAR * new_node, void * after_node);
int inject_queue (queue_head FAR * head, void FAR * new_node);
int detatch_queue (queue_head FAR * head, void FAR * old_node );
int is_empty_queue (queue_head FAR * head);
int size_of_queue (queue_head FAR * head);
void FAR * first_in_queue (queue_head FAR * head);
void FAR * last_in_queue (queue_head FAR * head);
void FAR * next_in_queue (queue_head FAR * head, void FAR * this_node);
void FAR * prev_in_queue (queue_head FAR * head, void FAR * this_node);
int print_queue (const queue_head FAR * head, const int level );
int dump_queue(const queue_head FAR * head );
int scan_queue(const queue_head FAR * head, const void FAR * this);
void * get_next_queue(queue_head FAR * head, void FAR * this);
void * search_queue(queue_head FAR * head, void FAR * this);


#endif
