/**
 *	Program Name:	nim960 nvram driver 
 *
 *	Filename:	nvram.h
 *
 *	$Log:   /shasta/pvcs/i960/include/nvram.h_v  $
 * 
 *    Rev 1.2   02 Oct 1992 12:01:52   holeman
 * 
 *    Rev 1.1   29 Jul 1992 09:39:56   holeman
 * 
 *    Rev 1.0   01 Jul 1992 14:27:26   holeman
 * Initial revision.
 *
 *	Comments:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/

#ifndef __NVRAM_H
#define __NVRAM_H

#ifndef __TYPES_H
#include <types.h>
#endif

#ifndef __MEMORY_H
#include <memory.h>
#endif

#define MAX_NVRAM_RECS	128

/*	All the NVRAM reccords should start on a even boundary and */
/*	the size should also be even */
/* 	nvram_hdr structure contains information about all the     */
/* 	NVRAM records, the starting address and the size */

typedef struct nvram_hdr
	{
		struct nvr_recs 
		{
			byte	*start_addr;
			int	size;
		} nvr_recs[MAX_NVRAM_RECS];
		u_short nvhd_cksm;
	} NVRAM_HDR;


#define NVRAM_PAGE_SIZE 32
#define NVRAM_HDR_ADDR  NVRAM
#define NVRAM_HDR_SIZE  ALIGN(sizeof(NVRAM_HDR),2)

/*	NVRAM error definitions 	*/

#define NVRAM_AOK	0	/* No error */
#define NVRAM_ALNERR	1	/* the offset or the size is odd */
#define NVRAM_NOSUCH	2	/* The block is not defined in the header */
#define NVRAM_CSERR	3	/* Checksum error */
#define NVRAM_NOSPACE	4
#define NVRAM_BADSIZE	5
#define NVRAM_NO_MARKER	6

extern  NVRAM_HDR	Nvram_header;

#endif
