/****************************************************************************
 *     Copyright (c) 1986, 1988  Epilogue Technology Corporation
 *     All rights reserved.
 *
 *     This is unpublished proprietary source code of Epilogue Technology
 *     Corporation.
 *
 *     The copyright notice above does not evidence any actual or intended
 *     publication of such source code.
 *
 *	$Log:   /usr/shasta/hub/trx/i960/include/decode.h_v  $
 * 
 *    Rev 1.0   01 Jul 1992 14:26:54   holeman
 * Initial revision.
 *
 ****************************************************************************/

#ifndef	decode_inc
#define	decode_inc
#ifndef	asn1_inc
#include <asn1.h>
#endif
#ifndef	localio_inc
#include <localio.h>
#endif
#ifndef	buffer_inc
#include <buffer.h>
#endif

/****************************************************************************
NAME:  A_DecodeTypeClass

PURPOSE:  Decode the Class and Form bits from an ASN.1 type field.
	  The data stream is read using the local I/O package.
	  The stream pointer is NOT advanced, leaving it pointing to the
	  start of the type field, ready for a subsequent call to
	  A_DecodeTypeValue.

CAVEAT:	  The user should call this return *BEFORE* calling
	  A_DecodeTypeValue.

PARAMETERS:  LCL_FILE *	    A stream descriptor (already open)

RETURNS:  OCTET_T	    The Class and Form bits

RESTRICTIONS:  It is assumed that the stream is not at EOF.
****************************************************************************/

#define A_DecodeTypeClass(L) (((OCTET_T) Lcl_Peekc((LCL_FILE *)(L))) &	\
			      A_IDCF_MASK)

extern	ATVALUE_T	A_DecodeTypeValue(LCL_FILE *);
extern	ALENGTH_T	A_DecodeLength(LCL_FILE *);
extern	void		A_DecodeOctetStringData(LCL_FILE *, ALENGTH_T,
ALENGTH_T,
EBUFFER_P , ALENGTH_T);
extern	void		A_DecodeOctetString(LCL_FILE *,
EBUFFER_P , ALENGTH_T);
extern	INT_32_T	A_DecodeIntegerData(LCL_FILE *, ALENGTH_T);
extern	INT_32_T	A_DecodeInteger(LCL_FILE *);
extern	int 		A_DecodeObjectIdData(LCL_FILE *, ALENGTH_T,
OBJ_ID_T  *);
extern	int     	A_DecodeObjectId(LCL_FILE *, OBJ_ID_T   *);
extern	void		A_DecodeHelper(EBUFFER_P , LCL_FILE *, ALENGTH_T);

#endif
