/**			       
*
*	Program Name:	nim960 bootp client
*
*	Filename:	bootp.h
*
*	$Log:   /shasta/pvcs/i960/include/bootp.h_v  $
 * 
 *    Rev 1.1   05 Jan 1993 14:25:14   holeman
 * add error codes
 * 
 *    Rev 1.0   01 Jul 1992 14:26:48   holeman
 * Initial revision.
*
*	Creation Date:	not known
*
*	Date:		4.23.91
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:	Kwok Kong	2.23.91
*			Port to nim960 V3+ kernel.
*
*	Comments:	
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
 * Bootstrap Protocol (BOOTP).  RFC951 and RFC1048.
 *
 * $Header:   /shasta/pvcs/i960/include/bootp.h_v   1.1   05 Jan 1993 14:25:14   holeman  $
 *
 *
 * This file specifies the "implementation-independent" BOOTP protocol
 * information which is common to both client and server.
 *
 *
 * Copyright 1988 by Carnegie Mellon.
 *
 * Permission to use, copy, modify, and distribute this program for any
 * purpose and without fee is hereby granted, provided that this copyright
 * and permission notice appear on all copies and supporting documentation,
 * the name of Carnegie Mellon not be used in advertising or publicity
 * pertaining to distribution of the program without specific prior
 * permission, and notice be given in supporting documentation that copying
 * and distribution is by permission of Carnegie Mellon and Stanford
 * University.  Carnegie Mellon makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 */
#define	BP_FILENAME_LENGTH	128
#define	BP_MYNAME_LENGTH	64
#define	BP_VENDOR_LENGTH	64



struct bootp 
	{
	unsigned char	bp_op;		/* packet opcode type */
	unsigned char	bp_htype;	/* hardware addr type */
	unsigned char	bp_hlen;	/* hardware addr length */
	unsigned char	bp_hops;	/* gateway hops */
	unsigned long	bp_xid;		/* transaction ID */
	unsigned short	bp_secs;	/* seconds since boot began */
	unsigned short	bp_unused;
	in_name		bp_ciaddr;	/* client IP address */
	in_name		bp_yiaddr;	/* 'your' IP address */
	in_name		bp_siaddr;	/* server IP address */
	in_name		bp_giaddr;	/* gateway IP address */
	unsigned char	bp_chaddr[16];	/* client hardware address */
	unsigned char	bp_sname[BP_MYNAME_LENGTH]; /* server host name */
	unsigned char	bp_file[BP_FILENAME_LENGTH]; /* boot file name */
	unsigned char	bp_vend[BP_VENDOR_LENGTH]; /* vendor-specific area */
	};
/*
 *	warning: sizeof(struct bootp) will be be 300 due to
 *	the padding. 
 */
#define	UNPADDED_BOOTP_SIZE	300

#define BOOTREPLY		2
#define BOOTREQUEST		1


/*
 * Vendor magic cookie (v_magic) for CMU
 */
#define VM_CMU		"CMU"

/*
 * Vendor magic cookie (v_magic) for RFC1048
 */
#define VM_RFC1048	{ 99, 130, 83, 99 }

/*
 * RFC1048 tag values used to specify what information is being supplied in
 * the vendor field of the packet.
 */

#define TAG_PAD			0	
#define TAG_SUBNET_MASK		1
#define TAG_TIME_OFFSET		2
#define TAG_GATEWAY		3
#define TAG_TIME_SERVER		4
#define TAG_NAME_SERVER		5
#define TAG_DOMAIN_SERVER	6
#define TAG_LOG_SERVER		7
#define TAG_COOKIE_SERVER	8
#define TAG_LPR_SERVER		9
#define TAG_IMPRESS_SERVER	10
#define TAG_RLP_SERVER		11
#define TAG_HOSTNAME		12
#define TAG_BOOTSIZE		13
#define TAG_END			255



#define	BP_MAX_IP	4	/*	We accept this many ip addresses
				 *	in bootp reply in each ip address
				 *	categories.
				 *	i.e.	router addresses, 
				 *		domain name server addreess
				 *		...etc
				 */
struct	bootpinfo
	{
	in_name	yiaddr;		/*	my ip address returned from
				 *	bootp server
				 */
	in_name	siaddr;		/*	bootp server ip adderss	*/
	in_name	NetMask;	/*	subnet mask field	*/
	in_name	Router[BP_MAX_IP];	/*	routers ip addresses	*/
	in_name	DomainNameServer[BP_MAX_IP];
	in_name	TimeServer[BP_MAX_IP];	/*	time server ip 		*/
	char	file[BP_FILENAME_LENGTH];	/*	boot file name	*/
	long	TimeOffset;	/*	time offset of the local subnet
				 *	in seconds from UTC.
				 */
	char	MyHostName[BP_MYNAME_LENGTH];
	};



#define	INIT_TIMEOUT	200	/*	first timeout is 2 seconds	*/
#define	MAX_TIMEOUT	2000	/*	max timeout is 20 seconds	*/
#define	MAX_RETRIES	3	/*	retry this many times		*/

#define	E_OK			0
#define	E_BAD_MY_IP		11
#define	E_BAD_SERVER_IP		12
#define	E_NO_CONFIG_FILE	13
#define	E_NO_VALID_ROUTER	14
#define	E_BOARD_MOVED		15
#define	E_TMS_ERROR		16
#define	E_BOOTP_ERROR		17

extern struct	bootpinfo	bootpinfo;
